/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.finger;

import io.mosip.biometrics.util.AbstractImageInfo;
import io.mosip.biometrics.util.finger.FingerCaptureDeviceTechnology;
import io.mosip.biometrics.util.finger.FingerCaptureDeviceType;
import io.mosip.biometrics.util.finger.FingerCaptureDeviceVendor;
import io.mosip.biometrics.util.finger.FingerCertificationBlock;
import io.mosip.biometrics.util.finger.FingerCertificationFlag;
import io.mosip.biometrics.util.finger.FingerImageBitDepth;
import io.mosip.biometrics.util.finger.FingerImageCompressionType;
import io.mosip.biometrics.util.finger.FingerImpressionType;
import io.mosip.biometrics.util.finger.FingerPosition;
import io.mosip.biometrics.util.finger.FingerQualityBlock;
import io.mosip.biometrics.util.finger.FingerScaleUnitType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepresentationHeader
extends AbstractImageInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepresentationHeader.class);
    private int representationDataLength;
    private int representationLength;
    private Date captureDateTime;
    private int captureYear;
    private int captureMonth;
    private int captureDay;
    private int captureHour;
    private int captureMinute;
    private int captureSecond;
    private int captureMilliSecond;
    private FingerCaptureDeviceTechnology captureDeviceTechnologyIdentifier;
    private FingerCaptureDeviceVendor captureDeviceVendorIdentifier;
    private FingerCaptureDeviceType captureDeviceTypeIdentifier;
    private int noOfQualityBlocks;
    private FingerQualityBlock[] qualityBlocks;
    private FingerCertificationFlag certificationFlag;
    private int noOfCertificationBlocks;
    private FingerCertificationBlock[] certificationBlocks;
    private FingerPosition fingerPosition;
    private int representationNo;
    private FingerScaleUnitType scaleUnits;
    private int captureDeviceSpatialSamplingRateHorizontal;
    private int captureDeviceSpatialSamplingRateVertical;
    private int imageSpatialSamplingRateHorizontal;
    private int imageSpatialSamplingRateVertical;
    private FingerImageBitDepth bitDepth;
    private FingerImageCompressionType compressionType;
    private FingerImpressionType impressionType;
    private int lineLengthHorizontal;
    private int lineLengthVertical;

    public RepresentationHeader(int representationDataLength, Date captureDate, FingerQualityBlock[] qualityBlocks, FingerCertificationFlag certificationFlag, FingerCertificationBlock[] certificationBlocks, FingerPosition fingerPosition, int representationNo, FingerScaleUnitType scaleUnitType) {
        this.setRepresentationDataLength(representationDataLength);
        this.setCaptureDateTime(captureDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(captureDate);
        this.setCaptureYear(calendar.get(1));
        this.setCaptureMonth(calendar.get(2));
        this.setCaptureDay(calendar.get(5));
        this.setCaptureHour(calendar.get(11));
        this.setCaptureMinute(calendar.get(12));
        this.setCaptureSecond(calendar.get(13));
        this.setCaptureMilliSecond(calendar.get(14));
        this.setCaptureDeviceTechnologyIdentifier(FingerCaptureDeviceTechnology.UNSPECIFIED);
        this.setCaptureDeviceVendorIdentifier(FingerCaptureDeviceVendor.UNSPECIFIED);
        this.setCaptureDeviceTypeIdentifier(FingerCaptureDeviceType.UNSPECIFIED);
        this.setNoOfQualityBlocks(qualityBlocks.length);
        this.setQualityBlocks(qualityBlocks);
        this.setCertificationFlag(certificationFlag);
        this.setNoOfCertificationBlocks(certificationBlocks.length);
        this.setCertificationBlocks(certificationBlocks);
        this.setFingerPosition(fingerPosition);
        this.setRepresentationNo(representationNo);
        this.setScaleUnits(scaleUnitType);
        this.setCaptureDeviceSpatialSamplingRateHorizontal(0);
        this.setCaptureDeviceSpatialSamplingRateVertical(0);
        this.setImageSpatialSamplingRateHorizontal(0);
        this.setImageSpatialSamplingRateVertical(0);
        this.setBitDepth(FingerImageBitDepth.BPP_08);
        this.setCompressionType(FingerImageCompressionType.JPEG_2000_LOSS_LESS);
        this.setImpressionType(FingerImpressionType.UNKNOWN);
        this.setLineLengthHorizontal(0);
        this.setLineLengthVertical(0);
    }

    public RepresentationHeader(int representationDataLength, Date captureDate, FingerCaptureDeviceTechnology captureDeviceTechnologyIdentifier, FingerCaptureDeviceVendor captureDeviceVendorIdentifier, FingerCaptureDeviceType captureDeviceTypeIdentifier, FingerQualityBlock[] qualityBlocks, FingerCertificationFlag certificationFlag, FingerCertificationBlock[] certificationBlocks, FingerPosition fingerPosition, int representationNo, FingerScaleUnitType scaleUnitType, int captureDeviceSpatialSamplingRateHorizontal, int captureDeviceSpatialSamplingRateVertical, int imageSpatialSamplingRateHorizontal, int imageSpatialSamplingRateVertical, FingerImageBitDepth bitDepth, FingerImageCompressionType compressionType, FingerImpressionType impressionType, int lineLengthHorizontal, int lineLengthVertical) {
        this.setRepresentationDataLength(representationDataLength);
        this.setCaptureDateTime(captureDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(captureDate);
        this.setCaptureYear(calendar.get(1));
        this.setCaptureMonth(calendar.get(2));
        this.setCaptureDay(calendar.get(5));
        this.setCaptureHour(calendar.get(11));
        this.setCaptureMinute(calendar.get(12));
        this.setCaptureSecond(calendar.get(13));
        this.setCaptureMilliSecond(calendar.get(14));
        this.setCaptureDeviceTechnologyIdentifier(FingerCaptureDeviceTechnology.UNSPECIFIED);
        this.setCaptureDeviceVendorIdentifier(FingerCaptureDeviceVendor.UNSPECIFIED);
        this.setCaptureDeviceTypeIdentifier(FingerCaptureDeviceType.UNSPECIFIED);
        this.setNoOfQualityBlocks(qualityBlocks != null && qualityBlocks.length > 0 ? qualityBlocks.length : 0);
        this.setQualityBlocks(qualityBlocks);
        this.setCertificationFlag(certificationFlag);
        this.setNoOfCertificationBlocks(certificationBlocks != null && certificationBlocks.length > 0 ? certificationBlocks.length : 0);
        this.setCertificationBlocks(certificationBlocks);
        this.setFingerPosition(fingerPosition);
        this.setRepresentationNo(representationNo);
        this.setScaleUnits(scaleUnitType);
        this.setCaptureDeviceSpatialSamplingRateHorizontal(captureDeviceSpatialSamplingRateHorizontal);
        this.setCaptureDeviceSpatialSamplingRateVertical(captureDeviceSpatialSamplingRateVertical);
        this.setImageSpatialSamplingRateHorizontal(imageSpatialSamplingRateHorizontal);
        this.setImageSpatialSamplingRateVertical(imageSpatialSamplingRateVertical);
        this.setBitDepth(bitDepth);
        this.setCompressionType(compressionType);
        this.setImpressionType(impressionType);
        this.setLineLengthHorizontal(lineLengthHorizontal);
        this.setLineLengthVertical(lineLengthVertical);
    }

    public RepresentationHeader(DataInputStream inputStream, FingerCertificationFlag certificationFlag) throws IOException {
        this.setCertificationFlag(certificationFlag);
        this.readObject(inputStream);
    }

    @Override
    protected void readObject(DataInputStream inputStream) throws IOException {
        this.setRepresentationDataLength((int)((long)inputStream.readInt() & 0xFFFFFFFFL));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        this.setCaptureYear(inputStream.readUnsignedShort());
        this.setCaptureMonth(inputStream.readUnsignedByte());
        this.setCaptureDay(inputStream.readUnsignedByte());
        this.setCaptureHour(inputStream.readUnsignedByte());
        this.setCaptureMinute(inputStream.readUnsignedByte());
        this.setCaptureSecond(inputStream.readUnsignedByte());
        this.setCaptureMilliSecond(inputStream.readUnsignedShort());
        calendar.set(1, this.getCaptureYear());
        calendar.set(2, this.getCaptureMonth() - 1);
        calendar.set(5, this.getCaptureDay());
        calendar.set(11, this.getCaptureHour());
        calendar.set(12, this.getCaptureMinute());
        calendar.set(13, this.getCaptureSecond());
        calendar.set(14, this.getCaptureMilliSecond());
        this.setCaptureDateTime(calendar.getTime());
        this.setCaptureDeviceTechnologyIdentifier(FingerCaptureDeviceTechnology.fromValue(inputStream.readUnsignedByte()));
        int captureDeviceVendorIdentifier = inputStream.readUnsignedShort();
        try {
            this.setCaptureDeviceVendorIdentifier(FingerCaptureDeviceVendor.fromValue(captureDeviceVendorIdentifier));
        }
        catch (Exception ex) {
            LOGGER.error("setCaptureDeviceVendorIdentifier :: Not Defined :: captureDeviceVendorIdentifier :: " + Integer.toHexString(captureDeviceVendorIdentifier));
        }
        int captureDeviceTypeIdentifier = inputStream.readUnsignedShort();
        try {
            this.setCaptureDeviceTypeIdentifier(FingerCaptureDeviceType.fromValue(captureDeviceTypeIdentifier));
        }
        catch (Exception ex) {
            LOGGER.error("setCaptureDeviceTypeIdentifier :: Not Defined :: captureDeviceTypeIdentifier :: " + Integer.toHexString(captureDeviceTypeIdentifier));
        }
        this.setNoOfQualityBlocks(inputStream.readUnsignedByte());
        FingerQualityBlock[] qualityBlock = new FingerQualityBlock[this.getNoOfQualityBlocks()];
        if (this.getNoOfQualityBlocks() > 0) {
            for (int index = 0; index < this.getNoOfQualityBlocks(); ++index) {
                qualityBlock[index] = new FingerQualityBlock(inputStream);
            }
        }
        this.setQualityBlocks(qualityBlock);
        if (this.getCertificationFlag() == FingerCertificationFlag.ONE) {
            this.setNoOfCertificationBlocks(inputStream.readUnsignedByte());
            FingerCertificationBlock[] certificationBlocks = new FingerCertificationBlock[this.getNoOfCertificationBlocks()];
            if (this.getNoOfCertificationBlocks() > 0) {
                for (int index = 0; index < this.getNoOfCertificationBlocks(); ++index) {
                    certificationBlocks[index] = new FingerCertificationBlock(inputStream);
                }
            }
            this.setCertificationBlocks(certificationBlocks);
        }
        int fingerPosition = inputStream.readUnsignedByte();
        try {
            this.setFingerPosition(FingerPosition.fromValue(fingerPosition));
        }
        catch (Exception ex) {
            LOGGER.error("setFingerPosition :: Not Defined :: fingerPosition :: " + Integer.toHexString(fingerPosition));
        }
        this.setRepresentationNo(inputStream.readUnsignedByte());
        int scaleUnits = inputStream.readUnsignedByte();
        try {
            this.setScaleUnits(FingerScaleUnitType.fromValue(scaleUnits));
        }
        catch (Exception ex) {
            LOGGER.error("setScaleUnits :: Not Defined :: scaleUnits :: " + Integer.toHexString(scaleUnits));
        }
        this.setCaptureDeviceSpatialSamplingRateHorizontal(inputStream.readUnsignedShort());
        this.setCaptureDeviceSpatialSamplingRateVertical(inputStream.readUnsignedShort());
        this.setImageSpatialSamplingRateHorizontal(inputStream.readUnsignedShort());
        this.setImageSpatialSamplingRateVertical(inputStream.readUnsignedShort());
        int bitDepth = inputStream.readUnsignedByte();
        try {
            this.setBitDepth(FingerImageBitDepth.fromValue(bitDepth));
        }
        catch (Exception ex) {
            LOGGER.error("setBitDepth :: Not Defined :: bitDepth :: " + Integer.toHexString(bitDepth));
        }
        int compressionType = inputStream.readUnsignedByte();
        try {
            this.setCompressionType(FingerImageCompressionType.fromValue(compressionType));
        }
        catch (Exception ex) {
            LOGGER.error("setCompressionType :: Not Defined :: compressionType :: " + Integer.toHexString(compressionType));
        }
        int impressionType = inputStream.readUnsignedByte();
        try {
            this.setImpressionType(FingerImpressionType.fromValue(impressionType));
        }
        catch (Exception ex) {
            LOGGER.error("setImpressionType :: Not Defined :: impressionType :: " + Integer.toHexString(impressionType));
        }
        this.setLineLengthHorizontal(inputStream.readUnsignedShort());
        this.setLineLengthVertical(inputStream.readUnsignedShort());
    }

    @Override
    public int getRecordLength() {
        int qualityBlockRecordLength = 0;
        if (this.getQualityBlocks() != null && this.getQualityBlocks().length > 0) {
            for (int index = 0; index < this.getQualityBlocks().length; ++index) {
                qualityBlockRecordLength += this.getQualityBlocks()[index].getRecordLength();
            }
        }
        int certificationBlockRecordLength = 0;
        if (this.getCertificationFlag() == FingerCertificationFlag.ONE) {
            certificationBlockRecordLength = 1;
            if (this.getCertificationBlocks() != null && this.getCertificationBlocks().length > 0) {
                for (int index = 0; index < this.getCertificationBlocks().length; ++index) {
                    certificationBlockRecordLength += this.getCertificationBlocks()[index].getRecordLength();
                }
            }
        }
        return 19 + qualityBlockRecordLength + certificationBlockRecordLength + 1 + 1 + 1 + 2 + 2 + 2 + 2 + 1 + 1 + 1 + 2 + 2;
    }

    @Override
    public void writeObject(DataOutputStream outputStream) throws IOException {
        int index;
        outputStream.writeInt(this.getRecordLength() + this.getRepresentationDataLength());
        outputStream.writeShort(this.getCaptureYear());
        outputStream.writeByte(this.getCaptureMonth() + 1);
        outputStream.writeByte(this.getCaptureDay());
        outputStream.writeByte(this.getCaptureHour());
        outputStream.writeByte(this.getCaptureMinute());
        outputStream.writeByte(this.getCaptureSecond());
        outputStream.writeShort(this.getCaptureMilliSecond());
        outputStream.writeByte(this.getCaptureDeviceTechnologyIdentifier().value());
        outputStream.writeShort(this.getCaptureDeviceVendorIdentifier().value());
        outputStream.writeShort(this.getCaptureDeviceTypeIdentifier().value());
        outputStream.writeByte(this.getNoOfQualityBlocks());
        if (this.getQualityBlocks() != null) {
            for (index = 0; index < this.getQualityBlocks().length; ++index) {
                this.getQualityBlocks()[index].writeObject(outputStream);
            }
        }
        if (this.getCertificationFlag() == FingerCertificationFlag.ONE) {
            if (this.getCertificationBlocks() != null && this.getCertificationBlocks().length > 0) {
                outputStream.writeByte(this.getNoOfCertificationBlocks());
                for (index = 0; index < this.getCertificationBlocks().length; ++index) {
                    this.getCertificationBlocks()[index].writeObject(outputStream);
                }
            } else {
                LOGGER.error("getCertificationBlocks :: Not Defined ::  If FingerCertificationFlag.ONE :: ");
            }
        }
        outputStream.writeByte(this.getFingerPosition().value());
        outputStream.writeByte(this.getRepresentationNo());
        outputStream.writeByte(this.getScaleUnits().value());
        outputStream.writeShort(this.getCaptureDeviceSpatialSamplingRateHorizontal());
        outputStream.writeShort(this.getCaptureDeviceSpatialSamplingRateVertical());
        outputStream.writeShort(this.getImageSpatialSamplingRateHorizontal());
        outputStream.writeShort(this.getImageSpatialSamplingRateVertical());
        outputStream.writeByte(this.getBitDepth().value());
        outputStream.writeByte(this.getCompressionType().value());
        outputStream.writeByte(this.getImpressionType().value());
        outputStream.writeShort(this.getLineLengthHorizontal());
        outputStream.writeShort(this.getLineLengthVertical());
        outputStream.flush();
    }

    public int getRepresentationDataLength() {
        return this.representationDataLength;
    }

    public void setRepresentationDataLength(int representationDataLength) {
        this.representationDataLength = representationDataLength;
    }

    public int getRepresentationLength() {
        return this.representationLength;
    }

    public void setRepresentationLength(int representationLength) {
        this.representationLength = representationLength;
    }

    public Date getCaptureDateTime() {
        return this.captureDateTime;
    }

    public void setCaptureDateTime(Date captureDateTime) {
        this.captureDateTime = captureDateTime;
    }

    public int getCaptureYear() {
        return this.captureYear;
    }

    public void setCaptureYear(int captureYear) {
        this.captureYear = captureYear;
    }

    public int getCaptureMonth() {
        return this.captureMonth;
    }

    public void setCaptureMonth(int captureMonth) {
        this.captureMonth = captureMonth;
    }

    public int getCaptureDay() {
        return this.captureDay;
    }

    public void setCaptureDay(int captureDay) {
        this.captureDay = captureDay;
    }

    public int getCaptureHour() {
        return this.captureHour;
    }

    public void setCaptureHour(int captureHour) {
        this.captureHour = captureHour;
    }

    public int getCaptureMinute() {
        return this.captureMinute;
    }

    public void setCaptureMinute(int captureMinute) {
        this.captureMinute = captureMinute;
    }

    public int getCaptureSecond() {
        return this.captureSecond;
    }

    public void setCaptureSecond(int captureSecond) {
        this.captureSecond = captureSecond;
    }

    public int getCaptureMilliSecond() {
        return this.captureMilliSecond;
    }

    public void setCaptureMilliSecond(int captureMilliSecond) {
        this.captureMilliSecond = captureMilliSecond;
    }

    public FingerCaptureDeviceTechnology getCaptureDeviceTechnologyIdentifier() {
        return this.captureDeviceTechnologyIdentifier;
    }

    public void setCaptureDeviceTechnologyIdentifier(FingerCaptureDeviceTechnology captureDeviceTechnologyIdentifier) {
        this.captureDeviceTechnologyIdentifier = captureDeviceTechnologyIdentifier;
    }

    public FingerCaptureDeviceVendor getCaptureDeviceVendorIdentifier() {
        return this.captureDeviceVendorIdentifier;
    }

    public void setCaptureDeviceVendorIdentifier(FingerCaptureDeviceVendor captureDeviceVendorIdentifier) {
        this.captureDeviceVendorIdentifier = captureDeviceVendorIdentifier;
    }

    public FingerCaptureDeviceType getCaptureDeviceTypeIdentifier() {
        return this.captureDeviceTypeIdentifier;
    }

    public void setCaptureDeviceTypeIdentifier(FingerCaptureDeviceType captureDeviceTypeIdentifier) {
        this.captureDeviceTypeIdentifier = captureDeviceTypeIdentifier;
    }

    public int getNoOfQualityBlocks() {
        return this.noOfQualityBlocks;
    }

    public void setNoOfQualityBlocks(int noOfQualityBlocks) {
        this.noOfQualityBlocks = noOfQualityBlocks;
    }

    public FingerQualityBlock[] getQualityBlocks() {
        return this.qualityBlocks;
    }

    public void setQualityBlocks(FingerQualityBlock[] qualityBlocks) {
        this.qualityBlocks = qualityBlocks;
    }

    public FingerCertificationFlag getCertificationFlag() {
        return this.certificationFlag;
    }

    public void setCertificationFlag(FingerCertificationFlag certificationFlag) {
        this.certificationFlag = certificationFlag;
    }

    public int getNoOfCertificationBlocks() {
        return this.noOfCertificationBlocks;
    }

    public void setNoOfCertificationBlocks(int noOfCertificationBlocks) {
        this.noOfCertificationBlocks = noOfCertificationBlocks;
    }

    public FingerCertificationBlock[] getCertificationBlocks() {
        return this.certificationBlocks;
    }

    public void setCertificationBlocks(FingerCertificationBlock[] certificationBlocks) {
        this.certificationBlocks = certificationBlocks;
    }

    public FingerPosition getFingerPosition() {
        return this.fingerPosition;
    }

    public void setFingerPosition(FingerPosition fingerPosition) {
        this.fingerPosition = fingerPosition;
    }

    public int getRepresentationNo() {
        return this.representationNo;
    }

    public void setRepresentationNo(int representationNo) {
        this.representationNo = representationNo;
    }

    public FingerScaleUnitType getScaleUnits() {
        return this.scaleUnits;
    }

    public void setScaleUnits(FingerScaleUnitType scaleUnits) {
        this.scaleUnits = scaleUnits;
    }

    public int getCaptureDeviceSpatialSamplingRateHorizontal() {
        return this.captureDeviceSpatialSamplingRateHorizontal;
    }

    public void setCaptureDeviceSpatialSamplingRateHorizontal(int captureDeviceSpatialSamplingRateHorizontal) {
        this.captureDeviceSpatialSamplingRateHorizontal = captureDeviceSpatialSamplingRateHorizontal;
    }

    public int getCaptureDeviceSpatialSamplingRateVertical() {
        return this.captureDeviceSpatialSamplingRateVertical;
    }

    public void setCaptureDeviceSpatialSamplingRateVertical(int captureDeviceSpatialSamplingRateVertical) {
        this.captureDeviceSpatialSamplingRateVertical = captureDeviceSpatialSamplingRateVertical;
    }

    public int getImageSpatialSamplingRateHorizontal() {
        return this.imageSpatialSamplingRateHorizontal;
    }

    public void setImageSpatialSamplingRateHorizontal(int imageSpatialSamplingRateHorizontal) {
        this.imageSpatialSamplingRateHorizontal = imageSpatialSamplingRateHorizontal;
    }

    public int getImageSpatialSamplingRateVertical() {
        return this.imageSpatialSamplingRateVertical;
    }

    public void setImageSpatialSamplingRateVertical(int imageSpatialSamplingRateVertical) {
        this.imageSpatialSamplingRateVertical = imageSpatialSamplingRateVertical;
    }

    public FingerImageBitDepth getBitDepth() {
        return this.bitDepth;
    }

    public void setBitDepth(FingerImageBitDepth bitDepth) {
        this.bitDepth = bitDepth;
    }

    public FingerImageCompressionType getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(FingerImageCompressionType compressionType) {
        this.compressionType = compressionType;
    }

    public FingerImpressionType getImpressionType() {
        return this.impressionType;
    }

    public void setImpressionType(FingerImpressionType impressionType) {
        this.impressionType = impressionType;
    }

    public int getLineLengthHorizontal() {
        return this.lineLengthHorizontal;
    }

    public void setLineLengthHorizontal(int lineLengthHorizontal) {
        this.lineLengthHorizontal = lineLengthHorizontal;
    }

    public int getLineLengthVertical() {
        return this.lineLengthVertical;
    }

    public void setLineLengthVertical(int lineLengthVertical) {
        this.lineLengthVertical = lineLengthVertical;
    }

    public String toString() {
        return "\nRepresentationHeader [RecordLength=" + this.getRecordLength() + ", representationDataLength=" + this.representationDataLength + ", representationLength=" + this.representationLength + ", captureDateTime=" + this.captureDateTime + ", captureYear=" + this.captureYear + ", captureMonth=" + this.captureMonth + ", captureDay=" + this.captureDay + ", captureHour=" + this.captureHour + ", captureMinute=" + this.captureMinute + ", captureSecond=" + this.captureSecond + ", captureMilliSecond=" + this.captureMilliSecond + ", captureDeviceTechnologyIdentifier=" + this.captureDeviceTechnologyIdentifier + ", captureDeviceVendorIdentifier=" + this.captureDeviceVendorIdentifier + ", captureDeviceTypeIdentifier=" + this.captureDeviceTypeIdentifier + ", noOfQualityBlocks=" + this.noOfQualityBlocks + ", qualityBlocks=" + Arrays.toString(this.qualityBlocks) + ", certificationFlag=" + this.certificationFlag + ", noOfCertificationBlocks=" + this.noOfCertificationBlocks + ", certificationBlocks=" + Arrays.toString(this.certificationBlocks) + ", fingerPosition=" + this.fingerPosition + ", representationNo=" + this.representationNo + ", scaleUnits=" + this.scaleUnits + ", captureDeviceSpatialSamplingRateHorizontal=" + this.captureDeviceSpatialSamplingRateHorizontal + ", captureDeviceSpatialSamplingRateVertical=" + this.captureDeviceSpatialSamplingRateVertical + ", imageSpatialSamplingRateHorizontal=" + this.imageSpatialSamplingRateHorizontal + ", imageSpatialSamplingRateVertical=" + this.imageSpatialSamplingRateVertical + ", bitDepth=" + this.bitDepth + ", compressionType=" + this.compressionType + ", impressionType=" + this.impressionType + ", lineLengthHorizontal=" + Integer.toHexString(this.lineLengthHorizontal) + ", lineLengthVertical=" + Integer.toHexString(this.lineLengthVertical) + "]\n";
    }
}

