/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.finger;

import io.mosip.biometrics.util.finger.ExtendedDataBlock;
import io.mosip.biometrics.util.finger.ExtendedDataBlockIdentificationCode;
import io.mosip.biometrics.util.finger.FingerQualityAlgorithmIdentifier;
import io.mosip.biometrics.util.finger.FingerQualityAlgorithmVendorIdentifier;
import io.mosip.biometrics.util.finger.FingerSegmentationAlgorithmIdentifier;
import io.mosip.biometrics.util.finger.FingerSegmentationAlgorithmVendorIdentifier;
import io.mosip.biometrics.util.finger.SegmentationData;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentationBlock
extends ExtendedDataBlock {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentationBlock.class);
    private int segmentationQualityScore;
    private FingerSegmentationAlgorithmVendorIdentifier segmentationAlgorithmVendorIdentifier;
    private FingerSegmentationAlgorithmIdentifier segmentationAlgorithmIdentifier;
    private FingerQualityAlgorithmIdentifier qualityAlgorithmIdentifier;
    private FingerQualityAlgorithmVendorIdentifier qualityAlgorithmVendorIdentifier;
    private int noOfSegmentationData;
    private SegmentationData[] segmentationData;

    public SegmentationBlock(int segmentationQualityScore, int noOfSegmentationData, SegmentationData[] segmentationData) {
        this.setSegmentationAlgorithmVendorIdentifier(FingerSegmentationAlgorithmVendorIdentifier.ALGORITHM_VENDOR_IDENTIFIER);
        this.setSegmentationAlgorithmIdentifier(FingerSegmentationAlgorithmIdentifier.ALGORITHM_IDENTIFIER);
        this.setSegmentationQualityScore(segmentationQualityScore);
        this.setQualityAlgorithmIdentifier(FingerQualityAlgorithmIdentifier.ALGORITHM_IDENTIFIER);
        this.setQualityAlgorithmVendorIdentifier(FingerQualityAlgorithmVendorIdentifier.ALGORITHM_VENDOR_IDENTIFIER);
        this.setNoOfSegmentationData(noOfSegmentationData);
        this.setSegmentationData(segmentationData);
        this.setExtendedDataBlockIdentificationCode(ExtendedDataBlockIdentificationCode.SEGMENTATION);
        this.setLengthOfExtendedDataBlock(this.getRecordLength());
    }

    public SegmentationBlock(FingerSegmentationAlgorithmVendorIdentifier segmentationAlgorithmVendorIdentifier, FingerSegmentationAlgorithmIdentifier segmentationAlgorithmIdentifier, int segmentationQualityScore, int noOfSegmentationData, SegmentationData[] segmentationData) {
        this.setSegmentationAlgorithmVendorIdentifier(segmentationAlgorithmVendorIdentifier);
        this.setSegmentationAlgorithmIdentifier(segmentationAlgorithmIdentifier);
        this.setSegmentationQualityScore(segmentationQualityScore);
        this.setQualityAlgorithmIdentifier(this.qualityAlgorithmIdentifier);
        this.setQualityAlgorithmVendorIdentifier(this.qualityAlgorithmVendorIdentifier);
        this.setNoOfSegmentationData(noOfSegmentationData);
        this.setSegmentationData(segmentationData);
        this.setExtendedDataBlockIdentificationCode(ExtendedDataBlockIdentificationCode.SEGMENTATION);
        this.setLengthOfExtendedDataBlock(this.getRecordLength());
    }

    public SegmentationBlock(DataInputStream inputStream) throws IOException {
        this.readObject(inputStream);
    }

    @Override
    protected void readObject(DataInputStream inputStream) throws IOException {
        this.setLengthOfExtendedDataBlock(inputStream.readUnsignedShort());
        int segmentationAlgorithmVendorIdentifier = inputStream.readUnsignedShort();
        try {
            this.setSegmentationAlgorithmVendorIdentifier(FingerSegmentationAlgorithmVendorIdentifier.fromValue(segmentationAlgorithmVendorIdentifier));
        }
        catch (Exception ex) {
            LOGGER.error("setSegmentationAlgorithmVendorIdentifier :: Not Defined :: segmentationAlgorithmVendorIdentifier :: " + Integer.toHexString(segmentationAlgorithmVendorIdentifier));
        }
        int segmentationAlgorithmIdentifier = inputStream.readUnsignedShort();
        try {
            this.setSegmentationAlgorithmIdentifier(FingerSegmentationAlgorithmIdentifier.fromValue(segmentationAlgorithmIdentifier));
        }
        catch (Exception ex) {
            LOGGER.error("setSegmentationAlgorithmIdentifier :: Not Defined :: segmentationAlgorithmIdentifier :: " + Integer.toHexString(segmentationAlgorithmIdentifier));
        }
        this.setSegmentationQualityScore(inputStream.readUnsignedByte());
        int qualityAlgorithmIdentifier = inputStream.readUnsignedShort();
        try {
            this.setQualityAlgorithmIdentifier(FingerQualityAlgorithmIdentifier.fromValue(qualityAlgorithmIdentifier));
        }
        catch (Exception ex) {
            LOGGER.error("setQualityAlgorithmIdentifier :: Not Defined :: qualityAlgorithmIdentifier :: " + Integer.toHexString(qualityAlgorithmIdentifier));
        }
        int qualityAlgorithmVendorIdentifier = inputStream.readUnsignedShort();
        try {
            this.setQualityAlgorithmVendorIdentifier(FingerQualityAlgorithmVendorIdentifier.fromValue(qualityAlgorithmVendorIdentifier));
        }
        catch (Exception ex) {
            LOGGER.error("setQualityAlgorithmVendorIdentifier :: Not Defined :: qualityAlgorithmVendorIdentifier :: " + Integer.toHexString(qualityAlgorithmVendorIdentifier));
        }
        this.setNoOfSegmentationData(inputStream.readUnsignedByte());
        if (this.getNoOfSegmentationData() > 0) {
            SegmentationData[] segmentationData = new SegmentationData[this.getNoOfSegmentationData()];
            for (int index = 0; index < this.getNoOfSegmentationData(); ++index) {
                segmentationData[index] = new SegmentationData(inputStream);
            }
            this.setSegmentationData(segmentationData);
        }
    }

    @Override
    public int getRecordLength() {
        int recordLength = 0;
        if (this.getNoOfSegmentationData() > 0) {
            for (int index = 0; index < this.getNoOfSegmentationData(); ++index) {
                recordLength += this.getSegmentationData()[index].getRecordLength();
            }
        }
        return 14 + recordLength;
    }

    @Override
    public void writeObject(DataOutputStream outputStream) throws IOException {
        outputStream.writeShort(this.getExtendedDataBlockIdentificationCode().value());
        outputStream.writeShort(this.getLengthOfExtendedDataBlock());
        outputStream.writeShort(this.getSegmentationAlgorithmVendorIdentifier().value());
        outputStream.writeShort(this.getSegmentationAlgorithmIdentifier().value());
        outputStream.writeByte(this.getSegmentationQualityScore());
        outputStream.writeShort(this.getQualityAlgorithmIdentifier().value());
        outputStream.writeShort(this.getQualityAlgorithmVendorIdentifier().value());
        outputStream.writeByte(this.getNoOfSegmentationData());
        if (this.getNoOfSegmentationData() > 0) {
            for (int index = 0; index < this.getNoOfSegmentationData(); ++index) {
                this.getSegmentationData()[index].writeObject(outputStream);
            }
        }
        outputStream.flush();
    }

    public int getSegmentationQualityScore() {
        return this.segmentationQualityScore;
    }

    public void setSegmentationQualityScore(int segmentationQualityScore) {
        this.segmentationQualityScore = segmentationQualityScore;
    }

    public FingerSegmentationAlgorithmVendorIdentifier getSegmentationAlgorithmVendorIdentifier() {
        return this.segmentationAlgorithmVendorIdentifier;
    }

    public void setSegmentationAlgorithmVendorIdentifier(FingerSegmentationAlgorithmVendorIdentifier segmentationAlgorithmVendorIdentifier) {
        this.segmentationAlgorithmVendorIdentifier = segmentationAlgorithmVendorIdentifier;
    }

    public FingerSegmentationAlgorithmIdentifier getSegmentationAlgorithmIdentifier() {
        return this.segmentationAlgorithmIdentifier;
    }

    public void setSegmentationAlgorithmIdentifier(FingerSegmentationAlgorithmIdentifier segmentationAlgorithmIdentifier) {
        this.segmentationAlgorithmIdentifier = segmentationAlgorithmIdentifier;
    }

    public FingerQualityAlgorithmVendorIdentifier getQualityAlgorithmVendorIdentifier() {
        return this.qualityAlgorithmVendorIdentifier;
    }

    public void setQualityAlgorithmVendorIdentifier(FingerQualityAlgorithmVendorIdentifier qualityAlgorithmVendorIdentifier) {
        this.qualityAlgorithmVendorIdentifier = qualityAlgorithmVendorIdentifier;
    }

    public FingerQualityAlgorithmIdentifier getQualityAlgorithmIdentifier() {
        return this.qualityAlgorithmIdentifier;
    }

    public void setQualityAlgorithmIdentifier(FingerQualityAlgorithmIdentifier qualityAlgorithmIdentifier) {
        this.qualityAlgorithmIdentifier = qualityAlgorithmIdentifier;
    }

    public int getNoOfSegmentationData() {
        return this.noOfSegmentationData;
    }

    public void setNoOfSegmentationData(int noOfSegmentationData) {
        this.noOfSegmentationData = noOfSegmentationData;
    }

    public SegmentationData[] getSegmentationData() {
        return this.segmentationData;
    }

    public void setSegmentationData(SegmentationData[] segmentationData) {
        this.segmentationData = segmentationData;
    }

    @Override
    public String toString() {
        super.toString();
        return "\nSegmentationBlock [RecordLength=" + this.getRecordLength() + ", segmentationAlgorithmVendorIdentifier=" + this.segmentationAlgorithmVendorIdentifier + ", segmentationAlgorithmIdentifier=" + this.segmentationAlgorithmIdentifier + ", segmentationQualityScore=" + Integer.toHexString(this.segmentationQualityScore) + ", qualityAlgorithmIdentifier=" + this.qualityAlgorithmIdentifier + ", qualityAlgorithmVendorIdentifier=" + this.qualityAlgorithmVendorIdentifier + ", noOfSegmentationData=" + this.noOfSegmentationData + ", segmentationData=" + Arrays.toString(this.segmentationData) + "]\n";
    }
}

