/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.finger;

import io.mosip.biometrics.util.AbstractImageInfo;
import io.mosip.biometrics.util.finger.FingerPosition;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentationData
extends AbstractImageInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentationData.class);
    private FingerPosition fingerPosition;
    private int qualityScore;
    private int noOfCoordinates;
    private int[] XCoordinates;
    private int[] YCoordinates;
    private int fingerOrientation;

    public SegmentationData(int qualityScore) {
        this.setFingerPosition(FingerPosition.UNKNOWN);
        this.setQualityScore(qualityScore);
        this.setNoOfCoordinates(2);
        this.setXCoordinates(new int[2]);
        this.setYCoordinates(new int[2]);
        for (int index = 0; index < this.getNoOfCoordinates(); ++index) {
            this.getXCoordinates()[index] = 0;
            this.getYCoordinates()[index] = 0;
        }
        this.setFingerOrientation(0);
    }

    public SegmentationData(FingerPosition fingerPosition, int qualityScore, int noOfCoordinates, int[] xCoordinates, int[] yCoordinates, int fingerOrientation) {
        this.setFingerPosition(fingerPosition);
        this.setQualityScore(qualityScore);
        this.setNoOfCoordinates(noOfCoordinates);
        this.setXCoordinates(xCoordinates);
        this.setYCoordinates(yCoordinates);
        this.setFingerOrientation(fingerOrientation);
    }

    public SegmentationData(DataInputStream inputStream) throws IOException {
        this.readObject(inputStream);
    }

    @Override
    protected void readObject(DataInputStream inputStream) throws IOException {
        this.setFingerPosition(FingerPosition.fromValue(inputStream.readUnsignedByte()));
        this.setQualityScore(inputStream.readUnsignedByte());
        this.setNoOfCoordinates(inputStream.readUnsignedByte());
        this.setXCoordinates(new int[this.getNoOfCoordinates()]);
        this.setYCoordinates(new int[this.getNoOfCoordinates()]);
        for (int index = 0; index < this.getNoOfCoordinates(); ++index) {
            this.getXCoordinates()[index] = inputStream.readUnsignedShort();
            this.getYCoordinates()[index] = inputStream.readUnsignedShort();
        }
        this.setFingerOrientation(inputStream.readUnsignedByte());
    }

    @Override
    public int getRecordLength() {
        int recordLength = 0;
        if (this.getNoOfCoordinates() > 0) {
            for (int index = 0; index < this.getNoOfCoordinates(); ++index) {
                recordLength += 4;
            }
        }
        return 3 + recordLength + 1;
    }

    @Override
    public void writeObject(DataOutputStream outputStream) throws IOException {
        outputStream.writeByte(this.getFingerPosition().value());
        outputStream.writeByte(this.getQualityScore());
        outputStream.writeByte(this.getNoOfCoordinates());
        for (int index = 0; index < this.getNoOfCoordinates(); ++index) {
            outputStream.writeShort(this.getXCoordinates()[index]);
            outputStream.writeShort(this.getYCoordinates()[index]);
        }
        outputStream.writeByte(this.getFingerOrientation());
        outputStream.flush();
    }

    public FingerPosition getFingerPosition() {
        return this.fingerPosition;
    }

    public void setFingerPosition(FingerPosition fingerPosition) {
        this.fingerPosition = fingerPosition;
    }

    public int getQualityScore() {
        return this.qualityScore;
    }

    public void setQualityScore(int qualityScore) {
        this.qualityScore = qualityScore;
    }

    public int getNoOfCoordinates() {
        return this.noOfCoordinates;
    }

    public void setNoOfCoordinates(int noOfCoordinates) {
        this.noOfCoordinates = noOfCoordinates;
    }

    public int[] getXCoordinates() {
        return this.XCoordinates;
    }

    public void setXCoordinates(int[] xCoordinates) {
        this.XCoordinates = xCoordinates;
    }

    public int[] getYCoordinates() {
        return this.YCoordinates;
    }

    public void setYCoordinates(int[] yCoordinates) {
        this.YCoordinates = yCoordinates;
    }

    public int getFingerOrientation() {
        return this.fingerOrientation;
    }

    public void setFingerOrientation(int fingerOrientation) {
        this.fingerOrientation = fingerOrientation;
    }

    public String toString() {
        return "\nSegmentationData [RecordLength=" + this.getRecordLength() + ", fingerPosition=" + this.fingerPosition + ", qualityScore=" + this.qualityScore + ", noOfCoordinates=" + this.noOfCoordinates + ", XCoordinates=" + Arrays.toString(this.XCoordinates) + ", YCoordinates=" + Arrays.toString(this.YCoordinates) + ", fingerOrientation=" + this.fingerOrientation + "]\n";
    }
}

