/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.iris;

import io.mosip.biometrics.util.AbstractImageInfo;
import io.mosip.biometrics.util.iris.IrisCertificationFlag;
import io.mosip.biometrics.util.iris.IrisFormatIdentifier;
import io.mosip.biometrics.util.iris.IrisVersionNumber;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralHeader
extends AbstractImageInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneralHeader.class);
    private IrisFormatIdentifier formatIdentifier;
    private IrisVersionNumber versionNumber;
    private int totalRepresentationLength;
    private int noOfRepresentations;
    private IrisCertificationFlag certificationFlag;
    private int noOfEyesPresent;

    public GeneralHeader(int totalRepresentationLength, int noOfRepresentations, int noOfEyesPresent) {
        this.setFormatIdentifier(IrisFormatIdentifier.FORMAT_IIR);
        this.setVersionNumber(IrisVersionNumber.VERSION_020);
        this.setTotalRepresentationLength(totalRepresentationLength);
        this.setNoOfRepresentations(noOfRepresentations);
        this.setCertificationFlag(IrisCertificationFlag.UNSPECIFIED);
        this.setNoOfEyesPresent(noOfEyesPresent);
    }

    public GeneralHeader(IrisFormatIdentifier formatIdentifier, IrisVersionNumber versionNumber, int totalRepresentationLength, int noOfRepresentations, IrisCertificationFlag certificationFlag, int noOfEyesPresent) {
        this.setFormatIdentifier(formatIdentifier);
        this.setVersionNumber(versionNumber);
        this.setTotalRepresentationLength(totalRepresentationLength);
        this.setNoOfRepresentations(noOfRepresentations);
        this.setCertificationFlag(certificationFlag);
        this.setNoOfEyesPresent(noOfEyesPresent);
    }

    public GeneralHeader(DataInputStream inputStream) throws IOException {
        this.readObject(inputStream);
    }

    @Override
    protected void readObject(DataInputStream inputStream) throws IOException {
        this.setFormatIdentifier(IrisFormatIdentifier.fromValue((int)((long)inputStream.readInt() & 0xFFFFFFFFL)));
        this.setVersionNumber(IrisVersionNumber.fromValue((int)((long)inputStream.readInt() & 0xFFFFFFFFL)));
        this.setTotalRepresentationLength((int)(((long)inputStream.readInt() & 0xFFFFFFFFL) - (long)this.getRecordLength()));
        this.setNoOfRepresentations(inputStream.readUnsignedShort());
        this.setCertificationFlag(IrisCertificationFlag.fromValue(inputStream.readUnsignedByte()));
        this.setNoOfEyesPresent(inputStream.readUnsignedByte());
    }

    @Override
    public int getRecordLength() {
        return 16;
    }

    @Override
    protected void writeObject(DataOutputStream outputStream) throws IOException {
        outputStream.writeInt(this.getFormatIdentifier().value());
        outputStream.writeInt(this.getVersionNumber().value());
        outputStream.writeInt(this.getRecordLength() + this.getTotalRepresentationLength());
        outputStream.writeShort(this.getNoOfRepresentations());
        outputStream.writeByte(this.getCertificationFlag().value());
        outputStream.writeByte(this.getNoOfEyesPresent());
        outputStream.flush();
    }

    public IrisFormatIdentifier getFormatIdentifier() {
        return this.formatIdentifier;
    }

    public void setFormatIdentifier(IrisFormatIdentifier formatIdentifier) {
        this.formatIdentifier = formatIdentifier;
    }

    public IrisVersionNumber getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(IrisVersionNumber versionNumber) {
        this.versionNumber = versionNumber;
    }

    public int getTotalRepresentationLength() {
        return this.totalRepresentationLength;
    }

    public void setTotalRepresentationLength(int totalRepresentationLength) {
        this.totalRepresentationLength = totalRepresentationLength;
    }

    public int getNoOfRepresentations() {
        return this.noOfRepresentations;
    }

    public void setNoOfRepresentations(int noOfRepresentations) {
        this.noOfRepresentations = noOfRepresentations;
    }

    public IrisCertificationFlag getCertificationFlag() {
        return this.certificationFlag;
    }

    public void setCertificationFlag(IrisCertificationFlag certificationFlag) {
        this.certificationFlag = certificationFlag;
    }

    public int getNoOfEyesPresent() {
        return this.noOfEyesPresent;
    }

    public void setNoOfEyesPresent(int noOfEyesPresent) {
        this.noOfEyesPresent = noOfEyesPresent;
    }

    public String toString() {
        return "\nIrisGeneralHeader [GeneralHeaderRecordLength=" + this.getRecordLength() + ", formatIdentifier=" + this.formatIdentifier + ", versionNumber=" + this.versionNumber + ", totalRepresentationLength=" + this.totalRepresentationLength + ", noOfRepresentations=" + this.noOfRepresentations + ", certificationFlag=" + this.certificationFlag + ", noOfEyesPresent=" + this.noOfEyesPresent + "]\n";
    }
}

