/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.iris;

public enum ImageFormat {
    MONO_RAW(2),
    RGB_RAW(4),
    MONO_JPEG(6),
    RGB_JPEG(8),
    MONO_JPEG2000_LOSS_LESS(10),
    RGB_JPEG2000_LOSS_LESS(12),
    MONO_PNG(14),
    RGB_PNG(16);

    private final int value;

    private ImageFormat(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ImageFormat fromValue(int value) {
        for (ImageFormat c : ImageFormat.values()) {
            if (c.value != value) continue;
            return c;
        }
        throw new IllegalArgumentException("" + value);
    }

    public String toString() {
        return super.toString() + "(" + Integer.toHexString(this.value) + ")";
    }
}

