/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.iris;

import io.mosip.biometrics.util.AbstractImageInfo;
import io.mosip.biometrics.util.iris.EyeLabel;
import io.mosip.biometrics.util.iris.ImageFormat;
import io.mosip.biometrics.util.iris.ImageType;
import io.mosip.biometrics.util.iris.IrisImageBitDepth;
import io.mosip.biometrics.util.iris.IrisImageCompressionType;
import io.mosip.biometrics.util.iris.Orientation;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageInformation
extends AbstractImageInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageInformation.class);
    private EyeLabel eyeLabel;
    private ImageType imageType;
    private ImageFormat imageFormat;
    private Orientation horizontalOrientation;
    private Orientation verticalOrientation;
    private IrisImageCompressionType compressionType;
    private int width;
    private int height;
    private IrisImageBitDepth bitDepth;
    private int range;
    private int rollAngleOfEye;
    private int rollAngleUncertainty;
    private int irisCenterSmallestX;
    private int irisCenterLargestX;
    private int irisCenterSmallestY;
    private int irisCenterLargestY;
    private int irisDiameterSmallest;
    private int irisDiameterLargest;

    public ImageInformation(EyeLabel eyeLabel, ImageType imageType, ImageFormat imageFormat, Orientation horizontalOrientation, Orientation verticalOrientation, IrisImageCompressionType compressionType, int width, int height, IrisImageBitDepth bitDepth, int range, int rollAngleOfEye, int rollAngleUncertainty, int irisCenterSmallestX, int irisCenterLargestX, int irisCenterSmallestY, int irisCenterLargestY, int irisDiameterSmallest, int irisDiameterLargest) {
        this.setEyeLabel(eyeLabel);
        this.setImageType(imageType);
        this.setImageFormat(imageFormat);
        this.setHorizontalOrientation(horizontalOrientation);
        this.setVerticalOrientation(verticalOrientation);
        this.setCompressionType(compressionType);
        this.setWidth(width);
        this.setHeight(height);
        this.setBitDepth(bitDepth);
        this.setRange(range);
        this.setRollAngleOfEye(rollAngleOfEye);
        this.setRollAngleUncertainty(rollAngleUncertainty);
        this.setIrisCenterSmallestX(irisCenterSmallestX);
        this.setIrisCenterLargestX(irisCenterLargestX);
        this.setIrisCenterSmallestY(irisCenterSmallestY);
        this.setIrisCenterLargestY(irisCenterLargestY);
        this.setIrisDiameterSmallest(irisDiameterSmallest);
        this.setIrisDiameterLargest(irisDiameterLargest);
    }

    public ImageInformation(DataInputStream inputStream) throws IOException {
        this.readObject(inputStream);
    }

    @Override
    protected void readObject(DataInputStream inputStream) throws IOException {
        int eyeLabel = inputStream.readUnsignedByte();
        try {
            this.setEyeLabel(EyeLabel.fromValue(eyeLabel));
        }
        catch (Exception ex) {
            LOGGER.error("setEyeLabel :: Not Defined :: eyeLabel :: " + eyeLabel);
        }
        int imageType = inputStream.readUnsignedByte();
        try {
            this.setImageType(ImageType.fromValue(imageType));
        }
        catch (Exception ex) {
            LOGGER.error("setImageType :: Not Defined :: imageType :: " + imageType);
        }
        int imageFormat = inputStream.readUnsignedByte();
        try {
            this.setImageFormat(ImageFormat.fromValue(imageFormat));
        }
        catch (Exception ex) {
            LOGGER.error("setImageFormat :: Not Defined :: imageFormat :: " + imageFormat);
        }
        int imagePropertiesBits = inputStream.readUnsignedByte();
        int horizontalOrientation = imagePropertiesBits & 3;
        try {
            this.setHorizontalOrientation(Orientation.fromValue(horizontalOrientation));
        }
        catch (Exception ex) {
            LOGGER.error("setHorizontalOrientation :: Not Defined :: horizontalOrientation :: " + horizontalOrientation);
        }
        int verticalOrientation = (imagePropertiesBits & 0xC) >> 2;
        try {
            this.setVerticalOrientation(Orientation.fromValue(verticalOrientation));
        }
        catch (Exception ex) {
            LOGGER.error("setVerticalOrientation :: Not Defined :: verticalOrientation :: " + verticalOrientation);
        }
        int futureType = (imagePropertiesBits & 0x60) >> 2;
        int compressionType = (imagePropertiesBits & 0x80) >> 2;
        try {
            this.setCompressionType(IrisImageCompressionType.fromValue(compressionType));
        }
        catch (Exception ex) {
            LOGGER.error("setCompressionType :: Not Defined :: compressionType :: " + compressionType);
        }
        this.setWidth(inputStream.readUnsignedShort());
        this.setHeight(inputStream.readUnsignedShort());
        int bitDepth = inputStream.readUnsignedByte();
        try {
            this.setBitDepth(IrisImageBitDepth.fromValue(bitDepth));
        }
        catch (Exception ex) {
            LOGGER.error("setBitDepth :: Not Defined :: bitDepth :: " + bitDepth);
        }
        this.setRange(inputStream.readUnsignedShort());
        this.setRollAngleOfEye(inputStream.readUnsignedShort());
        this.setRollAngleUncertainty(inputStream.readUnsignedShort());
        this.setIrisCenterSmallestX(inputStream.readUnsignedShort());
        this.setIrisCenterLargestX(inputStream.readUnsignedShort());
        this.setIrisCenterSmallestY(inputStream.readUnsignedShort());
        this.setIrisCenterLargestY(inputStream.readUnsignedShort());
        this.setIrisDiameterSmallest(inputStream.readUnsignedShort());
        this.setIrisDiameterLargest(inputStream.readUnsignedShort());
    }

    @Override
    public int getRecordLength() {
        return 27;
    }

    @Override
    public void writeObject(DataOutputStream outputStream) throws IOException {
        outputStream.writeByte(this.getEyeLabel().value());
        outputStream.writeByte(this.getImageType().value());
        outputStream.writeByte(this.getImageFormat().value());
        int imagePropertiesBits = 0;
        imagePropertiesBits = (byte)(imagePropertiesBits | this.getHorizontalOrientation().value() & 3);
        imagePropertiesBits = (byte)(imagePropertiesBits | this.getVerticalOrientation().value() << 2 & 0xC);
        imagePropertiesBits = (byte)(imagePropertiesBits | 0);
        imagePropertiesBits = (byte)(imagePropertiesBits | this.getCompressionType().value() << 2 & 0x80);
        outputStream.writeByte(imagePropertiesBits);
        outputStream.writeShort(this.getWidth());
        outputStream.writeShort(this.getHeight());
        outputStream.writeByte(this.getBitDepth().value());
        outputStream.writeShort(this.getRange());
        outputStream.writeShort(this.getRollAngleOfEye());
        outputStream.writeShort(this.getRollAngleUncertainty());
        outputStream.writeShort(this.getIrisCenterSmallestX());
        outputStream.writeShort(this.getIrisCenterLargestX());
        outputStream.writeShort(this.getIrisCenterSmallestY());
        outputStream.writeShort(this.getIrisCenterLargestY());
        outputStream.writeShort(this.getIrisDiameterSmallest());
        outputStream.writeShort(this.getIrisDiameterLargest());
        outputStream.flush();
    }

    public EyeLabel getEyeLabel() {
        return this.eyeLabel;
    }

    public void setEyeLabel(EyeLabel eyeLabel) {
        this.eyeLabel = eyeLabel;
    }

    public ImageType getImageType() {
        return this.imageType;
    }

    public void setImageType(ImageType imageType) {
        this.imageType = imageType;
    }

    public ImageFormat getImageFormat() {
        return this.imageFormat;
    }

    public void setImageFormat(ImageFormat imageFormat) {
        this.imageFormat = imageFormat;
    }

    public Orientation getHorizontalOrientation() {
        return this.horizontalOrientation;
    }

    public void setHorizontalOrientation(Orientation horizontalOrientation) {
        this.horizontalOrientation = horizontalOrientation;
    }

    public Orientation getVerticalOrientation() {
        return this.verticalOrientation;
    }

    public void setVerticalOrientation(Orientation verticalOrientation) {
        this.verticalOrientation = verticalOrientation;
    }

    public IrisImageCompressionType getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(IrisImageCompressionType compressionType) {
        this.compressionType = compressionType;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public IrisImageBitDepth getBitDepth() {
        return this.bitDepth;
    }

    public void setBitDepth(IrisImageBitDepth bitDepth) {
        this.bitDepth = bitDepth;
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int range) {
        this.range = range;
    }

    public int getRollAngleOfEye() {
        return this.rollAngleOfEye;
    }

    public void setRollAngleOfEye(int rollAngleOfEye) {
        this.rollAngleOfEye = rollAngleOfEye;
    }

    public int getRollAngleUncertainty() {
        return this.rollAngleUncertainty;
    }

    public void setRollAngleUncertainty(int rollAngleUncertainty) {
        this.rollAngleUncertainty = rollAngleUncertainty;
    }

    public int getIrisCenterSmallestX() {
        return this.irisCenterSmallestX;
    }

    public void setIrisCenterSmallestX(int irisCenterSmallestX) {
        this.irisCenterSmallestX = irisCenterSmallestX;
    }

    public int getIrisCenterLargestX() {
        return this.irisCenterLargestX;
    }

    public void setIrisCenterLargestX(int irisCenterLargestX) {
        this.irisCenterLargestX = irisCenterLargestX;
    }

    public int getIrisCenterSmallestY() {
        return this.irisCenterSmallestY;
    }

    public void setIrisCenterSmallestY(int irisCenterSmallestY) {
        this.irisCenterSmallestY = irisCenterSmallestY;
    }

    public int getIrisCenterLargestY() {
        return this.irisCenterLargestY;
    }

    public void setIrisCenterLargestY(int irisCenterLargestY) {
        this.irisCenterLargestY = irisCenterLargestY;
    }

    public int getIrisDiameterSmallest() {
        return this.irisDiameterSmallest;
    }

    public void setIrisDiameterSmallest(int irisDiameterSmallest) {
        this.irisDiameterSmallest = irisDiameterSmallest;
    }

    public int getIrisDiameterLargest() {
        return this.irisDiameterLargest;
    }

    public void setIrisDiameterLargest(int irisDiameterLargest) {
        this.irisDiameterLargest = irisDiameterLargest;
    }

    public String toString() {
        return "\nImageInformation [RecordLength=" + this.getRecordLength() + ", eyeLabel=" + this.eyeLabel + ", imageType=" + this.imageType + ", imageFormat=" + this.imageFormat + ", horizontalOrientation=" + this.horizontalOrientation + ", verticalOrientation=" + this.verticalOrientation + ", compressionType=" + this.compressionType + ", width=" + this.width + ", height=" + this.height + ", bitDepth=" + this.bitDepth + ", range=" + this.range + ", rollAngleOfEye=" + this.rollAngleOfEye + ", rollAngleUncertainty=" + this.rollAngleUncertainty + ", irisCenterSmallestX=" + this.irisCenterSmallestX + ", irisCenterLargestX=" + this.irisCenterLargestX + ", irisCenterSmallestY=" + this.irisCenterSmallestY + ", irisCenterLargestY=" + this.irisCenterLargestY + ", irisDiameterSmallest=" + this.irisDiameterSmallest + ", irisDiameterLargest=" + this.irisDiameterLargest + "]\n";
    }
}

