/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.iris;

import io.mosip.biometrics.util.AbstractImageInfo;
import io.mosip.biometrics.util.iris.GeneralHeader;
import io.mosip.biometrics.util.iris.ImageInformation;
import io.mosip.biometrics.util.iris.IrisCaptureDeviceTechnology;
import io.mosip.biometrics.util.iris.IrisCaptureDeviceType;
import io.mosip.biometrics.util.iris.IrisCaptureDeviceVendor;
import io.mosip.biometrics.util.iris.IrisCertificationFlag;
import io.mosip.biometrics.util.iris.IrisFormatIdentifier;
import io.mosip.biometrics.util.iris.IrisQualityBlock;
import io.mosip.biometrics.util.iris.IrisVersionNumber;
import io.mosip.biometrics.util.iris.Representation;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;

public class IrisBDIR
extends AbstractImageInfo {
    private GeneralHeader generalHeader;
    private Representation representation;

    public IrisBDIR(IrisFormatIdentifier formatIdentifier, IrisVersionNumber versionNumber, IrisCertificationFlag certificationFlag, Date captureDate, int noOfRepresentations, IrisQualityBlock[] qualityBlocks, ImageInformation imageInformation, int representationNo, int noOfEyesPresent, byte[] image) {
        this.setRepresentation(new Representation(captureDate, qualityBlocks, imageInformation, representationNo, image));
        int totalRepresentationLength = this.getRepresentation().getRecordLength();
        this.setGeneralHeader(new GeneralHeader(formatIdentifier, versionNumber, totalRepresentationLength, noOfRepresentations, certificationFlag, noOfEyesPresent));
    }

    public IrisBDIR(IrisFormatIdentifier formatIdentifier, IrisVersionNumber versionNumber, IrisCertificationFlag certificationFlag, IrisCaptureDeviceTechnology sourceType, IrisCaptureDeviceVendor deviceVendor, IrisCaptureDeviceType deviceType, Date captureDate, int noOfRepresentations, IrisQualityBlock[] qualityBlocks, ImageInformation imageInformation, int representationNo, int noOfEyesPresent, byte[] image) {
        this.setRepresentation(new Representation(captureDate, sourceType, deviceVendor, deviceType, qualityBlocks, imageInformation, representationNo, image));
        int totalRepresentationLength = this.getRepresentation().getRecordLength();
        this.setGeneralHeader(new GeneralHeader(formatIdentifier, versionNumber, totalRepresentationLength, noOfRepresentations, certificationFlag, noOfEyesPresent));
    }

    public IrisBDIR(DataInputStream inputStream) throws IOException {
        this.readObject(inputStream);
    }

    @Override
    public int getRecordLength() {
        return this.getGeneralHeader().getRecordLength() + 1 * this.getRepresentation().getRecordLength();
    }

    @Override
    protected void readObject(DataInputStream inputStream) throws IOException {
        this.setGeneralHeader(new GeneralHeader(inputStream));
        int generalHeaderLength = this.getGeneralHeader().getRecordLength();
        int noOfRepresentations = this.getGeneralHeader().getNoOfRepresentations();
        int totalRepresentationLength = this.getGeneralHeader().getTotalRepresentationLength();
        if (noOfRepresentations == 1) {
            this.setRepresentation(new Representation(inputStream));
        }
    }

    @Override
    public void writeObject(DataOutputStream outputStream) throws IOException {
        this.getGeneralHeader().writeObject(outputStream);
        this.getRepresentation().writeObject(outputStream);
        outputStream.flush();
    }

    public GeneralHeader getGeneralHeader() {
        return this.generalHeader;
    }

    public void setGeneralHeader(GeneralHeader generalHeader) {
        this.generalHeader = generalHeader;
    }

    public Representation getRepresentation() {
        return this.representation;
    }

    public void setRepresentation(Representation representation) {
        this.representation = representation;
    }

    public String toString() {
        return "\nIrisBDIR [generalHeader=" + this.generalHeader + ", representation=" + this.representation + "]\n";
    }
}

