/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.iris;

import io.mosip.biometrics.util.CommonUtil;
import io.mosip.biometrics.util.ConvertRequestDto;
import io.mosip.biometrics.util.iris.ImageData;
import io.mosip.biometrics.util.iris.ImageFormat;
import io.mosip.biometrics.util.iris.IrisBDIR;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IrisDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(IrisDecoder.class);

    private static IrisBDIR getIrisBDIRISO19794_6_2011(byte[] isoData) throws Exception {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(isoData);){
            IrisBDIR irisBDIR;
            try (DataInputStream inputStream = new DataInputStream(bais);){
                IrisBDIR irisBDIR2 = new IrisBDIR(inputStream);
                LOGGER.info("irisBDIR :: ", (Object)irisBDIR2);
                irisBDIR = irisBDIR2;
            }
            return irisBDIR;
        }
    }

    public static IrisBDIR getIrisBDIR(ConvertRequestDto convertRequestDto) throws Exception {
        switch (convertRequestDto.getVersion()) {
            case "ISO19794_6_2011": {
                return IrisDecoder.getIrisBDIRISO19794_6_2011(convertRequestDto.getInputBytes());
            }
        }
        throw new UnsupportedOperationException();
    }

    private static byte[] convertIrisISO19794_6_2011ToImage(byte[] isoData) throws Exception {
        byte[] byArray;
        ImageData imageData = IrisDecoder.getIrisBDIRISO19794_6_2011(isoData).getRepresentation().getRepresentationData().getImageData();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)ImageIO.read(new ByteArrayInputStream(imageData.getImage())), "jpg", baos);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error("Failed to get iris jpg image", (Throwable)e);
                return imageData.getImage();
            }
        }
        baos.close();
        return byArray;
    }

    public static BufferedImage convertIrisISOToBufferedImage(ConvertRequestDto convertRequestDto) throws Exception {
        switch (convertRequestDto.getVersion()) {
            case "ISO19794_6_2011": {
                IrisBDIR irisBDIR = IrisDecoder.getIrisBDIRISO19794_6_2011(convertRequestDto.getInputBytes());
                return ImageIO.read(new ByteArrayInputStream(irisBDIR.getRepresentation().getRepresentationData().getImageData().getImage()));
            }
        }
        throw new UnsupportedOperationException();
    }

    public static byte[] convertIrisISOToImageBytes(ConvertRequestDto convertRequestDto) throws Exception {
        switch (convertRequestDto.getVersion()) {
            case "ISO19794_6_2011": {
                IrisBDIR irisBDIR = IrisDecoder.getIrisBDIRISO19794_6_2011(convertRequestDto.getInputBytes());
                ImageFormat imageFormat = irisBDIR.getRepresentation().getRepresentationHeader().getImageInformation().getImageFormat();
                switch (imageFormat) {
                    case MONO_JPEG2000_LOSS_LESS: 
                    case RGB_JPEG2000_LOSS_LESS: {
                        return CommonUtil.convertJP2ToJPEGBytes(irisBDIR.getRepresentation().getRepresentationData().getImageData().getImage());
                    }
                }
                return irisBDIR.getRepresentation().getRepresentationData().getImageData().getImage();
            }
        }
        throw new UnsupportedOperationException();
    }
}

