/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.iris;

import io.mosip.biometrics.util.AbstractImageInfo;
import io.mosip.biometrics.util.iris.IrisQualityAlgorithmIdentifier;
import io.mosip.biometrics.util.iris.IrisQualityAlgorithmVendorIdentifier;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IrisQualityBlock
extends AbstractImageInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(IrisQualityBlock.class);
    private int qualityScore;
    private IrisQualityAlgorithmVendorIdentifier qualityAlgorithmVendorIdentifier;
    private IrisQualityAlgorithmIdentifier qualityAlgorithmIdentifier;

    public IrisQualityBlock(int qualityScore) {
        this.setQualityScore(qualityScore);
        this.setQualityAlgorithmVendorIdentifier(IrisQualityAlgorithmVendorIdentifier.ALGORITHM_VENDOR_IDENTIFIER);
        this.setQualityAlgorithmIdentifier(IrisQualityAlgorithmIdentifier.ALGORITHM_IDENTIFIER);
    }

    public IrisQualityBlock(int qualityScore, IrisQualityAlgorithmVendorIdentifier qualityAlgorithmVendorIdentifier, IrisQualityAlgorithmIdentifier qualityAlgorithmIdentifier) {
        this.setQualityScore(qualityScore);
        this.setQualityAlgorithmVendorIdentifier(qualityAlgorithmVendorIdentifier);
        this.setQualityAlgorithmIdentifier(qualityAlgorithmIdentifier);
    }

    public IrisQualityBlock(DataInputStream inputStream) throws IOException {
        this.readObject(inputStream);
    }

    @Override
    protected void readObject(DataInputStream inputStream) throws IOException {
        this.setQualityScore(inputStream.readUnsignedByte());
        this.setQualityAlgorithmVendorIdentifier(IrisQualityAlgorithmVendorIdentifier.fromValue(inputStream.readUnsignedShort()));
        this.setQualityAlgorithmIdentifier(IrisQualityAlgorithmIdentifier.fromValue(inputStream.readUnsignedShort()));
    }

    @Override
    public int getRecordLength() {
        return 5;
    }

    @Override
    public void writeObject(DataOutputStream outputStream) throws IOException {
        outputStream.writeByte(this.getQualityScore());
        outputStream.writeShort(this.getQualityAlgorithmVendorIdentifier().value());
        outputStream.writeShort(this.getQualityAlgorithmIdentifier().value());
        outputStream.flush();
    }

    public int getQualityScore() {
        return this.qualityScore;
    }

    public void setQualityScore(int qualityScore) {
        this.qualityScore = qualityScore;
    }

    public IrisQualityAlgorithmVendorIdentifier getQualityAlgorithmVendorIdentifier() {
        return this.qualityAlgorithmVendorIdentifier;
    }

    public void setQualityAlgorithmVendorIdentifier(IrisQualityAlgorithmVendorIdentifier qualityAlgorithmVendorIdentifier) {
        this.qualityAlgorithmVendorIdentifier = qualityAlgorithmVendorIdentifier;
    }

    public IrisQualityAlgorithmIdentifier getQualityAlgorithmIdentifier() {
        return this.qualityAlgorithmIdentifier;
    }

    public void setQualityAlgorithmIdentifier(IrisQualityAlgorithmIdentifier qualityAlgorithmIdentifier) {
        this.qualityAlgorithmIdentifier = qualityAlgorithmIdentifier;
    }

    public String toString() {
        return "\nIrisQualityBlock [QualityBlockRecordLength=" + this.getRecordLength() + ", qualityScore=" + this.qualityScore + ", qualityAlgorithmVendorIdentifier=" + this.qualityAlgorithmVendorIdentifier + ", qualityAlgorithmIdentifier=" + this.qualityAlgorithmIdentifier + "]\n";
    }
}

