/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.iris;

import io.mosip.biometrics.util.AbstractImageInfo;
import io.mosip.biometrics.util.iris.ImageData;
import io.mosip.biometrics.util.iris.ImageInformation;
import io.mosip.biometrics.util.iris.IrisCaptureDeviceTechnology;
import io.mosip.biometrics.util.iris.IrisCaptureDeviceType;
import io.mosip.biometrics.util.iris.IrisCaptureDeviceVendor;
import io.mosip.biometrics.util.iris.IrisQualityBlock;
import io.mosip.biometrics.util.iris.RepresentationData;
import io.mosip.biometrics.util.iris.RepresentationHeader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;

public class Representation
extends AbstractImageInfo {
    private RepresentationHeader representationHeader;
    private RepresentationData representationData;

    public Representation(Date captureDate, IrisQualityBlock[] qualityBlocks, ImageInformation imageInformation, int representationNo, byte[] image) {
        this.setRepresentationData(new RepresentationData(new ImageData(image)));
        this.setRepresentationHeader(new RepresentationHeader(this.getRepresentationData().getRecordLength(), captureDate, qualityBlocks, imageInformation, representationNo));
    }

    public Representation(Date captureDate, IrisCaptureDeviceTechnology sourceType, IrisCaptureDeviceVendor deviceVendor, IrisCaptureDeviceType deviceType, IrisQualityBlock[] qualityBlocks, ImageInformation imageInformation, int representationNo, byte[] image) {
        this.setRepresentationData(new RepresentationData(new ImageData(image)));
        this.setRepresentationHeader(new RepresentationHeader(this.getRepresentationData().getRecordLength(), captureDate, sourceType, deviceVendor, deviceType, qualityBlocks, imageInformation, representationNo));
    }

    public Representation(DataInputStream inputStream) throws IOException {
        this.readObject(inputStream);
    }

    @Override
    protected void readObject(DataInputStream inputStream) throws IOException {
        this.setRepresentationHeader(new RepresentationHeader(inputStream));
        this.setRepresentationData(new RepresentationData(inputStream));
    }

    @Override
    public int getRecordLength() {
        return this.getRepresentationHeader().getRecordLength() + this.getRepresentationData().getRecordLength();
    }

    @Override
    public void writeObject(DataOutputStream outputStream) throws IOException {
        this.getRepresentationHeader().writeObject(outputStream);
        this.getRepresentationData().writeObject(outputStream);
        outputStream.flush();
    }

    public RepresentationHeader getRepresentationHeader() {
        return this.representationHeader;
    }

    public void setRepresentationHeader(RepresentationHeader representationHeader) {
        this.representationHeader = representationHeader;
    }

    public RepresentationData getRepresentationData() {
        return this.representationData;
    }

    public void setRepresentationData(RepresentationData representationData) {
        this.representationData = representationData;
    }

    public String toString() {
        return "\nRepresentation [RepresentationRecordLength=" + this.getRecordLength() + ", representationHeader=" + this.representationHeader + ", representationData=" + this.representationData + "]\n";
    }
}

