/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.iris;

import io.mosip.biometrics.util.AbstractImageInfo;
import io.mosip.biometrics.util.iris.ImageData;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepresentationData
extends AbstractImageInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepresentationData.class);
    private ImageData imageData;

    public RepresentationData(ImageData imageData) {
        this.setImageData(imageData);
    }

    public RepresentationData(DataInputStream inputStream) throws IOException {
        this.readObject(inputStream);
    }

    @Override
    protected void readObject(DataInputStream inputStream) throws IOException {
        this.setImageData(new ImageData(inputStream));
    }

    @Override
    public int getRecordLength() {
        return this.getImageData().getRecordLength();
    }

    @Override
    public void writeObject(DataOutputStream outputStream) throws IOException {
        this.getImageData().writeObject(outputStream);
        outputStream.flush();
    }

    public ImageData getImageData() {
        return this.imageData;
    }

    public void setImageData(ImageData imageData) {
        this.imageData = imageData;
    }

    public String toString() {
        return "\nRepresentationData [RepresentationDataRecordLength=" + this.getRecordLength() + ", imageData=" + this.imageData + "]\n";
    }
}

