/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.biometrics.util.iris;

import io.mosip.biometrics.util.AbstractImageInfo;
import io.mosip.biometrics.util.iris.ImageInformation;
import io.mosip.biometrics.util.iris.IrisCaptureDeviceTechnology;
import io.mosip.biometrics.util.iris.IrisCaptureDeviceType;
import io.mosip.biometrics.util.iris.IrisCaptureDeviceVendor;
import io.mosip.biometrics.util.iris.IrisQualityBlock;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepresentationHeader
extends AbstractImageInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepresentationHeader.class);
    private int representationDataLength;
    private int representationLength;
    private Date captureDateTime;
    private int captureYear;
    private int captureMonth;
    private int captureDay;
    private int captureHour;
    private int captureMinute;
    private int captureSecond;
    private int captureMilliSecond;
    private IrisCaptureDeviceTechnology captureDeviceTechnologyIdentifier;
    private IrisCaptureDeviceVendor captureDeviceVendorIdentifier;
    private IrisCaptureDeviceType captureDeviceTypeIdentifier;
    private int noOfQualityBlocks;
    private IrisQualityBlock[] qualityBlocks;
    private ImageInformation imageInformation;
    private int representationNo;

    public RepresentationHeader(int representationDataLength, Date captureDate, IrisQualityBlock[] qualityBlocks, ImageInformation imageInformation, int representationNo) {
        this.setRepresentationDataLength(representationDataLength);
        this.setCaptureDateTime(captureDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(captureDate);
        this.setCaptureYear(calendar.get(1));
        this.setCaptureMonth(calendar.get(2));
        this.setCaptureDay(calendar.get(5));
        this.setCaptureHour(calendar.get(11));
        this.setCaptureMinute(calendar.get(12));
        this.setCaptureSecond(calendar.get(13));
        this.setCaptureMilliSecond(calendar.get(14));
        this.setCaptureDeviceTechnologyIdentifier(IrisCaptureDeviceTechnology.UNSPECIFIED);
        this.setCaptureDeviceVendorIdentifier(IrisCaptureDeviceVendor.UNSPECIFIED);
        this.setCaptureDeviceTypeIdentifier(IrisCaptureDeviceType.UNSPECIFIED);
        this.setNoOfQualityBlocks(qualityBlocks.length);
        this.setQualityBlocks(qualityBlocks);
        this.setImageInformation(imageInformation);
        this.setRepresentationNo(representationNo);
    }

    public RepresentationHeader(int representationDataLength, Date captureDate, IrisCaptureDeviceTechnology captureDeviceTechnologyIdentifier, IrisCaptureDeviceVendor captureDeviceVendorIdentifier, IrisCaptureDeviceType captureDeviceTypeIdentifier, IrisQualityBlock[] qualityBlocks, ImageInformation imageInformation, int representationNo) {
        this.setRepresentationDataLength(representationDataLength);
        this.setCaptureDateTime(captureDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(captureDate);
        this.setCaptureYear(calendar.get(1));
        this.setCaptureMonth(calendar.get(2));
        this.setCaptureDay(calendar.get(5));
        this.setCaptureHour(calendar.get(11));
        this.setCaptureMinute(calendar.get(12));
        this.setCaptureSecond(calendar.get(13));
        this.setCaptureMilliSecond(calendar.get(14));
        this.setCaptureDeviceTechnologyIdentifier(captureDeviceTechnologyIdentifier);
        this.setCaptureDeviceVendorIdentifier(captureDeviceVendorIdentifier);
        this.setCaptureDeviceTypeIdentifier(captureDeviceTypeIdentifier);
        this.setNoOfQualityBlocks(qualityBlocks.length);
        this.setQualityBlocks(qualityBlocks);
        this.setImageInformation(imageInformation);
        this.setRepresentationNo(representationNo);
    }

    public RepresentationHeader(DataInputStream inputStream) throws IOException {
        this.readObject(inputStream);
    }

    @Override
    protected void readObject(DataInputStream inputStream) throws IOException {
        this.setRepresentationDataLength((int)((long)inputStream.readInt() & 0xFFFFFFFFL));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        this.setCaptureYear(inputStream.readUnsignedShort());
        this.setCaptureMonth(inputStream.readUnsignedByte());
        this.setCaptureDay(inputStream.readUnsignedByte());
        this.setCaptureHour(inputStream.readUnsignedByte());
        this.setCaptureMinute(inputStream.readUnsignedByte());
        this.setCaptureSecond(inputStream.readUnsignedByte());
        this.setCaptureMilliSecond(inputStream.readUnsignedShort());
        calendar.set(1, this.getCaptureYear());
        calendar.set(2, this.getCaptureMonth() - 1);
        calendar.set(5, this.getCaptureDay());
        calendar.set(11, this.getCaptureHour());
        calendar.set(12, this.getCaptureMinute());
        calendar.set(13, this.getCaptureSecond());
        calendar.set(14, this.getCaptureMilliSecond());
        this.setCaptureDateTime(calendar.getTime());
        this.setCaptureDeviceTechnologyIdentifier(IrisCaptureDeviceTechnology.fromValue(inputStream.readUnsignedByte()));
        int captureDeviceVendorIdentifier = inputStream.readUnsignedShort();
        try {
            this.setCaptureDeviceVendorIdentifier(IrisCaptureDeviceVendor.fromValue(captureDeviceVendorIdentifier));
        }
        catch (Exception ex) {
            LOGGER.error("setCaptureDeviceVendorIdentifier :: Not Defined :: captureDeviceVendorIdentifier :: " + captureDeviceVendorIdentifier);
        }
        int captureDeviceTypeIdentifier = inputStream.readUnsignedShort();
        try {
            this.setCaptureDeviceTypeIdentifier(IrisCaptureDeviceType.fromValue(captureDeviceTypeIdentifier));
        }
        catch (Exception ex) {
            LOGGER.error("setCaptureDeviceTypeIdentifier :: Not Defined :: captureDeviceTypeIdentifier :: " + captureDeviceTypeIdentifier);
        }
        this.setNoOfQualityBlocks(inputStream.readUnsignedByte());
        IrisQualityBlock[] qualityBlock = new IrisQualityBlock[this.getNoOfQualityBlocks()];
        if (this.getNoOfQualityBlocks() > 0) {
            for (int index = 0; index < this.getNoOfQualityBlocks(); ++index) {
                qualityBlock[index] = new IrisQualityBlock(inputStream);
            }
        }
        this.setQualityBlocks(qualityBlock);
        this.setRepresentationNo(inputStream.readUnsignedShort());
        this.setImageInformation(new ImageInformation(inputStream));
    }

    @Override
    public int getRecordLength() {
        int qualityBlockRecordLength = 0;
        if (this.getQualityBlocks() != null && this.getQualityBlocks().length > 0) {
            for (int index = 0; index < this.getQualityBlocks().length; ++index) {
                qualityBlockRecordLength += this.getQualityBlocks()[index].getRecordLength();
            }
        }
        return 19 + qualityBlockRecordLength + 2 + 27;
    }

    @Override
    public void writeObject(DataOutputStream outputStream) throws IOException {
        outputStream.writeInt(this.getRecordLength() + this.getRepresentationDataLength());
        outputStream.writeShort(this.getCaptureYear());
        outputStream.writeByte(this.getCaptureMonth() + 1);
        outputStream.writeByte(this.getCaptureDay());
        outputStream.writeByte(this.getCaptureHour());
        outputStream.writeByte(this.getCaptureMinute());
        outputStream.writeByte(this.getCaptureSecond());
        outputStream.writeShort(this.getCaptureMilliSecond());
        outputStream.writeByte(this.getCaptureDeviceTechnologyIdentifier().value());
        outputStream.writeShort(this.getCaptureDeviceVendorIdentifier().value());
        outputStream.writeShort(this.getCaptureDeviceTypeIdentifier().value());
        outputStream.writeByte(this.getNoOfQualityBlocks());
        if (this.getQualityBlocks() != null) {
            for (int index = 0; index < this.getQualityBlocks().length; ++index) {
                this.getQualityBlocks()[index].writeObject(outputStream);
            }
        }
        outputStream.writeShort(this.getRepresentationNo());
        this.getImageInformation().writeObject(outputStream);
        outputStream.flush();
    }

    public int getRepresentationDataLength() {
        return this.representationDataLength;
    }

    public void setRepresentationDataLength(int representationDataLength) {
        this.representationDataLength = representationDataLength;
    }

    public int getRepresentationLength() {
        return this.representationLength;
    }

    public void setRepresentationLength(int representationLength) {
        this.representationLength = representationLength;
    }

    public Date getCaptureDateTime() {
        return this.captureDateTime;
    }

    public void setCaptureDateTime(Date captureDateTime) {
        this.captureDateTime = captureDateTime;
    }

    public int getCaptureYear() {
        return this.captureYear;
    }

    public void setCaptureYear(int captureYear) {
        this.captureYear = captureYear;
    }

    public int getCaptureMonth() {
        return this.captureMonth;
    }

    public void setCaptureMonth(int captureMonth) {
        this.captureMonth = captureMonth;
    }

    public int getCaptureDay() {
        return this.captureDay;
    }

    public void setCaptureDay(int captureDay) {
        this.captureDay = captureDay;
    }

    public int getCaptureHour() {
        return this.captureHour;
    }

    public void setCaptureHour(int captureHour) {
        this.captureHour = captureHour;
    }

    public int getCaptureMinute() {
        return this.captureMinute;
    }

    public void setCaptureMinute(int captureMinute) {
        this.captureMinute = captureMinute;
    }

    public int getCaptureSecond() {
        return this.captureSecond;
    }

    public void setCaptureSecond(int captureSecond) {
        this.captureSecond = captureSecond;
    }

    public int getCaptureMilliSecond() {
        return this.captureMilliSecond;
    }

    public void setCaptureMilliSecond(int captureMilliSecond) {
        this.captureMilliSecond = captureMilliSecond;
    }

    public IrisCaptureDeviceTechnology getCaptureDeviceTechnologyIdentifier() {
        return this.captureDeviceTechnologyIdentifier;
    }

    public void setCaptureDeviceTechnologyIdentifier(IrisCaptureDeviceTechnology captureDeviceTechnologyIdentifier) {
        this.captureDeviceTechnologyIdentifier = captureDeviceTechnologyIdentifier;
    }

    public IrisCaptureDeviceVendor getCaptureDeviceVendorIdentifier() {
        return this.captureDeviceVendorIdentifier;
    }

    public void setCaptureDeviceVendorIdentifier(IrisCaptureDeviceVendor captureDeviceVendorIdentifier) {
        this.captureDeviceVendorIdentifier = captureDeviceVendorIdentifier;
    }

    public IrisCaptureDeviceType getCaptureDeviceTypeIdentifier() {
        return this.captureDeviceTypeIdentifier;
    }

    public void setCaptureDeviceTypeIdentifier(IrisCaptureDeviceType captureDeviceTypeIdentifier) {
        this.captureDeviceTypeIdentifier = captureDeviceTypeIdentifier;
    }

    public int getNoOfQualityBlocks() {
        return this.noOfQualityBlocks;
    }

    public void setNoOfQualityBlocks(int noOfQualityBlocks) {
        this.noOfQualityBlocks = noOfQualityBlocks;
    }

    public IrisQualityBlock[] getQualityBlocks() {
        return this.qualityBlocks;
    }

    public void setQualityBlocks(IrisQualityBlock[] qualityBlocks) {
        this.qualityBlocks = qualityBlocks;
    }

    public ImageInformation getImageInformation() {
        return this.imageInformation;
    }

    public void setImageInformation(ImageInformation imageInformation) {
        this.imageInformation = imageInformation;
    }

    public int getRepresentationNo() {
        return this.representationNo;
    }

    public void setRepresentationNo(int representationNo) {
        this.representationNo = representationNo;
    }

    public String toString() {
        return "RepresentationHeader [RecordLength=" + this.getRecordLength() + ", representationDataLength=" + this.representationDataLength + ", representationLength=" + this.representationLength + ", captureDateTime=" + this.captureDateTime + ", captureYear=" + this.captureYear + ", captureMonth=" + this.captureMonth + ", captureDay=" + this.captureDay + ", captureHour=" + this.captureHour + ", captureMinute=" + this.captureMinute + ", captureSecond=" + this.captureSecond + ", captureMilliSecond=" + this.captureMilliSecond + ", captureDeviceTechnologyIdentifier=" + this.captureDeviceTechnologyIdentifier + ", captureDeviceVendorIdentifier=" + this.captureDeviceVendorIdentifier + ", captureDeviceTypeIdentifier=" + this.captureDeviceTypeIdentifier + ", noOfQualityBlocks=" + this.noOfQualityBlocks + ", qualityBlocks=" + Arrays.toString(this.qualityBlocks) + ", imageInformation=" + this.imageInformation + ", representationNo=" + this.representationNo + "]";
    }
}

