/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP.authenticationResponse;

import io.mosip.openID4VP.authenticationResponse.AuthenticationResponseKt;
import io.mosip.openID4VP.authorizationRequest.AuthorizationRequest;
import io.mosip.openID4VP.authorizationRequest.ClientMetadata;
import io.mosip.openID4VP.authorizationRequest.ClientMetadataSerializer;
import io.mosip.openID4VP.authorizationRequest.UtilsKt;
import io.mosip.openID4VP.authorizationRequest.presentationDefinition.PresentationDefinition;
import io.mosip.openID4VP.authorizationRequest.presentationDefinition.PresentationDefinitionSerializer;
import io.mosip.openID4VP.common.Logger;
import io.mosip.openID4VP.dto.Verifier;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lio/mosip/openID4VP/authenticationResponse/AuthenticationResponse;", "", "<init>", "()V", "Companion", "inji-openid4vp-0.1.0_release"})
public final class AuthenticationResponse {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u001a\u0010\u000b\u001a\u0016\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\u000f\u001a\u00020\u0010J(\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a8\u0006\u0015"}, d2={"Lio/mosip/openID4VP/authenticationResponse/AuthenticationResponse$Companion;", "", "<init>", "()V", "validateAuthorizationRequestPartially", "", "authorizationRequest", "Lio/mosip/openID4VP/authorizationRequest/AuthorizationRequest;", "trustedVerifiers", "", "Lio/mosip/openID4VP/dto/Verifier;", "updateAuthorizationRequest", "Lkotlin/Function2;", "Lio/mosip/openID4VP/authorizationRequest/presentationDefinition/PresentationDefinition;", "Lio/mosip/openID4VP/authorizationRequest/ClientMetadata;", "shouldValidateClient", "", "validateVerifier", "receivedClientId", "", "receivedResponseUri", "inji-openid4vp-0.1.0_release"})
    @SourceDebugExtension(value={"SMAP\nAuthenticationResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthenticationResponse.kt\nio/mosip/openID4VP/authenticationResponse/AuthenticationResponse$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void validateAuthorizationRequestPartially(@NotNull AuthorizationRequest authorizationRequest, @NotNull List<Verifier> trustedVerifiers, @NotNull Function2<? super PresentationDefinition, ? super ClientMetadata, Unit> updateAuthorizationRequest, boolean shouldValidateClient) {
            Intrinsics.checkNotNullParameter((Object)authorizationRequest, (String)"authorizationRequest");
            Intrinsics.checkNotNullParameter(trustedVerifiers, (String)"trustedVerifiers");
            Intrinsics.checkNotNullParameter(updateAuthorizationRequest, (String)"updateAuthorizationRequest");
            if (shouldValidateClient && this.validateVerifier(authorizationRequest.getClientId(), authorizationRequest.getResponseUri(), trustedVerifiers) == null) {
                throw Logger.handleException$default(Logger.INSTANCE, "InvalidVerifierClientID", null, null, AuthenticationResponseKt.access$getClassName$p(), null, 22, null);
            }
            Object clientMetadata = null;
            Object object = authorizationRequest.getClientMetadata();
            if (object != null) {
                Object it = object;
                boolean bl = false;
                clientMetadata = UtilsKt.deserializeAndValidate(String.valueOf(authorizationRequest.getClientMetadata()), ClientMetadataSerializer.INSTANCE);
            }
            PresentationDefinition presentationDefinition = (PresentationDefinition)UtilsKt.deserializeAndValidate(authorizationRequest.getPresentationDefinition().toString(), PresentationDefinitionSerializer.INSTANCE);
            updateAuthorizationRequest.invoke((Object)presentationDefinition, clientMetadata);
        }

        private final Verifier validateVerifier(String receivedClientId, String receivedResponseUri, List<Verifier> trustedVerifiers) {
            Object v0;
            block1: {
                Iterable iterable = trustedVerifiers;
                for (Object t : iterable) {
                    Verifier it = (Verifier)t;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getClientId(), (Object)receivedClientId) && it.getResponseUris().contains(receivedResponseUri))) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

