/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP.authorizationRequest;

import io.mosip.openID4VP.authorizationRequest.AuthorizationRequestKt;
import io.mosip.openID4VP.authorizationRequest.ClientMetadata;
import io.mosip.openID4VP.authorizationRequest.presentationDefinition.PresentationDefinition;
import io.mosip.openID4VP.common.Decoder;
import io.mosip.openID4VP.common.FieldValidatorKt;
import io.mosip.openID4VP.common.Logger;
import io.mosip.openID4VP.networkManager.HTTP_METHOD;
import io.mosip.openID4VP.networkManager.NetworkManagerClient;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b \n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 )2\u00020\u0001:\u0001)BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0001H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00c6\u0003J[\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00012\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u001a\u0010\u0006\u001a\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000eR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0012\"\u0004\b\u0019\u0010\u0014\u00a8\u0006*"}, d2={"Lio/mosip/openID4VP/authorizationRequest/AuthorizationRequest;", "", "clientId", "", "responseType", "responseMode", "presentationDefinition", "responseUri", "nonce", "state", "clientMetadata", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V", "getClientId", "()Ljava/lang/String;", "getResponseType", "getResponseMode", "getPresentationDefinition", "()Ljava/lang/Object;", "setPresentationDefinition", "(Ljava/lang/Object;)V", "getResponseUri", "getNonce", "getState", "getClientMetadata", "setClientMetadata", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "inji-openid4vp-0.1.0_release"})
public final class AuthorizationRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String clientId;
    @NotNull
    private final String responseType;
    @NotNull
    private final String responseMode;
    @NotNull
    private Object presentationDefinition;
    @NotNull
    private final String responseUri;
    @NotNull
    private final String nonce;
    @NotNull
    private final String state;
    @Nullable
    private Object clientMetadata;

    public AuthorizationRequest(@NotNull String clientId, @NotNull String responseType, @NotNull String responseMode, @NotNull Object presentationDefinition, @NotNull String responseUri, @NotNull String nonce, @NotNull String state, @Nullable Object clientMetadata) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)responseType, (String)"responseType");
        Intrinsics.checkNotNullParameter((Object)responseMode, (String)"responseMode");
        Intrinsics.checkNotNullParameter((Object)presentationDefinition, (String)"presentationDefinition");
        Intrinsics.checkNotNullParameter((Object)responseUri, (String)"responseUri");
        Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.clientId = clientId;
        this.responseType = responseType;
        this.responseMode = responseMode;
        this.presentationDefinition = presentationDefinition;
        this.responseUri = responseUri;
        this.nonce = nonce;
        this.state = state;
        this.clientMetadata = clientMetadata;
        if (!(this.presentationDefinition instanceof PresentationDefinition || this.presentationDefinition instanceof String)) {
            boolean bl = false;
            String string = "presentationDefinition must be of type String or PresentationDefinition";
            throw new IllegalArgumentException(string.toString());
        }
        Object object = this.clientMetadata;
        if (object != null) {
            Object it = object;
            boolean bl = false;
            if (!(this.clientMetadata instanceof ClientMetadata || this.clientMetadata instanceof String)) {
                boolean bl2 = false;
                String string = "clientMetadata must be of type String or ClientMetadata";
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    public /* synthetic */ AuthorizationRequest(String string, String string2, String string3, Object object, String string4, String string5, String string6, Object object2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            object2 = null;
        }
        this(string, string2, string3, object, string4, string5, string6, object2);
    }

    @NotNull
    public final String getClientId() {
        return this.clientId;
    }

    @NotNull
    public final String getResponseType() {
        return this.responseType;
    }

    @NotNull
    public final String getResponseMode() {
        return this.responseMode;
    }

    @NotNull
    public final Object getPresentationDefinition() {
        return this.presentationDefinition;
    }

    public final void setPresentationDefinition(@NotNull Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<set-?>");
        this.presentationDefinition = object;
    }

    @NotNull
    public final String getResponseUri() {
        return this.responseUri;
    }

    @NotNull
    public final String getNonce() {
        return this.nonce;
    }

    @NotNull
    public final String getState() {
        return this.state;
    }

    @Nullable
    public final Object getClientMetadata() {
        return this.clientMetadata;
    }

    public final void setClientMetadata(@Nullable Object object) {
        this.clientMetadata = object;
    }

    @NotNull
    public final String component1() {
        return this.clientId;
    }

    @NotNull
    public final String component2() {
        return this.responseType;
    }

    @NotNull
    public final String component3() {
        return this.responseMode;
    }

    @NotNull
    public final Object component4() {
        return this.presentationDefinition;
    }

    @NotNull
    public final String component5() {
        return this.responseUri;
    }

    @NotNull
    public final String component6() {
        return this.nonce;
    }

    @NotNull
    public final String component7() {
        return this.state;
    }

    @Nullable
    public final Object component8() {
        return this.clientMetadata;
    }

    @NotNull
    public final AuthorizationRequest copy(@NotNull String clientId, @NotNull String responseType, @NotNull String responseMode, @NotNull Object presentationDefinition, @NotNull String responseUri, @NotNull String nonce, @NotNull String state, @Nullable Object clientMetadata) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)responseType, (String)"responseType");
        Intrinsics.checkNotNullParameter((Object)responseMode, (String)"responseMode");
        Intrinsics.checkNotNullParameter((Object)presentationDefinition, (String)"presentationDefinition");
        Intrinsics.checkNotNullParameter((Object)responseUri, (String)"responseUri");
        Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new AuthorizationRequest(clientId, responseType, responseMode, presentationDefinition, responseUri, nonce, state, clientMetadata);
    }

    public static /* synthetic */ AuthorizationRequest copy$default(AuthorizationRequest authorizationRequest, String string, String string2, String string3, Object object, String string4, String string5, String string6, Object object2, int n, Object object3) {
        if ((n & 1) != 0) {
            string = authorizationRequest.clientId;
        }
        if ((n & 2) != 0) {
            string2 = authorizationRequest.responseType;
        }
        if ((n & 4) != 0) {
            string3 = authorizationRequest.responseMode;
        }
        if ((n & 8) != 0) {
            object = authorizationRequest.presentationDefinition;
        }
        if ((n & 0x10) != 0) {
            string4 = authorizationRequest.responseUri;
        }
        if ((n & 0x20) != 0) {
            string5 = authorizationRequest.nonce;
        }
        if ((n & 0x40) != 0) {
            string6 = authorizationRequest.state;
        }
        if ((n & 0x80) != 0) {
            object2 = authorizationRequest.clientMetadata;
        }
        return authorizationRequest.copy(string, string2, string3, object, string4, string5, string6, object2);
    }

    @NotNull
    public String toString() {
        return "AuthorizationRequest(clientId=" + this.clientId + ", responseType=" + this.responseType + ", responseMode=" + this.responseMode + ", presentationDefinition=" + this.presentationDefinition + ", responseUri=" + this.responseUri + ", nonce=" + this.nonce + ", state=" + this.state + ", clientMetadata=" + this.clientMetadata + ")";
    }

    public int hashCode() {
        int result = this.clientId.hashCode();
        result = result * 31 + this.responseType.hashCode();
        result = result * 31 + this.responseMode.hashCode();
        result = result * 31 + this.presentationDefinition.hashCode();
        result = result * 31 + this.responseUri.hashCode();
        result = result * 31 + this.nonce.hashCode();
        result = result * 31 + this.state.hashCode();
        result = result * 31 + (this.clientMetadata == null ? 0 : this.clientMetadata.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AuthorizationRequest)) {
            return false;
        }
        AuthorizationRequest authorizationRequest = (AuthorizationRequest)other;
        if (!Intrinsics.areEqual((Object)this.clientId, (Object)authorizationRequest.clientId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.responseType, (Object)authorizationRequest.responseType)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.responseMode, (Object)authorizationRequest.responseMode)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.presentationDefinition, (Object)authorizationRequest.presentationDefinition)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.responseUri, (Object)authorizationRequest.responseUri)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.nonce, (Object)authorizationRequest.nonce)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.state, (Object)authorizationRequest.state)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.clientMetadata, (Object)authorizationRequest.clientMetadata);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tJ$\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tH\u0002J\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u001c\u0010\u0010\u001a\u00020\u00072\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0012H\u0002J0\u0010\u0013\u001a\u00020\n2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000e2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tH\u0002J\u001c\u0010\u0014\u001a\u00020\u00052\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0012H\u0002J$\u0010\u0015\u001a\u00020\n2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u001a\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\u0019"}, d2={"Lio/mosip/openID4VP/authorizationRequest/AuthorizationRequest$Companion;", "", "<init>", "()V", "validateAndGetAuthorizationRequest", "Lio/mosip/openID4VP/authorizationRequest/AuthorizationRequest;", "encodedAuthorizationRequest", "", "setResponseUri", "Lkotlin/Function1;", "", "parseAuthorizationRequest", "decodedAuthorizationRequest", "extractQueryParams", "", "query", "fetchPresentationDefinition", "params", "", "validateQueryParams", "createAuthorizationRequest", "validateRootFieldMissingScenario", "param", "validateRootFieldInvalidScenario", "value", "inji-openid4vp-0.1.0_release"})
    @SourceDebugExtension(value={"SMAP\nAuthorizationRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthorizationRequest.kt\nio/mosip/openID4VP/authorizationRequest/AuthorizationRequest$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,234:1\n1557#2:235\n1628#2,3:236\n1246#2,4:239\n1863#2,2:243\n1863#2,2:245\n*S KotlinDebug\n*F\n+ 1 AuthorizationRequest.kt\nio/mosip/openID4VP/authorizationRequest/AuthorizationRequest$Companion\n*L\n83#1:235\n83#1:236,3\n84#1:239,4\n169#1:243,2\n182#1:245,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AuthorizationRequest validateAndGetAuthorizationRequest(@NotNull String encodedAuthorizationRequest, @NotNull Function1<? super String, Unit> setResponseUri) {
            Intrinsics.checkNotNullParameter((Object)encodedAuthorizationRequest, (String)"encodedAuthorizationRequest");
            Intrinsics.checkNotNullParameter(setResponseUri, (String)"setResponseUri");
            int queryStart = StringsKt.indexOf$default((CharSequence)encodedAuthorizationRequest, (char)'?', (int)0, (boolean)false, (int)6, null) + 1;
            String string = encodedAuthorizationRequest.substring(queryStart);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String encodedString = string;
            String decodedString = Decoder.INSTANCE.decodeBase64ToString(encodedString);
            String string2 = encodedAuthorizationRequest.substring(0, queryStart);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String decodedAuthorizationRequest = string2 + decodedString;
            return this.parseAuthorizationRequest(decodedAuthorizationRequest, setResponseUri);
        }

        private final AuthorizationRequest parseAuthorizationRequest(String decodedAuthorizationRequest, Function1<? super String, Unit> setResponseUri) {
            try {
                int queryStart = StringsKt.indexOf$default((CharSequence)decodedAuthorizationRequest, (char)'?', (int)0, (boolean)false, (int)6, null) + 1;
                String string = decodedAuthorizationRequest.substring(queryStart);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String queryString = string;
                String encodedQuery = URLEncoder.encode(queryString, StandardCharsets.UTF_8.toString());
                String uriString = "?" + encodedQuery;
                URI uri = new URI(uriString);
                String string2 = uri.getQuery();
                if (string2 == null) {
                    throw Logger.handleException$default(Logger.INSTANCE, "InvalidQueryParams", "Query parameters are missing in the Authorization request", null, AuthorizationRequestKt.access$getClassName$p(), null, 20, null);
                }
                String query = string2;
                Map<String, String> params = this.extractQueryParams(query);
                this.validateQueryParams(params, setResponseUri);
                return this.createAuthorizationRequest(params);
            }
            catch (Exception exception) {
                Logger.INSTANCE.error(AuthorizationRequestKt.access$getLogTag$p(), exception);
                throw exception;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final Map<String, String> extractQueryParams(String query) {
            try {
                void $this$associateByTo$iv;
                Object object;
                void $this$mapTo$iv$iv;
                String[] stringArray = new String[]{"&"};
                Iterable $this$map$iv = StringsKt.split$default((CharSequence)query, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    String[] stringArray2 = new String[]{"="};
                    object.add(StringsKt.split$default((CharSequence)((CharSequence)it), (String[])stringArray2, (boolean)false, (int)0, (int)6, null));
                }
                $this$map$iv = (List)destination$iv$iv;
                Map destination$iv = new LinkedHashMap();
                boolean $i$f$associateByTo = false;
                for (Object element$iv : $this$associateByTo$iv) {
                    List list = (List)element$iv;
                    object = destination$iv;
                    boolean bl = false;
                    List it = (List)element$iv;
                    String string = (String)it.get(0);
                    boolean bl2 = false;
                    String string2 = it.size() > 1 ? URLDecoder.decode((String)it.get(1), StandardCharsets.UTF_8.toString()) : "";
                    object.put(string, string2);
                }
                return destination$iv;
            }
            catch (Exception exception) {
                throw Logger.handleException$default(Logger.INSTANCE, "InvalidQueryParams", "Exception occurred when extracting the query params from Authorization Request : " + exception.getMessage(), null, AuthorizationRequestKt.access$getClassName$p(), null, 20, null);
            }
        }

        private final String fetchPresentationDefinition(Map<String, String> params) {
            boolean hasPresentationDefinition = params.containsKey("presentation_definition");
            boolean hasPresentationDefinitionUri = params.containsKey("presentation_definition_uri");
            String presentationDefinition = "";
            if (hasPresentationDefinition && hasPresentationDefinitionUri) {
                throw Logger.handleException$default(Logger.INSTANCE, "InvalidQueryParams", "Either presentation_definition or presentation_definition_uri request param can be provided but not both", null, AuthorizationRequestKt.access$getClassName$p(), null, 20, null);
            }
            if (hasPresentationDefinition) {
                String value = params.get("presentation_definition");
                if (!(!Intrinsics.areEqual((Object)value, (Object)"null") && FieldValidatorKt.validateField(value, "String"))) {
                    boolean bl = false;
                    throw Logger.handleException$default(Logger.INSTANCE, "InvalidInput", null, CollectionsKt.listOf((Object)"presentation_definition"), AuthorizationRequestKt.access$getClassName$p(), "String", 2, null);
                }
                String string = params.get("presentation_definition");
                Intrinsics.checkNotNull((Object)string);
                presentationDefinition = string;
            } else if (hasPresentationDefinitionUri) {
                this.validateRootFieldInvalidScenario("presentation_definition_uri", params.get("presentation_definition_uri"));
                String string = params.get("presentation_definition_uri");
                Intrinsics.checkNotNull((Object)string);
                presentationDefinition = NetworkManagerClient.Companion.sendHTTPRequest$default(NetworkManagerClient.Companion, string, HTTP_METHOD.GET, null, null, 12, null);
            } else {
                throw Logger.handleException$default(Logger.INSTANCE, "InvalidQueryParams", "Either presentation_definition or presentation_definition_uri request param must be present", null, AuthorizationRequestKt.access$getClassName$p(), null, 20, null);
            }
            return presentationDefinition;
        }

        private final void validateQueryParams(Map<String, String> params, Function1<? super String, Unit> setResponseUri) {
            this.validateRootFieldMissingScenario(params, "response_uri");
            this.validateRootFieldInvalidScenario("response_uri", params.get("response_uri"));
            String string = params.get("response_uri");
            Intrinsics.checkNotNull((Object)string);
            setResponseUri.invoke((Object)string);
            Object[] objectArray = new String[]{"presentation_definition", "client_id", "response_type", "response_mode", "nonce", "state"};
            List requiredRequestParams = CollectionsKt.mutableListOf((Object[])objectArray);
            Iterable $this$forEach$iv = requiredRequestParams;
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv) {
                String param = (String)element$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)param, (Object)"presentation_definition")) {
                    params.put("presentation_definition", Companion.fetchPresentationDefinition(params));
                }
                Companion.validateRootFieldMissingScenario(params, param);
                Companion.validateRootFieldInvalidScenario(param, params.get(param));
            }
            Object[] $i$f$forEach22 = new String[]{"client_metadata"};
            List optionalRequestParams = CollectionsKt.mutableListOf((Object[])$i$f$forEach22);
            Iterable $this$forEach$iv2 = optionalRequestParams;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv2) {
                String value;
                String param = (String)element$iv;
                boolean bl = false;
                if (params.get(param) == null) continue;
                boolean bl2 = false;
                if (((CharSequence)value).length() > 0) continue;
                boolean bl3 = false;
                throw Logger.handleException$default(Logger.INSTANCE, "InvalidInput", null, CollectionsKt.listOf((Object)"client_metadata"), AuthorizationRequestKt.access$getClassName$p(), Reflection.getOrCreateKotlinClass(value.getClass()).getSimpleName(), 2, null);
            }
        }

        private final AuthorizationRequest createAuthorizationRequest(Map<String, String> params) {
            String string = params.get("client_id");
            Intrinsics.checkNotNull((Object)string);
            String string2 = params.get("response_type");
            Intrinsics.checkNotNull((Object)string2);
            String string3 = params.get("response_mode");
            Intrinsics.checkNotNull((Object)string3);
            String string4 = params.get("presentation_definition");
            Intrinsics.checkNotNull((Object)string4);
            String string5 = params.get("response_uri");
            Intrinsics.checkNotNull((Object)string5);
            String string6 = params.get("nonce");
            Intrinsics.checkNotNull((Object)string6);
            String string7 = params.get("state");
            Intrinsics.checkNotNull((Object)string7);
            return new AuthorizationRequest(string, string2, string3, string4, string5, string6, string7, params.get("client_metadata"));
        }

        private final void validateRootFieldMissingScenario(Map<String, String> params, String param) {
            boolean hasParam = params.containsKey(param);
            if (!hasParam) {
                throw Logger.handleException$default(Logger.INSTANCE, "MissingInput", null, CollectionsKt.listOf((Object)param), AuthorizationRequestKt.access$getClassName$p(), null, 18, null);
            }
        }

        private final void validateRootFieldInvalidScenario(String param, String value) {
            if (!(!Intrinsics.areEqual((Object)value, (Object)"null") && FieldValidatorKt.validateField(value, "String"))) {
                boolean bl = false;
                throw Logger.handleException$default(Logger.INSTANCE, "InvalidInput", null, CollectionsKt.listOf((Object)param), AuthorizationRequestKt.access$getClassName$p(), "String", 2, null);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

