/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP.common;

import io.mosip.openID4VP.authorizationRequest.exception.AuthorizationRequestExceptions;
import io.mosip.openID4VP.common.DecoderKt;
import io.mosip.openID4VP.common.Logger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/mosip/openID4VP/common/Decoder;", "", "<init>", "()V", "logTag", "", "decodeBase64ToString", "encodedData", "inji-openid4vp-0.1.0_release"})
public final class Decoder {
    @NotNull
    public static final Decoder INSTANCE = new Decoder();
    @NotNull
    private static final String logTag;

    private Decoder() {
    }

    @NotNull
    public final String decodeBase64ToString(@NotNull String encodedData) {
        Intrinsics.checkNotNullParameter((Object)encodedData, (String)"encodedData");
        if (((CharSequence)encodedData).length() == 0) {
            throw Logger.handleException$default(Logger.INSTANCE, "InvalidInput", null, CollectionsKt.listOf((Object)"encoded data"), DecoderKt.access$getClassName$p(), Reflection.getOrCreateKotlinClass(encodedData.getClass()).getSimpleName(), 2, null);
        }
        try {
            byte[] byArray = Base64.decodeBase64((String)encodedData);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decodeBase64(...)");
            byte[] decodedBytes = byArray;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            return new String(decodedBytes, charset2);
        }
        catch (Exception e) {
            AuthorizationRequestExceptions.DecodingException exception = new AuthorizationRequestExceptions.DecodingException("Error occurred while decoding data: " + e.getMessage());
            Logger.INSTANCE.error(logTag, exception);
            throw exception;
        }
    }

    static {
        String string = Reflection.getOrCreateKotlinClass(INSTANCE.getClass()).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        logTag = Logger.INSTANCE.getLogTag(string);
    }
}

