/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP.common;

import android.util.Log;
import io.mosip.openID4VP.authorizationRequest.exception.AuthorizationRequestExceptions;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u001f\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00052\n\u0010\f\u001a\u00060\u000ej\u0002`\r\u00a2\u0006\u0002\u0010\u000fJI\u0010\u0010\u001a\u00060\u000ej\u0002`\r2\u0006\u0010\u0011\u001a\u00020\u00052\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0010\b\u0002\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00142\u0006\u0010\t\u001a\u00020\u00052\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/mosip/openID4VP/common/Logger;", "", "<init>", "()V", "traceabilityId", "", "setTraceabilityId", "", "getLogTag", "className", "error", "logTag", "exception", "Lkotlin/Exception;", "Ljava/lang/Exception;", "(Ljava/lang/String;Ljava/lang/Exception;)V", "handleException", "exceptionType", "message", "fieldPath", "", "fieldType", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Exception;", "inji-openid4vp-0.1.0_release"})
public final class Logger {
    @NotNull
    public static final Logger INSTANCE = new Logger();
    @Nullable
    private static String traceabilityId;

    private Logger() {
    }

    public final void setTraceabilityId(@NotNull String traceabilityId) {
        Intrinsics.checkNotNullParameter((Object)traceabilityId, (String)"traceabilityId");
        Logger.traceabilityId = traceabilityId;
    }

    @NotNull
    public final String getLogTag(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        String string = traceabilityId;
        if (string == null) {
            string = "";
        }
        return "INJI-OpenID4VP : class name - " + className + " | traceID - " + string;
    }

    public final void error(@NotNull String logTag, @NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)logTag, (String)"logTag");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        String string = exception.getMessage();
        Intrinsics.checkNotNull((Object)string);
        Log.e((String)logTag, (String)string);
    }

    @NotNull
    public final Exception handleException(@NotNull String exceptionType, @Nullable String message, @Nullable List<String> fieldPath, @NotNull String className, @Nullable Object fieldType) {
        Intrinsics.checkNotNullParameter((Object)exceptionType, (String)"exceptionType");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        String fieldPathAsString = null;
        fieldPathAsString = "";
        List<String> list = fieldPath;
        if (list != null) {
            List<String> it = list;
            boolean bl = false;
            fieldPathAsString = CollectionsKt.joinToString$default((Iterable)fieldPath, (CharSequence)"->", null, null, (int)0, null, null, (int)62, null);
        }
        Exception exception = new Exception();
        switch (exceptionType) {
            case "MissingInput": {
                exception = new AuthorizationRequestExceptions.MissingInput(fieldPathAsString);
                break;
            }
            case "InvalidInput": {
                exception = new AuthorizationRequestExceptions.InvalidInput(fieldPathAsString, fieldType);
                break;
            }
            case "InvalidInputPattern": {
                exception = new AuthorizationRequestExceptions.InvalidInputPattern(fieldPathAsString);
                break;
            }
            case "InvalidQueryParams": {
                String string = message;
                if (string == null) {
                    string = "";
                }
                exception = new AuthorizationRequestExceptions.InvalidQueryParams(string);
                break;
            }
            case "JsonEncodingFailed": {
                String string = message;
                if (string == null) {
                    string = "";
                }
                exception = new AuthorizationRequestExceptions.JsonEncodingFailed(fieldPathAsString, string);
                break;
            }
            case "InvalidVerifierClientID": {
                exception = new AuthorizationRequestExceptions.InvalidVerifierClientID();
                break;
            }
            case "InvalidLimitDisclosure": {
                exception = new AuthorizationRequestExceptions.InvalidLimitDisclosure();
                break;
            }
            case "DeserializationFailure": {
                String string = message;
                if (string == null) {
                    string = "";
                }
                exception = new AuthorizationRequestExceptions.DeserializationFailure(fieldPathAsString, string);
                break;
            }
            case "": {
                exception = new Exception("An unexpected exception occurred: exception type: " + exceptionType);
            }
        }
        this.error(this.getLogTag(className), exception);
        return exception;
    }

    public static /* synthetic */ Exception handleException$default(Logger logger, String string, String string2, List list, String string3, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            list = null;
        }
        if ((n & 0x10) != 0) {
            object = null;
        }
        return logger.handleException(string, string2, list, string3, object);
    }
}

