/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP.networkManager;

import io.mosip.openID4VP.common.Logger;
import io.mosip.openID4VP.networkManager.HTTP_METHOD;
import io.mosip.openID4VP.networkManager.NetworkManagerClientKt;
import io.mosip.openID4VP.networkManager.exception.NetworkManagerClientExceptions;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lio/mosip/openID4VP/networkManager/NetworkManagerClient;", "", "<init>", "()V", "Companion", "inji-openid4vp-0.1.0_release"})
public final class NetworkManagerClient {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\n2\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\n\u00a8\u0006\f"}, d2={"Lio/mosip/openID4VP/networkManager/NetworkManagerClient$Companion;", "", "<init>", "()V", "sendHTTPRequest", "", "url", "method", "Lio/mosip/openID4VP/networkManager/HTTP_METHOD;", "bodyParams", "", "headers", "inji-openid4vp-0.1.0_release"})
    @SourceDebugExtension(value={"SMAP\nNetworkManagerClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkManagerClient.kt\nio/mosip/openID4VP/networkManager/NetworkManagerClient$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n216#2,2:66\n216#2,2:68\n1#3:70\n*S KotlinDebug\n*F\n+ 1 NetworkManagerClient.kt\nio/mosip/openID4VP/networkManager/NetworkManagerClient$Companion\n*L\n27#1:66,2\n32#1:68,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final String sendHTTPRequest(@NotNull String url, @NotNull HTTP_METHOD method, @Nullable Map<String, String> bodyParams, @Nullable Map<String, String> headers) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
            try {
                Object $this$forEach$iv;
                Request.Builder requestBuilder;
                OkHttpClient client = new OkHttpClient.Builder().build();
                Request request = null;
                switch (WhenMappings.$EnumSwitchMapping$0[method.ordinal()]) {
                    case 1: {
                        Object object;
                        FormBody.Builder requestBodyBuilder = new FormBody.Builder(null, 1, null);
                        Map<String, String> map = bodyParams;
                        if (map != null) {
                            Map<String, String> $this$forEach$iv2 = map;
                            boolean $i$f$forEach = false;
                            for (Map.Entry<String, String> element$iv : $this$forEach$iv2.entrySet()) {
                                object = element$iv;
                                boolean bl = false;
                                String key = object.getKey();
                                String value = object.getValue();
                                requestBodyBuilder.add(key, value);
                            }
                        }
                        FormBody requestBody = requestBodyBuilder.build();
                        requestBuilder = new Request.Builder().url(url).post((RequestBody)requestBody);
                        Map<String, String> map2 = headers;
                        if (map2 != null) {
                            $this$forEach$iv = map2;
                            boolean $i$f$forEach = false;
                            object = $this$forEach$iv.entrySet().iterator();
                            while (object.hasNext()) {
                                Map.Entry element$iv;
                                Map.Entry entry = element$iv = (Map.Entry)object.next();
                                boolean bl = false;
                                String key = (String)entry.getKey();
                                String value = (String)entry.getValue();
                                requestBuilder.addHeader(key, value);
                            }
                        }
                        request = requestBuilder.build();
                        break;
                    }
                    case 2: {
                        request = new Request.Builder().url(url).get().build();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Response response = client.newCall(request).execute();
                if (response.isSuccessful()) {
                    String string;
                    BufferedReader bufferedReader;
                    Object object = response.body();
                    if (object != null && (object = object.byteStream()) != null) {
                        requestBuilder = object;
                        $this$forEach$iv = Charsets.UTF_8;
                        Reader reader = new InputStreamReader((InputStream)requestBuilder, (Charset)$this$forEach$iv);
                        int n = 8192;
                        bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
                    } else {
                        bufferedReader = null;
                    }
                    Closeable closeable = bufferedReader;
                    Throwable throwable = null;
                    try {
                        BufferedReader it = (BufferedReader)closeable;
                        boolean bl = false;
                        BufferedReader bufferedReader2 = it;
                        String string2 = bufferedReader2 != null ? TextStreamsKt.readText((Reader)bufferedReader2) : null;
                        string = string2;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    String string3 = string;
                    if (string == null) {
                        string3 = "";
                    }
                    return string3;
                }
                throw new Exception(response.toString());
            }
            catch (InterruptedIOException exception) {
                NetworkManagerClientExceptions.NetworkRequestTimeout specificException = new NetworkManagerClientExceptions.NetworkRequestTimeout();
                Logger.INSTANCE.error(NetworkManagerClientKt.access$getLogTag$p(), specificException);
                throw specificException;
            }
            catch (Exception exception) {
                String string = exception.getMessage();
                Intrinsics.checkNotNull((Object)string);
                NetworkManagerClientExceptions.NetworkRequestFailed specificException = new NetworkManagerClientExceptions.NetworkRequestFailed(string);
                Logger.INSTANCE.error(NetworkManagerClientKt.access$getLogTag$p(), specificException);
                throw specificException;
            }
        }

        public static /* synthetic */ String sendHTTPRequest$default(Companion companion, String string, HTTP_METHOD hTTP_METHOD, Map map, Map map2, int n, Object object) {
            if ((n & 4) != 0) {
                map = null;
            }
            if ((n & 8) != 0) {
                map2 = null;
            }
            return companion.sendHTTPRequest(string, hTTP_METHOD, map, map2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[HTTP_METHOD.values().length];
                try {
                    nArray[HTTP_METHOD.POST.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[HTTP_METHOD.GET.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

