/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP;

import io.mosip.openID4VP.OpenID4VPKt;
import io.mosip.openID4VP.authorizationRequest.AuthorizationRequest;
import io.mosip.openID4VP.authorizationRequest.presentationDefinition.PresentationDefinition;
import io.mosip.openID4VP.authorizationResponse.AuthorizationResponse;
import io.mosip.openID4VP.common.Logger;
import io.mosip.openID4VP.dto.VPResponseMetadata;
import io.mosip.openID4VP.dto.Verifier;
import io.mosip.openID4VP.networkManager.HTTP_METHOD;
import io.mosip.openID4VP.networkManager.NetworkManagerClient;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0003H\u0002J(\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00032\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007J \u0010\u0016\u001a\u00020\u00032\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00120\u0018J\u000e\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bJ\u0017\u0010\u001c\u001a\u00020\u000e2\n\u0010\u001d\u001a\u00060\u001fj\u0002`\u001e\u00a2\u0006\u0002\u0010 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/mosip/openID4VP/OpenID4VP;", "", "traceabilityId", "", "<init>", "(Ljava/lang/String;)V", "authorizationRequest", "Lio/mosip/openID4VP/authorizationRequest/AuthorizationRequest;", "getAuthorizationRequest", "()Lio/mosip/openID4VP/authorizationRequest/AuthorizationRequest;", "setAuthorizationRequest", "(Lio/mosip/openID4VP/authorizationRequest/AuthorizationRequest;)V", "responseUri", "setResponseUri", "", "authenticateVerifier", "urlEncodedAuthorizationRequest", "trustedVerifiers", "", "Lio/mosip/openID4VP/dto/Verifier;", "shouldValidateClient", "", "constructVerifiablePresentationToken", "verifiableCredentials", "", "shareVerifiablePresentation", "vpResponseMetadata", "Lio/mosip/openID4VP/dto/VPResponseMetadata;", "sendErrorToVerifier", "exception", "Lkotlin/Exception;", "Ljava/lang/Exception;", "(Ljava/lang/Exception;)V", "inji-openid4vp-0.2.0_release"})
public final class OpenID4VP {
    @NotNull
    private final String traceabilityId;
    public AuthorizationRequest authorizationRequest;
    @Nullable
    private String responseUri;

    public OpenID4VP(@NotNull String traceabilityId) {
        Intrinsics.checkNotNullParameter((Object)traceabilityId, (String)"traceabilityId");
        this.traceabilityId = traceabilityId;
    }

    @NotNull
    public final AuthorizationRequest getAuthorizationRequest() {
        AuthorizationRequest authorizationRequest = this.authorizationRequest;
        if (authorizationRequest != null) {
            return authorizationRequest;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"authorizationRequest");
        return null;
    }

    public final void setAuthorizationRequest(@NotNull AuthorizationRequest authorizationRequest) {
        Intrinsics.checkNotNullParameter((Object)authorizationRequest, (String)"<set-?>");
        this.authorizationRequest = authorizationRequest;
    }

    private final void setResponseUri(String responseUri) {
        this.responseUri = responseUri;
    }

    @JvmOverloads
    @NotNull
    public final AuthorizationRequest authenticateVerifier(@NotNull String urlEncodedAuthorizationRequest, @NotNull List<Verifier> trustedVerifiers, boolean shouldValidateClient) {
        Intrinsics.checkNotNullParameter((Object)urlEncodedAuthorizationRequest, (String)"urlEncodedAuthorizationRequest");
        Intrinsics.checkNotNullParameter(trustedVerifiers, (String)"trustedVerifiers");
        try {
            Logger.INSTANCE.setTraceabilityId(this.traceabilityId);
            this.setAuthorizationRequest(AuthorizationRequest.Companion.validateAndCreateAuthorizationRequest(urlEncodedAuthorizationRequest, trustedVerifiers, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>((Object)this){

                public final void invoke(String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    OpenID4VP.access$setResponseUri((OpenID4VP)this.receiver, p0);
                }
            }), shouldValidateClient));
            return this.getAuthorizationRequest();
        }
        catch (Exception exception) {
            this.sendErrorToVerifier(exception);
            throw exception;
        }
    }

    public static /* synthetic */ AuthorizationRequest authenticateVerifier$default(OpenID4VP openID4VP, String string, List list, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return openID4VP.authenticateVerifier(string, list, bl);
    }

    @NotNull
    public final String constructVerifiablePresentationToken(@NotNull Map<String, ? extends List<String>> verifiableCredentials) {
        Intrinsics.checkNotNullParameter(verifiableCredentials, (String)"verifiableCredentials");
        try {
            return AuthorizationResponse.Companion.constructVPTokenForSigning(verifiableCredentials);
        }
        catch (Exception exception) {
            this.sendErrorToVerifier(exception);
            throw exception;
        }
    }

    @NotNull
    public final String shareVerifiablePresentation(@NotNull VPResponseMetadata vpResponseMetadata) {
        Intrinsics.checkNotNullParameter((Object)vpResponseMetadata, (String)"vpResponseMetadata");
        try {
            String string = this.getAuthorizationRequest().getNonce();
            String string2 = this.getAuthorizationRequest().getState();
            String string3 = this.getAuthorizationRequest().getResponseUri();
            Intrinsics.checkNotNull((Object)string3);
            Object object = this.getAuthorizationRequest().getPresentationDefinition();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.mosip.openID4VP.authorizationRequest.presentationDefinition.PresentationDefinition");
            return AuthorizationResponse.Companion.shareVP(vpResponseMetadata, string, string2, string3, ((PresentationDefinition)object).getId());
        }
        catch (Exception exception) {
            this.sendErrorToVerifier(exception);
            throw exception;
        }
    }

    public final void sendErrorToVerifier(@NotNull Exception exception) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            String string = this.responseUri;
            if (string == null) break block2;
            String it = string;
            boolean bl = false;
            try {
                String string2 = exception.getMessage();
                Intrinsics.checkNotNull((Object)string2);
                Map map = NetworkManagerClient.Companion.sendHTTPRequest$default(NetworkManagerClient.Companion, it, HTTP_METHOD.POST, MapsKt.mapOf((Pair)TuplesKt.to((Object)"error", (Object)string2)), null, 8, null);
            }
            catch (Exception exception2) {
                Logger.error$default(Logger.INSTANCE, OpenID4VPKt.access$getLogTag$p(), new Exception("Unexpected error occurred while sending the error to verifier: " + exception2.getMessage()), null, 4, null);
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @JvmOverloads
    @NotNull
    public final AuthorizationRequest authenticateVerifier(@NotNull String urlEncodedAuthorizationRequest, @NotNull List<Verifier> trustedVerifiers) {
        Intrinsics.checkNotNullParameter((Object)urlEncodedAuthorizationRequest, (String)"urlEncodedAuthorizationRequest");
        Intrinsics.checkNotNullParameter(trustedVerifiers, (String)"trustedVerifiers");
        return OpenID4VP.authenticateVerifier$default(this, urlEncodedAuthorizationRequest, trustedVerifiers, false, 4, null);
    }

    public static final /* synthetic */ void access$setResponseUri(OpenID4VP $this, String responseUri) {
        $this.setResponseUri(responseUri);
    }
}

