/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP.authorizationRequest;

import io.mosip.openID4VP.authorizationRequest.AuthorizationRequest;
import io.mosip.openID4VP.authorizationRequest.AuthorizationRequestFieldConstants;
import io.mosip.openID4VP.authorizationRequest.ClientIdScheme;
import io.mosip.openID4VP.authorizationRequest.ClientMetadata;
import io.mosip.openID4VP.authorizationRequest.ClientMetadataSerializer;
import io.mosip.openID4VP.authorizationRequest.UtilsKt;
import io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler.ClientIdSchemeBasedAuthorizationRequestHandler;
import io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler.types.DidSchemeAuthorizationRequestHandler;
import io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler.types.PreRegisteredSchemeAuthorizationRequestHandler;
import io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler.types.RedirectUriSchemeAuthorizationRequestHandler;
import io.mosip.openID4VP.authorizationRequest.presentationDefinition.PresentationDefinition;
import io.mosip.openID4VP.authorizationRequest.presentationDefinition.PresentationDefinitionSerializer;
import io.mosip.openID4VP.common.Logger;
import io.mosip.openID4VP.dto.Verifier;
import io.mosip.openID4VP.networkManager.HTTP_METHOD;
import io.mosip.openID4VP.networkManager.NetworkManagerClient;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\t\u001aD\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e\u001a\"\u0010\u000f\u001a\u00020\f2\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\u0011\u001a\u00020\u0001\u001a\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0013\u001a\u00020\u0001\u001a\u001a\u0010\u0014\u001a\u00020\f2\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u0005\u001a\u001a\u0010\u0015\u001a\u00020\f2\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u0005\u001a.\u0010\u0016\u001a\u00020\f2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u00102\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"className", "", "getAuthorizationRequestHandler", "Lio/mosip/openID4VP/authorizationRequest/authorizationRequestHandler/ClientIdSchemeBasedAuthorizationRequestHandler;", "authorizationRequestParameters", "", "", "trustedVerifiers", "", "Lio/mosip/openID4VP/dto/Verifier;", "setResponseUri", "Lkotlin/Function1;", "", "shouldValidateClient", "", "validateAttribute", "", "attribute", "extractQueryParameters", "query", "parseAndValidatePresentationDefinition", "parseAndValidateClientMetadata", "validateAuthorizationRequestObjectAndParameters", "params", "authorizationRequestObject", "inji-openid4vp-0.2.0_release"})
@SourceDebugExtension(value={"SMAP\nAuthorizationRequestUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthorizationRequestUtils.kt\nio/mosip/openID4VP/authorizationRequest/AuthorizationRequestUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,173:1\n1557#2:174\n1628#2,3:175\n1246#2,4:178\n*S KotlinDebug\n*F\n+ 1 AuthorizationRequestUtils.kt\nio/mosip/openID4VP/authorizationRequest/AuthorizationRequestUtilsKt\n*L\n70#1:174\n70#1:175,3\n71#1:178,4\n*E\n"})
public final class AuthorizationRequestUtilsKt {
    @NotNull
    private static final String className;

    @NotNull
    public static final ClientIdSchemeBasedAuthorizationRequestHandler getAuthorizationRequestHandler(@NotNull Map<String, Object> authorizationRequestParameters, @NotNull List<Verifier> trustedVerifiers, @NotNull Function1<? super String, Unit> setResponseUri, boolean shouldValidateClient) {
        ClientIdSchemeBasedAuthorizationRequestHandler clientIdSchemeBasedAuthorizationRequestHandler;
        String clientIdScheme;
        String string;
        Intrinsics.checkNotNullParameter(authorizationRequestParameters, (String)"authorizationRequestParameters");
        Intrinsics.checkNotNullParameter(trustedVerifiers, (String)"trustedVerifiers");
        Intrinsics.checkNotNullParameter(setResponseUri, (String)"setResponseUri");
        String string2 = io.mosip.openID4VP.common.UtilsKt.getStringValue(authorizationRequestParameters, AuthorizationRequestFieldConstants.CLIENT_ID_SCHEME.getValue());
        if (string2 == null) {
            string2 = ClientIdScheme.PRE_REGISTERED.getValue();
        }
        if (Intrinsics.areEqual((Object)(string = (clientIdScheme = string2)), (Object)ClientIdScheme.PRE_REGISTERED.getValue())) {
            clientIdSchemeBasedAuthorizationRequestHandler = new PreRegisteredSchemeAuthorizationRequestHandler(trustedVerifiers, authorizationRequestParameters, shouldValidateClient, setResponseUri);
        } else if (Intrinsics.areEqual((Object)string, (Object)ClientIdScheme.REDIRECT_URI.getValue())) {
            clientIdSchemeBasedAuthorizationRequestHandler = new RedirectUriSchemeAuthorizationRequestHandler(authorizationRequestParameters, setResponseUri);
        } else if (Intrinsics.areEqual((Object)string, (Object)ClientIdScheme.DID.getValue())) {
            clientIdSchemeBasedAuthorizationRequestHandler = new DidSchemeAuthorizationRequestHandler(authorizationRequestParameters, setResponseUri);
        } else {
            Logger logger = Logger.INSTANCE;
            String string3 = className;
            throw Logger.handleException$default(logger, "InvalidClientIdScheme", "Given client_id_scheme is not supported", null, string3, null, 20, null);
        }
        return clientIdSchemeBasedAuthorizationRequestHandler;
    }

    public static final void validateAttribute(@NotNull Map<String, ? extends Object> authorizationRequestParameters, @NotNull String attribute) {
        Intrinsics.checkNotNullParameter(authorizationRequestParameters, (String)"authorizationRequestParameters");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        String value = io.mosip.openID4VP.common.UtilsKt.getStringValue(authorizationRequestParameters, attribute);
        if (value == null || Intrinsics.areEqual((Object)value, (Object)"null") || ((CharSequence)value).length() == 0) {
            throw Logger.handleException$default(Logger.INSTANCE, authorizationRequestParameters.get(attribute) == null ? "MissingInput" : "InvalidInput", null, CollectionsKt.listOf((Object)attribute), className, "String", 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, Object> extractQueryParameters(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        try {
            void var3_5;
            void $this$associateByTo$iv;
            Object object;
            void $this$mapTo$iv$iv;
            String urlDecodedQueryString = URLDecoder.decode(query, StandardCharsets.UTF_8.toString());
            Intrinsics.checkNotNull((Object)urlDecodedQueryString);
            String[] stringArray = new String[]{"&"};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)urlDecodedQueryString, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                String[] stringArray2 = new String[]{"="};
                object.add(StringsKt.split$default((CharSequence)((CharSequence)it), (String[])stringArray2, (boolean)false, (int)0, (int)6, null));
            }
            $this$map$iv = (List)destination$iv$iv;
            Map destination$iv = new LinkedHashMap();
            boolean $i$f$associateByTo = false;
            for (Object element$iv : $this$associateByTo$iv) {
                List list = (List)element$iv;
                object = destination$iv;
                boolean bl = false;
                List it = (List)element$iv;
                String string = (String)it.get(0);
                boolean bl2 = false;
                String string2 = (String)it.get(1);
                object.put(string, string2);
            }
            return var3_5;
        }
        catch (Exception exception) {
            throw Logger.handleException$default(Logger.INSTANCE, "InvalidQueryParams", "Exception occurred when extracting the query params from Authorization Request : " + exception.getMessage(), null, className, null, 20, null);
        }
    }

    public static final void parseAndValidatePresentationDefinition(@NotNull Map<String, Object> authorizationRequestParameters) {
        PresentationDefinition presentationDefinition;
        Intrinsics.checkNotNullParameter(authorizationRequestParameters, (String)"authorizationRequestParameters");
        boolean hasPresentationDefinition = authorizationRequestParameters.containsKey(AuthorizationRequestFieldConstants.PRESENTATION_DEFINITION.getValue());
        boolean hasPresentationDefinitionUri = authorizationRequestParameters.containsKey(AuthorizationRequestFieldConstants.PRESENTATION_DEFINITION_URI.getValue());
        Object presentationDefinition2 = null;
        if (hasPresentationDefinition && hasPresentationDefinitionUri) {
            throw Logger.handleException$default(Logger.INSTANCE, "InvalidQueryParams", "Either presentation_definition or presentation_definition_uri request param can be provided but not both", null, className, null, 20, null);
        }
        if (hasPresentationDefinition) {
            AuthorizationRequestUtilsKt.validateAttribute(authorizationRequestParameters, AuthorizationRequestFieldConstants.PRESENTATION_DEFINITION.getValue());
            Object object = authorizationRequestParameters.get(AuthorizationRequestFieldConstants.PRESENTATION_DEFINITION.getValue());
            Intrinsics.checkNotNull((Object)object);
            presentationDefinition2 = object;
        } else if (hasPresentationDefinitionUri) {
            AuthorizationRequestUtilsKt.validateAttribute(authorizationRequestParameters, AuthorizationRequestFieldConstants.PRESENTATION_DEFINITION_URI.getValue());
            String string = io.mosip.openID4VP.common.UtilsKt.getStringValue(authorizationRequestParameters, AuthorizationRequestFieldConstants.PRESENTATION_DEFINITION_URI.getValue());
            Intrinsics.checkNotNull((Object)string);
            String presentationDefinitionUri = string;
            if (!io.mosip.openID4VP.common.UtilsKt.isValidUrl(presentationDefinitionUri)) {
                Logger logger = Logger.INSTANCE;
                String string2 = className;
                String string3 = AuthorizationRequestFieldConstants.PRESENTATION_DEFINITION_URI.getValue() + " data is not valid";
                throw Logger.handleException$default(logger, "InvalidData", string3, null, string2, null, 20, null);
            }
            Map response = NetworkManagerClient.Companion.sendHTTPRequest$default(NetworkManagerClient.Companion, presentationDefinitionUri, HTTP_METHOD.GET, null, null, 12, null);
            presentationDefinition2 = String.valueOf(response.get("body"));
        } else {
            throw Logger.handleException$default(Logger.INSTANCE, "InvalidQueryParams", "Either presentation_definition or presentation_definition_uri request param must be present", null, className, null, 20, null);
        }
        Object object = presentationDefinition2;
        if (object instanceof String) {
            presentationDefinition = (PresentationDefinition)UtilsKt.deserializeAndValidate((String)presentationDefinition2, (KSerializer)PresentationDefinitionSerializer.INSTANCE);
        } else if (object instanceof Map) {
            Object object2 = presentationDefinition2;
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
            presentationDefinition = (PresentationDefinition)UtilsKt.deserializeAndValidate((Map)object2, (KSerializer)PresentationDefinitionSerializer.INSTANCE);
        } else {
            presentationDefinition = null;
        }
        PresentationDefinition presentationDefinitionObj = presentationDefinition;
        String string = AuthorizationRequestFieldConstants.PRESENTATION_DEFINITION.getValue();
        PresentationDefinition presentationDefinition3 = presentationDefinitionObj;
        Intrinsics.checkNotNull((Object)presentationDefinition3);
        authorizationRequestParameters.put(string, presentationDefinition3);
    }

    public static final void parseAndValidateClientMetadata(@NotNull Map<String, Object> authorizationRequestParameters) {
        block0: {
            Intrinsics.checkNotNullParameter(authorizationRequestParameters, (String)"authorizationRequestParameters");
            Object object = authorizationRequestParameters.get(AuthorizationRequestFieldConstants.CLIENT_METADATA.getValue());
            if (object == null) break block0;
            Object it = object;
            boolean bl = false;
            Object object2 = it;
            ClientMetadata clientMetadata = object2 instanceof String ? (ClientMetadata)UtilsKt.deserializeAndValidate((String)it, (KSerializer)ClientMetadataSerializer.INSTANCE) : (object2 instanceof Map ? (ClientMetadata)UtilsKt.deserializeAndValidate((Map)it, (KSerializer)ClientMetadataSerializer.INSTANCE) : null);
            String string = AuthorizationRequestFieldConstants.CLIENT_METADATA.getValue();
            ClientMetadata clientMetadata2 = clientMetadata;
            Intrinsics.checkNotNull((Object)clientMetadata2);
            authorizationRequestParameters.put(string, clientMetadata2);
        }
    }

    public static final void validateAuthorizationRequestObjectAndParameters(@NotNull Map<String, ? extends Object> params, @NotNull Map<String, ? extends Object> authorizationRequestObject) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Intrinsics.checkNotNullParameter(authorizationRequestObject, (String)"authorizationRequestObject");
        if (!Intrinsics.areEqual((Object)params.get(AuthorizationRequestFieldConstants.CLIENT_ID.getValue()), (Object)authorizationRequestObject.get(AuthorizationRequestFieldConstants.CLIENT_ID.getValue()))) {
            throw Logger.handleException$default(Logger.INSTANCE, "InvalidData", "Client Id mismatch in Authorization Request parameter and the Request Object", null, className, null, 20, null);
        }
        if (params.get(AuthorizationRequestFieldConstants.CLIENT_ID_SCHEME.getValue()) != null && !Intrinsics.areEqual((Object)params.get(AuthorizationRequestFieldConstants.CLIENT_ID_SCHEME.getValue()), (Object)authorizationRequestObject.get(AuthorizationRequestFieldConstants.CLIENT_ID_SCHEME.getValue()))) {
            throw Logger.handleException$default(Logger.INSTANCE, "InvalidData", "Client Id Scheme mismatch in Authorization Request parameter and the Request Object", null, className, null, 20, null);
        }
    }

    static {
        String string = Reflection.getOrCreateKotlinClass(AuthorizationRequest.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        className = string;
    }
}

