/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler;

import io.mosip.openID4VP.authorizationRequest.AuthorizationRequest;
import io.mosip.openID4VP.authorizationRequest.AuthorizationRequestFieldConstants;
import io.mosip.openID4VP.authorizationRequest.AuthorizationRequestUtilsKt;
import io.mosip.openID4VP.authorizationRequest.ClientIdScheme;
import io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler.ClientIdSchemeBasedAuthorizationRequestHandlerKt;
import io.mosip.openID4VP.common.Logger;
import io.mosip.openID4VP.common.UtilsKt;
import io.mosip.openID4VP.networkManager.HTTP_METHOD;
import io.mosip.openID4VP.networkManager.NetworkManagerClient;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B/\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0014\u001a\u00020\u0007H\u0016J\u0006\u0010\u0015\u001a\u00020\u0007J\b\u0010\u0016\u001a\u00020\u0007H&J\u0006\u0010\u0017\u001a\u00020\u0007J\b\u0010\u0018\u001a\u00020\u0007H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aR&\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR&\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000b\"\u0004\b\u0013\u0010\r\u00a8\u0006\u001b"}, d2={"Lio/mosip/openID4VP/authorizationRequest/authorizationRequestHandler/ClientIdSchemeBasedAuthorizationRequestHandler;", "", "authorizationRequestParameters", "", "", "setResponseUri", "Lkotlin/Function1;", "", "<init>", "(Ljava/util/Map;Lkotlin/jvm/functions/Function1;)V", "getAuthorizationRequestParameters", "()Ljava/util/Map;", "setAuthorizationRequestParameters", "(Ljava/util/Map;)V", "getSetResponseUri", "()Lkotlin/jvm/functions/Function1;", "requestUriResponse", "", "getRequestUriResponse", "setRequestUriResponse", "validateClientId", "fetchAuthorizationRequest", "validateRequestUriResponse", "setResponseUrl", "validateAndParseRequestFields", "createAuthorizationRequest", "Lio/mosip/openID4VP/authorizationRequest/AuthorizationRequest;", "inji-openid4vp-0.2.0_release"})
public abstract class ClientIdSchemeBasedAuthorizationRequestHandler {
    @NotNull
    private Map<String, Object> authorizationRequestParameters;
    @NotNull
    private final Function1<String, Unit> setResponseUri;
    @NotNull
    private Map<String, ? extends Object> requestUriResponse;

    public ClientIdSchemeBasedAuthorizationRequestHandler(@NotNull Map<String, Object> authorizationRequestParameters, @NotNull Function1<? super String, Unit> setResponseUri) {
        Intrinsics.checkNotNullParameter(authorizationRequestParameters, (String)"authorizationRequestParameters");
        Intrinsics.checkNotNullParameter(setResponseUri, (String)"setResponseUri");
        this.authorizationRequestParameters = authorizationRequestParameters;
        this.setResponseUri = setResponseUri;
        this.requestUriResponse = MapsKt.emptyMap();
    }

    @NotNull
    public final Map<String, Object> getAuthorizationRequestParameters() {
        return this.authorizationRequestParameters;
    }

    public final void setAuthorizationRequestParameters(@NotNull Map<String, Object> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.authorizationRequestParameters = map;
    }

    @NotNull
    public final Function1<String, Unit> getSetResponseUri() {
        return this.setResponseUri;
    }

    @NotNull
    public final Map<String, Object> getRequestUriResponse() {
        return this.requestUriResponse;
    }

    public final void setRequestUriResponse(@NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.requestUriResponse = map;
    }

    public void validateClientId() {
        AuthorizationRequestUtilsKt.validateAttribute(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.CLIENT_ID.getValue());
    }

    public final void fetchAuthorizationRequest() {
        String string = UtilsKt.getStringValue(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.REQUEST_URI.getValue());
        if (string != null) {
            String it = string;
            boolean bl = false;
            if (!UtilsKt.isValidUrl(it)) {
                Logger logger = Logger.INSTANCE;
                String string2 = ClientIdSchemeBasedAuthorizationRequestHandlerKt.access$getClassName$p();
                String string3 = AuthorizationRequestFieldConstants.REQUEST_URI.getValue() + " data is not valid";
                throw Logger.handleException$default(logger, "InvalidData", string3, null, string2, null, 20, null);
            }
            String string4 = UtilsKt.getStringValue(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.REQUEST_URI_METHOD.getValue());
            if (string4 == null) {
                string4 = "get";
            }
            String requestUriMethod = string4;
            HTTP_METHOD httpMethod = UtilsKt.determineHttpMethod(requestUriMethod);
            this.requestUriResponse = NetworkManagerClient.Companion.sendHTTPRequest$default(NetworkManagerClient.Companion, it, httpMethod, null, null, 12, null);
        }
        this.validateRequestUriResponse();
    }

    public abstract void validateRequestUriResponse();

    public final void setResponseUrl() {
        String verifierResponseUri;
        String string = UtilsKt.getStringValue(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.RESPONSE_MODE.getValue());
        if (string == null) {
            Logger logger = Logger.INSTANCE;
            String string2 = ClientIdSchemeBasedAuthorizationRequestHandlerKt.access$getClassName$p();
            List list = CollectionsKt.listOf((Object)AuthorizationRequestFieldConstants.RESPONSE_MODE.getValue());
            throw Logger.handleException$default(logger, "MissingInput", null, list, string2, null, 18, null);
        }
        String responseMode = string;
        if (!Intrinsics.areEqual((Object)responseMode, (Object)"direct_post")) {
            Logger logger = Logger.INSTANCE;
            String string3 = ClientIdSchemeBasedAuthorizationRequestHandlerKt.access$getClassName$p();
            throw Logger.handleException$default(logger, "InvalidResponseMode", "Given response_mode is not supported", null, string3, null, 20, null);
        }
        AuthorizationRequestUtilsKt.validateAttribute(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.RESPONSE_URI.getValue());
        String string4 = verifierResponseUri = UtilsKt.getStringValue(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.RESPONSE_URI.getValue());
        Intrinsics.checkNotNull((Object)string4);
        if (!UtilsKt.isValidUrl(string4)) {
            Logger logger = Logger.INSTANCE;
            String string5 = ClientIdSchemeBasedAuthorizationRequestHandlerKt.access$getClassName$p();
            String string6 = AuthorizationRequestFieldConstants.RESPONSE_URI.getValue() + " data is not valid";
            throw Logger.handleException$default(logger, "InvalidData", string6, null, string5, null, 20, null);
        }
        this.setResponseUri.invoke((Object)verifierResponseUri);
    }

    public void validateAndParseRequestFields() {
        AuthorizationRequestUtilsKt.validateAttribute(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.RESPONSE_TYPE.getValue());
        AuthorizationRequestUtilsKt.validateAttribute(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.NONCE.getValue());
        String string = UtilsKt.getStringValue(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.STATE.getValue());
        if (string != null) {
            String it = string;
            boolean bl = false;
            AuthorizationRequestUtilsKt.validateAttribute(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.STATE.getValue());
        }
        AuthorizationRequestUtilsKt.parseAndValidateClientMetadata(this.authorizationRequestParameters);
        AuthorizationRequestUtilsKt.parseAndValidatePresentationDefinition(this.authorizationRequestParameters);
    }

    @NotNull
    public final AuthorizationRequest createAuthorizationRequest() {
        String string = UtilsKt.getStringValue(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.CLIENT_ID.getValue());
        Intrinsics.checkNotNull((Object)string);
        String string2 = UtilsKt.getStringValue(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.CLIENT_ID_SCHEME.getValue());
        if (string2 == null) {
            string2 = ClientIdScheme.PRE_REGISTERED.getValue();
        }
        String string3 = UtilsKt.getStringValue(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.RESPONSE_TYPE.getValue());
        Intrinsics.checkNotNull((Object)string3);
        String string4 = UtilsKt.getStringValue(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.RESPONSE_MODE.getValue());
        Object object = this.authorizationRequestParameters.get(AuthorizationRequestFieldConstants.PRESENTATION_DEFINITION.getValue());
        Intrinsics.checkNotNull((Object)object);
        String string5 = UtilsKt.getStringValue(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.RESPONSE_URI.getValue());
        String string6 = UtilsKt.getStringValue(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.REDIRECT_URI.getValue());
        String string7 = UtilsKt.getStringValue(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.NONCE.getValue());
        Intrinsics.checkNotNull((Object)string7);
        return new AuthorizationRequest(string, string2, string3, string4, object, string5, string6, string7, UtilsKt.getStringValue(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.STATE.getValue()), UtilsKt.getStringValue(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.CLIENT_METADATA.getValue()));
    }
}

