/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler.types;

import io.mosip.openID4VP.authorizationRequest.AuthorizationRequestFieldConstants;
import io.mosip.openID4VP.authorizationRequest.AuthorizationRequestUtilsKt;
import io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler.ClientIdSchemeBasedAuthorizationRequestHandler;
import io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler.types.DidSchemeAuthorizationRequestHandlerKt;
import io.mosip.openID4VP.common.Logger;
import io.mosip.openID4VP.common.UtilsKt;
import io.mosip.openID4VP.jwt.JwtHandler;
import io.mosip.openID4VP.jwt.keyResolver.types.DidPublicKeyResolver;
import io.mosip.openID4VP.networkManager.CONTENT_TYPES;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lio/mosip/openID4VP/authorizationRequest/authorizationRequestHandler/types/DidSchemeAuthorizationRequestHandler;", "Lio/mosip/openID4VP/authorizationRequest/authorizationRequestHandler/ClientIdSchemeBasedAuthorizationRequestHandler;", "authorizationRequestParameters", "", "", "", "setResponseUri", "Lkotlin/Function1;", "", "<init>", "(Ljava/util/Map;Lkotlin/jvm/functions/Function1;)V", "validateClientId", "validateRequestUriResponse", "isValidContentType", "", "headers", "Lokhttp3/Headers;", "inji-openid4vp-0.2.0_release"})
public final class DidSchemeAuthorizationRequestHandler
extends ClientIdSchemeBasedAuthorizationRequestHandler {
    public DidSchemeAuthorizationRequestHandler(@NotNull Map<String, Object> authorizationRequestParameters, @NotNull Function1<? super String, Unit> setResponseUri) {
        Intrinsics.checkNotNullParameter(authorizationRequestParameters, (String)"authorizationRequestParameters");
        Intrinsics.checkNotNullParameter(setResponseUri, (String)"setResponseUri");
        super(authorizationRequestParameters, setResponseUri);
    }

    @Override
    public void validateClientId() {
        super.validateClientId();
        String string = UtilsKt.getStringValue(this.getAuthorizationRequestParameters(), AuthorizationRequestFieldConstants.CLIENT_ID.getValue());
        Intrinsics.checkNotNull((Object)string);
        if (!StringsKt.startsWith$default((String)string, (String)"did", (boolean)false, (int)2, null)) {
            Logger logger = Logger.INSTANCE;
            String string2 = DidSchemeAuthorizationRequestHandlerKt.access$getClassName$p();
            throw Logger.handleException$default(logger, "InvalidVerifier", "Client ID should start with did prefix if client_id_scheme is did", null, string2, null, 20, null);
        }
    }

    @Override
    public void validateRequestUriResponse() {
        String responseBody;
        if (!this.getRequestUriResponse().isEmpty()) {
            Object object = this.getRequestUriResponse().get("header");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type okhttp3.Headers");
            Headers headers = (Headers)object;
            responseBody = String.valueOf(this.getRequestUriResponse().get("body"));
            if (!this.isValidContentType(headers) || !UtilsKt.isJWT(responseBody)) {
                Logger logger = Logger.INSTANCE;
                String string = DidSchemeAuthorizationRequestHandlerKt.access$getClassName$p();
                throw Logger.handleException$default(logger, "InvalidData", "Authorization Request must be signed for given client_id_scheme", null, string, null, 20, null);
            }
        } else {
            Logger logger = Logger.INSTANCE;
            String string = DidSchemeAuthorizationRequestHandlerKt.access$getClassName$p();
            List list = CollectionsKt.listOf((Object)AuthorizationRequestFieldConstants.REQUEST_URI.getValue());
            throw Logger.handleException$default(logger, "MissingInput", null, list, string, null, 18, null);
        }
        String string = UtilsKt.getStringValue(this.getAuthorizationRequestParameters(), AuthorizationRequestFieldConstants.CLIENT_ID.getValue());
        Intrinsics.checkNotNull((Object)string);
        String didUrl = string;
        new JwtHandler(responseBody, new DidPublicKeyResolver(didUrl)).verify();
        Map<String, Object> authorizationRequestObject = UtilsKt.extractDataJsonFromJwt(responseBody, JwtHandler.JwtPart.PAYLOAD);
        AuthorizationRequestUtilsKt.validateAuthorizationRequestObjectAndParameters(this.getAuthorizationRequestParameters(), authorizationRequestObject);
        this.setAuthorizationRequestParameters(authorizationRequestObject);
    }

    private final boolean isValidContentType(Headers headers) {
        String string = headers.get("content-type");
        return string != null ? StringsKt.contains((CharSequence)string, (CharSequence)CONTENT_TYPES.APPLICATION_JWT.getValue(), (boolean)true) : false;
    }
}

