/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler.types;

import io.mosip.openID4VP.authorizationRequest.AuthorizationRequestFieldConstants;
import io.mosip.openID4VP.authorizationRequest.AuthorizationRequestUtilsKt;
import io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler.ClientIdSchemeBasedAuthorizationRequestHandler;
import io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler.types.PreRegisteredSchemeAuthorizationRequestHandlerKt;
import io.mosip.openID4VP.common.Logger;
import io.mosip.openID4VP.common.UtilsKt;
import io.mosip.openID4VP.dto.Verifier;
import io.mosip.openID4VP.networkManager.CONTENT_TYPES;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BE\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/mosip/openID4VP/authorizationRequest/authorizationRequestHandler/types/PreRegisteredSchemeAuthorizationRequestHandler;", "Lio/mosip/openID4VP/authorizationRequest/authorizationRequestHandler/ClientIdSchemeBasedAuthorizationRequestHandler;", "trustedVerifiers", "", "Lio/mosip/openID4VP/dto/Verifier;", "authorizationRequestParameters", "", "", "", "shouldValidateClient", "", "setResponseUri", "Lkotlin/Function1;", "", "<init>", "(Ljava/util/List;Ljava/util/Map;ZLkotlin/jvm/functions/Function1;)V", "validateClientId", "validateRequestUriResponse", "validateAndParseRequestFields", "isValidContentType", "headers", "Lokhttp3/Headers;", "inji-openid4vp-0.2.0_release"})
@SourceDebugExtension(value={"SMAP\nPreRegisteredSchemeAuthorizationRequestHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreRegisteredSchemeAuthorizationRequestHandler.kt\nio/mosip/openID4VP/authorizationRequest/authorizationRequestHandler/types/PreRegisteredSchemeAuthorizationRequestHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n2632#2,3:82\n2632#2,3:85\n*S KotlinDebug\n*F\n+ 1 PreRegisteredSchemeAuthorizationRequestHandler.kt\nio/mosip/openID4VP/authorizationRequest/authorizationRequestHandler/types/PreRegisteredSchemeAuthorizationRequestHandler\n*L\n27#1:82,3\n69#1:85,3\n*E\n"})
public final class PreRegisteredSchemeAuthorizationRequestHandler
extends ClientIdSchemeBasedAuthorizationRequestHandler {
    @NotNull
    private final List<Verifier> trustedVerifiers;
    private final boolean shouldValidateClient;

    public PreRegisteredSchemeAuthorizationRequestHandler(@NotNull List<Verifier> trustedVerifiers, @NotNull Map<String, Object> authorizationRequestParameters, boolean shouldValidateClient, @NotNull Function1<? super String, Unit> setResponseUri) {
        Intrinsics.checkNotNullParameter(trustedVerifiers, (String)"trustedVerifiers");
        Intrinsics.checkNotNullParameter(authorizationRequestParameters, (String)"authorizationRequestParameters");
        Intrinsics.checkNotNullParameter(setResponseUri, (String)"setResponseUri");
        super(authorizationRequestParameters, setResponseUri);
        this.trustedVerifiers = trustedVerifiers;
        this.shouldValidateClient = shouldValidateClient;
    }

    @Override
    public void validateClientId() {
        boolean bl;
        block5: {
            super.validateClientId();
            if (!this.shouldValidateClient) {
                return;
            }
            String string = UtilsKt.getStringValue(this.getAuthorizationRequestParameters(), AuthorizationRequestFieldConstants.CLIENT_ID.getValue());
            Intrinsics.checkNotNull((Object)string);
            String clientId = string;
            Iterable $this$none$iv = this.trustedVerifiers;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Verifier it = (Verifier)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getClientId(), (Object)clientId)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            Logger logger = Logger.INSTANCE;
            String string = PreRegisteredSchemeAuthorizationRequestHandlerKt.access$getClassName$p();
            throw Logger.handleException$default(logger, "InvalidVerifier", "Verifier is not trusted by the wallet", null, string, null, 20, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validateRequestUriResponse() {
        Map<String, Object> map;
        if (this.getRequestUriResponse().isEmpty()) {
            map = this.getAuthorizationRequestParameters();
        } else {
            Object object = this.getRequestUriResponse().get("header");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type okhttp3.Headers");
            Headers headers = (Headers)object;
            String responseBody = String.valueOf(this.getRequestUriResponse().get("body"));
            if (this.isValidContentType(headers)) {
                void var3_3;
                Map<String, Object> authorizationRequestObject = UtilsKt.convertJsonToMap(responseBody);
                AuthorizationRequestUtilsKt.validateAuthorizationRequestObjectAndParameters(this.getAuthorizationRequestParameters(), authorizationRequestObject);
                map = var3_3;
            } else {
                Logger logger = Logger.INSTANCE;
                String string = PreRegisteredSchemeAuthorizationRequestHandlerKt.access$getClassName$p();
                throw Logger.handleException$default(logger, "InvalidData", "Authorization Request must not be signed for given client_id_scheme", null, string, null, 20, null);
            }
        }
        this.setAuthorizationRequestParameters(map);
    }

    @Override
    public void validateAndParseRequestFields() {
        boolean bl;
        block5: {
            super.validateAndParseRequestFields();
            if (!this.shouldValidateClient) {
                return;
            }
            String string = UtilsKt.getStringValue(this.getAuthorizationRequestParameters(), AuthorizationRequestFieldConstants.CLIENT_ID.getValue());
            Intrinsics.checkNotNull((Object)string);
            String clientId = string;
            String string2 = UtilsKt.getStringValue(this.getAuthorizationRequestParameters(), AuthorizationRequestFieldConstants.RESPONSE_URI.getValue());
            Intrinsics.checkNotNull((Object)string2);
            String responseUri = string2;
            Iterable $this$none$iv = this.trustedVerifiers;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Verifier it = (Verifier)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getClientId(), (Object)clientId) && it.getResponseUris().contains(responseUri))) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            Logger logger = Logger.INSTANCE;
            String string = PreRegisteredSchemeAuthorizationRequestHandlerKt.access$getClassName$p();
            throw Logger.handleException$default(logger, "InvalidVerifier", "Verifier is not trusted by the wallet", null, string, null, 20, null);
        }
    }

    private final boolean isValidContentType(Headers headers) {
        String string = headers.get("content-type");
        return string != null ? StringsKt.contains((CharSequence)string, (CharSequence)CONTENT_TYPES.APPLICATION_JSON.getValue(), (boolean)true) : false;
    }
}

