/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler.types;

import io.mosip.openID4VP.authorizationRequest.AuthorizationRequestFieldConstants;
import io.mosip.openID4VP.authorizationRequest.AuthorizationRequestUtilsKt;
import io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler.ClientIdSchemeBasedAuthorizationRequestHandler;
import io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler.types.RedirectUriSchemeAuthorizationRequestHandlerKt;
import io.mosip.openID4VP.common.Logger;
import io.mosip.openID4VP.common.UtilsKt;
import io.mosip.openID4VP.networkManager.CONTENT_TYPES;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\bH\u0016J,\u0010\r\u001a\u00020\b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lio/mosip/openID4VP/authorizationRequest/authorizationRequestHandler/types/RedirectUriSchemeAuthorizationRequestHandler;", "Lio/mosip/openID4VP/authorizationRequest/authorizationRequestHandler/ClientIdSchemeBasedAuthorizationRequestHandler;", "authorizationRequestParameters", "", "", "", "setResponseUri", "Lkotlin/Function1;", "", "<init>", "(Ljava/util/Map;Lkotlin/jvm/functions/Function1;)V", "validateRequestUriResponse", "validateAndParseRequestFields", "validateUriCombinations", "authRequestParam", "", "validAttribute", "inValidAttribute", "isValidContentType", "", "headers", "Lokhttp3/Headers;", "inji-openid4vp-0.2.0_release"})
public final class RedirectUriSchemeAuthorizationRequestHandler
extends ClientIdSchemeBasedAuthorizationRequestHandler {
    public RedirectUriSchemeAuthorizationRequestHandler(@NotNull Map<String, Object> authorizationRequestParameters, @NotNull Function1<? super String, Unit> setResponseUri) {
        Intrinsics.checkNotNullParameter(authorizationRequestParameters, (String)"authorizationRequestParameters");
        Intrinsics.checkNotNullParameter(setResponseUri, (String)"setResponseUri");
        super(authorizationRequestParameters, setResponseUri);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validateRequestUriResponse() {
        Map<String, Object> map;
        if (this.getRequestUriResponse().isEmpty()) {
            map = this.getAuthorizationRequestParameters();
        } else {
            Object object = this.getRequestUriResponse().get("header");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type okhttp3.Headers");
            Headers headers = (Headers)object;
            String responseBody = String.valueOf(this.getRequestUriResponse().get("body"));
            if (this.isValidContentType(headers)) {
                void var3_3;
                Map<String, Object> authorizationRequestObject = UtilsKt.convertJsonToMap(responseBody);
                AuthorizationRequestUtilsKt.validateAuthorizationRequestObjectAndParameters(this.getAuthorizationRequestParameters(), authorizationRequestObject);
                map = var3_3;
            } else {
                Logger logger = Logger.INSTANCE;
                String string = RedirectUriSchemeAuthorizationRequestHandlerKt.access$getClassName$p();
                throw Logger.handleException$default(logger, "InvalidData", "Authorization Request must not be signed for given client_id_scheme", null, string, null, 20, null);
            }
        }
        this.setAuthorizationRequestParameters(map);
    }

    @Override
    public void validateAndParseRequestFields() {
        super.validateAndParseRequestFields();
        String string = UtilsKt.getStringValue(this.getAuthorizationRequestParameters(), AuthorizationRequestFieldConstants.RESPONSE_MODE.getValue());
        if (string == null) {
            Logger logger = Logger.INSTANCE;
            String string2 = RedirectUriSchemeAuthorizationRequestHandlerKt.access$getClassName$p();
            List list = CollectionsKt.listOf((Object)AuthorizationRequestFieldConstants.RESPONSE_MODE.getValue());
            throw Logger.handleException$default(logger, "MissingInput", null, list, string2, null, 18, null);
        }
        String responseMode = string;
        if (!Intrinsics.areEqual((Object)responseMode, (Object)"direct_post")) {
            Logger logger = Logger.INSTANCE;
            String string3 = RedirectUriSchemeAuthorizationRequestHandlerKt.access$getClassName$p();
            throw Logger.handleException$default(logger, "InvalidResponseMode", "Given response_mode is not supported", null, string3, null, 20, null);
        }
        this.validateUriCombinations(this.getAuthorizationRequestParameters(), AuthorizationRequestFieldConstants.RESPONSE_URI.getValue(), AuthorizationRequestFieldConstants.REDIRECT_URI.getValue());
    }

    private final void validateUriCombinations(Map<String, ? extends Object> authRequestParam, String validAttribute, String inValidAttribute) {
        if (authRequestParam.containsKey(inValidAttribute)) {
            Logger logger = Logger.INSTANCE;
            String string = RedirectUriSchemeAuthorizationRequestHandlerKt.access$getClassName$p();
            String string2 = inValidAttribute + " should not be present for given response_mode";
            throw Logger.handleException$default(logger, "InvalidData", string2, null, string, null, 20, null);
        }
        AuthorizationRequestUtilsKt.validateAttribute(authRequestParam, validAttribute);
        if (!Intrinsics.areEqual((Object)authRequestParam.get(validAttribute), (Object)authRequestParam.get(AuthorizationRequestFieldConstants.CLIENT_ID.getValue()))) {
            Logger logger = Logger.INSTANCE;
            String string = RedirectUriSchemeAuthorizationRequestHandlerKt.access$getClassName$p();
            String string3 = validAttribute + " should be equal to client_id for given client_id_scheme";
            throw Logger.handleException$default(logger, "InvalidVerifierRedirectUri", string3, null, string, null, 20, null);
        }
    }

    private final boolean isValidContentType(Headers headers) {
        String string = headers.get("content-type");
        return string != null ? StringsKt.contains((CharSequence)string, (CharSequence)CONTENT_TYPES.APPLICATION_JSON.getValue(), (boolean)true) : false;
    }
}

