/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP.common;

import android.annotation.SuppressLint;
import android.util.Base64;
import io.mosip.openID4VP.common.BuildConfig;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0003J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"Lio/mosip/openID4VP/common/Decoder;", "", "<init>", "()V", "decodeBase64Data", "", "content", "", "javaBase64UrlDecode", "androidBase64UrlDecode", "inji-openid4vp-0.2.0_release"})
public final class Decoder {
    @NotNull
    public static final Decoder INSTANCE = new Decoder();

    private Decoder() {
    }

    @NotNull
    public final byte[] decodeBase64Data(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        byte[] decodedBase64ByteArray = BuildConfig.INSTANCE.isAndroid() ? (BuildConfig.INSTANCE.getVersionSDKInt() >= 26 ? this.javaBase64UrlDecode(content) : this.androidBase64UrlDecode(content)) : this.javaBase64UrlDecode(content);
        return decodedBase64ByteArray;
    }

    @SuppressLint(value={"NewApi"})
    private final byte[] javaBase64UrlDecode(String content) {
        Base64.Decoder decoder = java.util.Base64.getUrlDecoder();
        String string = content;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byArray2 = decoder.decode(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"decode(...)");
        return byArray2;
    }

    private final byte[] androidBase64UrlDecode(String content) {
        Object base64 = StringsKt.replace$default((String)StringsKt.replace$default((String)content, (char)'-', (char)'+', (boolean)false, (int)4, null), (char)'_', (char)'/', (boolean)false, (int)4, null);
        switch (((String)base64).length() % 4) {
            case 2: {
                base64 = (String)base64 + "==";
                break;
            }
            case 3: {
                base64 = (String)base64 + "=";
            }
        }
        byte[] byArray = Base64.decode((String)base64, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        return byArray;
    }
}

