/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP.common;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import io.mosip.openID4VP.common.Decoder;
import io.mosip.openID4VP.jwt.JwtHandler;
import io.mosip.openID4VP.networkManager.HTTP_METHOD;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0001\u001a\u000e\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0001\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001\u001a\"\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a$\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u00142\u0006\u0010\u0015\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"URL_PATTERN", "", "isValidUrl", "", "url", "convertJsonToMap", "", "", "jsonString", "isJWT", "input", "determineHttpMethod", "Lio/mosip/openID4VP/networkManager/HTTP_METHOD;", "method", "extractDataJsonFromJwt", "jwtToken", "part", "Lio/mosip/openID4VP/jwt/JwtHandler$JwtPart;", "getStringValue", "params", "", "key", "inji-openid4vp-0.2.0_release"})
public final class UtilsKt {
    @NotNull
    private static final String URL_PATTERN = "^https://(?:[\\w-]+\\.)+[\\w-]+(?:/[\\w\\-.~!$&'()*+,;=:@%]+)*/?(?:\\?[^#\\s]*)?(?:#.*)?$";

    public static final boolean isValidUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        CharSequence charSequence = url;
        return new Regex(URL_PATTERN).matches(charSequence);
    }

    @NotNull
    public static final Map<String, Object> convertJsonToMap(@NotNull String jsonString) {
        Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
        ObjectMapper mapper = ExtensionsKt.jacksonObjectMapper();
        Object object = mapper.readValue(jsonString, (TypeReference)new TypeReference<Map<String, Object>>(){});
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
        return (Map)object;
    }

    public static final boolean isJWT(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String[] stringArray = new String[]{"."};
        return StringsKt.split$default((CharSequence)input, (String[])stringArray, (boolean)false, (int)0, (int)6, null).size() == 3;
    }

    @NotNull
    public static final HTTP_METHOD determineHttpMethod(@NotNull String method) {
        HTTP_METHOD hTTP_METHOD;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        String string = method.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String string2 = string;
        if (Intrinsics.areEqual((Object)string2, (Object)"get")) {
            hTTP_METHOD = HTTP_METHOD.GET;
        } else if (Intrinsics.areEqual((Object)string2, (Object)"post")) {
            hTTP_METHOD = HTTP_METHOD.POST;
        } else {
            throw new IllegalArgumentException("Unsupported HTTP method: " + method);
        }
        return hTTP_METHOD;
    }

    @NotNull
    public static final Map<String, Object> extractDataJsonFromJwt(@NotNull String jwtToken, @NotNull JwtHandler.JwtPart part) {
        Intrinsics.checkNotNullParameter((Object)jwtToken, (String)"jwtToken");
        Intrinsics.checkNotNullParameter((Object)((Object)part), (String)"part");
        String[] stringArray = new String[]{"."};
        List components = StringsKt.split$default((CharSequence)jwtToken, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String payload = (String)components.get(part.getNumber());
        byte[] decodedString = Decoder.INSTANCE.decodeBase64Data(payload);
        return UtilsKt.convertJsonToMap(new String(decodedString, Charsets.UTF_8));
    }

    @Nullable
    public static final String getStringValue(@NotNull Map<String, ? extends Object> params, @NotNull String key) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = params.get(key);
        return object != null ? object.toString() : null;
    }
}

