/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP.jwt;

import io.mosip.openID4VP.common.Decoder;
import io.mosip.openID4VP.common.Logger;
import io.mosip.openID4VP.common.UtilsKt;
import io.mosip.openID4VP.jwt.JwtHandlerKt;
import io.mosip.openID4VP.jwt.keyResolver.PublicKeyResolver;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.util.encoders.Base64;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/mosip/openID4VP/jwt/JwtHandler;", "", "jwt", "", "publicKeyResolver", "Lio/mosip/openID4VP/jwt/keyResolver/PublicKeyResolver;", "<init>", "(Ljava/lang/String;Lio/mosip/openID4VP/jwt/keyResolver/PublicKeyResolver;)V", "verify", "", "JwtPart", "inji-openid4vp-0.2.0_release"})
public final class JwtHandler {
    @NotNull
    private final String jwt;
    @NotNull
    private final PublicKeyResolver publicKeyResolver;

    public JwtHandler(@NotNull String jwt, @NotNull PublicKeyResolver publicKeyResolver) {
        Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
        Intrinsics.checkNotNullParameter((Object)publicKeyResolver, (String)"publicKeyResolver");
        this.jwt = jwt;
        this.publicKeyResolver = publicKeyResolver;
    }

    public final void verify() {
        Object object;
        boolean verificationResult = false;
        try {
            object = new String[]{"."};
            List parts = StringsKt.split$default((CharSequence)this.jwt, (String[])object, (boolean)false, (int)0, (int)6, null);
            String header = (String)parts.get(JwtPart.HEADER.getNumber());
            String payload = (String)parts.get(JwtPart.PAYLOAD.getNumber());
            byte[] signature = Decoder.INSTANCE.decodeBase64Data((String)parts.get(JwtPart.SIGNATURE.getNumber()));
            String publicKey = this.publicKeyResolver.resolveKey(UtilsKt.extractDataJsonFromJwt(this.jwt, JwtPart.HEADER));
            byte[] publicKeyBytes = Base64.decode((String)publicKey);
            Ed25519PublicKeyParameters publicKeyParams = new Ed25519PublicKeyParameters(publicKeyBytes, 0);
            Ed25519Signer signer = new Ed25519Signer();
            signer.init(false, (CipherParameters)publicKeyParams);
            String string = header + "." + payload;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] messageBytes = byArray;
            signer.update(messageBytes, 0, messageBytes.length);
            verificationResult = signer.verifySignature(signature);
        }
        catch (Exception ex) {
            throw Logger.handleException$default(Logger.INSTANCE, "VerificationFailure", null, null, JwtHandlerKt.access$getClassName$p(), null, 22, null);
        }
        if (!verificationResult) {
            Logger logger = Logger.INSTANCE;
            object = JwtHandlerKt.access$getClassName$p();
            throw Logger.handleException$default(logger, "InvalidSignature", "JWT signature verification failed", null, (String)object, null, 20, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lio/mosip/openID4VP/jwt/JwtHandler$JwtPart;", "", "number", "", "<init>", "(Ljava/lang/String;II)V", "getNumber", "()I", "HEADER", "PAYLOAD", "SIGNATURE", "inji-openid4vp-0.2.0_release"})
    public static final class JwtPart
    extends Enum<JwtPart> {
        private final int number;
        public static final /* enum */ JwtPart HEADER = new JwtPart(0);
        public static final /* enum */ JwtPart PAYLOAD = new JwtPart(1);
        public static final /* enum */ JwtPart SIGNATURE = new JwtPart(2);
        private static final /* synthetic */ JwtPart[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private JwtPart(int number) {
            this.number = number;
        }

        public final int getNumber() {
            return this.number;
        }

        public static JwtPart[] values() {
            return (JwtPart[])$VALUES.clone();
        }

        public static JwtPart valueOf(String value) {
            return Enum.valueOf(JwtPart.class, value);
        }

        @NotNull
        public static EnumEntries<JwtPart> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = jwtPartArray = new JwtPart[]{JwtPart.HEADER, JwtPart.PAYLOAD, JwtPart.SIGNATURE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

