/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP.authorizationRequest;

import io.mosip.openID4VP.authorizationRequest.AuthorizationRequest;
import io.mosip.openID4VP.authorizationRequest.AuthorizationRequestFieldConstants;
import io.mosip.openID4VP.authorizationRequest.Verifier;
import io.mosip.openID4VP.authorizationRequest.WalletMetadata;
import io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler.ClientIdSchemeBasedAuthorizationRequestHandler;
import io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler.types.DidSchemeAuthorizationRequestHandler;
import io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler.types.PreRegisteredSchemeAuthorizationRequestHandler;
import io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler.types.RedirectUriSchemeAuthorizationRequestHandler;
import io.mosip.openID4VP.common.Logger;
import io.mosip.openID4VP.common.UtilsKt;
import io.mosip.openID4VP.constants.ClientIdScheme;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0004\u001aN\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0012\u001a\u00020\u0001\u001a.\u0010\u0013\u001a\u00020\u000e2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u0015\u001a\u001a\u0010\u0017\u001a\u00020\u00012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u0015\u001a\u001a\u0010\u0018\u001a\u00020\u00012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u0015\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"className", "", "getAuthorizationRequestHandler", "Lio/mosip/openID4VP/authorizationRequest/authorizationRequestHandler/ClientIdSchemeBasedAuthorizationRequestHandler;", "authorizationRequestParameters", "", "", "trustedVerifiers", "", "Lio/mosip/openID4VP/authorizationRequest/Verifier;", "walletMetadata", "Lio/mosip/openID4VP/authorizationRequest/WalletMetadata;", "setResponseUri", "Lkotlin/Function1;", "", "shouldValidateClient", "", "extractQueryParameters", "query", "validateAuthorizationRequestObjectAndParameters", "params", "", "authorizationRequestObject", "extractClientIdScheme", "extractClientIdentifier", "inji-openid4vp-0.3.0_release"})
@SourceDebugExtension(value={"SMAP\nAuthorizationRequestUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthorizationRequestUtils.kt\nio/mosip/openID4VP/authorizationRequest/AuthorizationRequestUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n1557#2:122\n1628#2,3:123\n1246#2,4:126\n*S KotlinDebug\n*F\n+ 1 AuthorizationRequestUtils.kt\nio/mosip/openID4VP/authorizationRequest/AuthorizationRequestUtilsKt\n*L\n55#1:122\n55#1:123,3\n56#1:126,4\n*E\n"})
public final class AuthorizationRequestUtilsKt {
    @NotNull
    private static final String className;

    @NotNull
    public static final ClientIdSchemeBasedAuthorizationRequestHandler getAuthorizationRequestHandler(@NotNull Map<String, Object> authorizationRequestParameters, @NotNull List<Verifier> trustedVerifiers, @Nullable WalletMetadata walletMetadata, @NotNull Function1<? super String, Unit> setResponseUri, boolean shouldValidateClient) {
        ClientIdSchemeBasedAuthorizationRequestHandler clientIdSchemeBasedAuthorizationRequestHandler;
        String clientIdScheme;
        Intrinsics.checkNotNullParameter(authorizationRequestParameters, (String)"authorizationRequestParameters");
        Intrinsics.checkNotNullParameter(trustedVerifiers, (String)"trustedVerifiers");
        Intrinsics.checkNotNullParameter(setResponseUri, (String)"setResponseUri");
        String clientId = UtilsKt.getStringValue(authorizationRequestParameters, AuthorizationRequestFieldConstants.CLIENT_ID.getValue());
        UtilsKt.validate(AuthorizationRequestFieldConstants.CLIENT_ID.getValue(), clientId, className);
        String string = clientIdScheme = AuthorizationRequestUtilsKt.extractClientIdScheme(authorizationRequestParameters);
        if (Intrinsics.areEqual((Object)string, (Object)ClientIdScheme.PRE_REGISTERED.getValue())) {
            clientIdSchemeBasedAuthorizationRequestHandler = new PreRegisteredSchemeAuthorizationRequestHandler(trustedVerifiers, authorizationRequestParameters, walletMetadata, shouldValidateClient, setResponseUri);
        } else if (Intrinsics.areEqual((Object)string, (Object)ClientIdScheme.REDIRECT_URI.getValue())) {
            clientIdSchemeBasedAuthorizationRequestHandler = new RedirectUriSchemeAuthorizationRequestHandler(authorizationRequestParameters, walletMetadata, setResponseUri);
        } else if (Intrinsics.areEqual((Object)string, (Object)ClientIdScheme.DID.getValue())) {
            clientIdSchemeBasedAuthorizationRequestHandler = new DidSchemeAuthorizationRequestHandler(authorizationRequestParameters, walletMetadata, setResponseUri);
        } else {
            Logger logger = Logger.INSTANCE;
            String string2 = className;
            throw Logger.handleException$default(logger, "InvalidData", "Given client_id_scheme is not supported", null, string2, null, 20, null);
        }
        return clientIdSchemeBasedAuthorizationRequestHandler;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, Object> extractQueryParameters(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        try {
            void var3_5;
            void $this$associateByTo$iv;
            Object object;
            void $this$mapTo$iv$iv;
            String urlDecodedQueryString = URLDecoder.decode(query, StandardCharsets.UTF_8.toString());
            Intrinsics.checkNotNull((Object)urlDecodedQueryString);
            String[] stringArray = new String[]{"&"};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)urlDecodedQueryString, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                String[] stringArray2 = new String[]{"="};
                object.add(StringsKt.split$default((CharSequence)((CharSequence)it), (String[])stringArray2, (boolean)false, (int)0, (int)6, null));
            }
            $this$map$iv = (List)destination$iv$iv;
            Map destination$iv = new LinkedHashMap();
            boolean $i$f$associateByTo = false;
            for (Object element$iv : $this$associateByTo$iv) {
                List list = (List)element$iv;
                object = destination$iv;
                boolean bl = false;
                List it = (List)element$iv;
                String string = (String)it.get(0);
                boolean bl2 = false;
                String string2 = (String)it.get(1);
                object.put(string, string2);
            }
            return var3_5;
        }
        catch (Exception exception) {
            throw Logger.handleException$default(Logger.INSTANCE, "InvalidQueryParams", "Exception occurred when extracting the query params from Authorization Request : " + exception.getMessage(), null, className, null, 20, null);
        }
    }

    public static final void validateAuthorizationRequestObjectAndParameters(@NotNull Map<String, ? extends Object> params, @NotNull Map<String, ? extends Object> authorizationRequestObject) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Intrinsics.checkNotNullParameter(authorizationRequestObject, (String)"authorizationRequestObject");
        if (!Intrinsics.areEqual((Object)params.get(AuthorizationRequestFieldConstants.CLIENT_ID.getValue()), (Object)authorizationRequestObject.get(AuthorizationRequestFieldConstants.CLIENT_ID.getValue()))) {
            throw Logger.handleException$default(Logger.INSTANCE, "InvalidData", "Client Id mismatch in Authorization Request parameter and the Request Object", null, className, null, 20, null);
        }
        if (params.containsKey(AuthorizationRequestFieldConstants.CLIENT_ID_SCHEME.getValue()) && !Intrinsics.areEqual((Object)params.get(AuthorizationRequestFieldConstants.CLIENT_ID_SCHEME.getValue()), (Object)authorizationRequestObject.get(AuthorizationRequestFieldConstants.CLIENT_ID_SCHEME.getValue()))) {
            throw Logger.handleException$default(Logger.INSTANCE, "InvalidData", "Client Id Scheme mismatch in Authorization Request parameter and the Request Object", null, className, null, 20, null);
        }
    }

    @NotNull
    public static final String extractClientIdScheme(@NotNull Map<String, ? extends Object> authorizationRequestParameters) {
        Intrinsics.checkNotNullParameter(authorizationRequestParameters, (String)"authorizationRequestParameters");
        if (authorizationRequestParameters.containsKey(AuthorizationRequestFieldConstants.CLIENT_ID_SCHEME.getValue())) {
            String string = UtilsKt.getStringValue(authorizationRequestParameters, AuthorizationRequestFieldConstants.CLIENT_ID_SCHEME.getValue());
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
        String string = UtilsKt.getStringValue(authorizationRequestParameters, AuthorizationRequestFieldConstants.CLIENT_ID.getValue());
        Intrinsics.checkNotNull((Object)string);
        String clientId = string;
        String[] stringArray = new String[]{":"};
        List components = StringsKt.split$default((CharSequence)clientId, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
        return components.size() > 1 ? (String)components.get(0) : ClientIdScheme.PRE_REGISTERED.getValue();
    }

    @NotNull
    public static final String extractClientIdentifier(@NotNull Map<String, ? extends Object> authorizationRequestParameters) {
        String clientIdScheme;
        Intrinsics.checkNotNullParameter(authorizationRequestParameters, (String)"authorizationRequestParameters");
        if (authorizationRequestParameters.containsKey(AuthorizationRequestFieldConstants.CLIENT_ID_SCHEME.getValue())) {
            String string = UtilsKt.getStringValue(authorizationRequestParameters, AuthorizationRequestFieldConstants.CLIENT_ID.getValue());
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
        String string = UtilsKt.getStringValue(authorizationRequestParameters, AuthorizationRequestFieldConstants.CLIENT_ID.getValue());
        Intrinsics.checkNotNull((Object)string);
        String clientId = string;
        String[] stringArray = new String[]{":"};
        List components = StringsKt.split$default((CharSequence)clientId, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
        return components.size() > 1 ? (Intrinsics.areEqual((Object)(clientIdScheme = (String)components.get(0)), (Object)ClientIdScheme.DID.getValue()) ? clientId : (String)components.get(1)) : clientId;
    }

    static {
        String string = Reflection.getOrCreateKotlinClass(AuthorizationRequest.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        className = string;
    }
}

