/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import io.mosip.openID4VP.authorizationRequest.AuthorizationRequest;
import io.mosip.openID4VP.authorizationRequest.AuthorizationRequestFieldConstants;
import io.mosip.openID4VP.authorizationRequest.AuthorizationRequestUtilsKt;
import io.mosip.openID4VP.authorizationRequest.WalletMetadata;
import io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler.ClientIdSchemeBasedAuthorizationRequestHandlerKt;
import io.mosip.openID4VP.authorizationRequest.clientMetadata.ClientMetadata;
import io.mosip.openID4VP.authorizationRequest.clientMetadata.ClientMetadataUtilKt;
import io.mosip.openID4VP.authorizationRequest.presentationDefinition.PresentationDefinition;
import io.mosip.openID4VP.authorizationRequest.presentationDefinition.PresentationDefinitionUtilKt;
import io.mosip.openID4VP.common.Logger;
import io.mosip.openID4VP.common.UtilsKt;
import io.mosip.openID4VP.constants.HttpMethod;
import io.mosip.openID4VP.networkManager.NetworkManagerClient;
import io.mosip.openID4VP.responseModeHandler.ResponseModeBasedHandlerFactory;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B9\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0018\u001a\u00020\tH\u0016J\u0006\u0010\u0019\u001a\u00020\tJ\u001c\u0010\u001a\u001a\u00020\t2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u001cH&J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0014\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001cH&J\u0006\u0010\u001f\u001a\u00020\tJ\b\u0010 \u001a\u00020\tH\u0016J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0006\u0010\"\u001a\u00020#R&\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Lio/mosip/openID4VP/authorizationRequest/authorizationRequestHandler/ClientIdSchemeBasedAuthorizationRequestHandler;", "", "authorizationRequestParameters", "", "", "walletMetadata", "Lio/mosip/openID4VP/authorizationRequest/WalletMetadata;", "setResponseUri", "Lkotlin/Function1;", "", "<init>", "(Ljava/util/Map;Lio/mosip/openID4VP/authorizationRequest/WalletMetadata;Lkotlin/jvm/functions/Function1;)V", "getAuthorizationRequestParameters", "()Ljava/util/Map;", "setAuthorizationRequestParameters", "(Ljava/util/Map;)V", "getWalletMetadata", "()Lio/mosip/openID4VP/authorizationRequest/WalletMetadata;", "shouldValidateWithWalletMetadata", "", "getShouldValidateWithWalletMetadata", "()Z", "setShouldValidateWithWalletMetadata", "(Z)V", "validateClientId", "fetchAuthorizationRequest", "validateRequestUriResponse", "requestUriResponse", "", "process", "getHeadersForAuthorizationRequestUri", "setResponseUrl", "validateAndParseRequestFields", "isClientIdSchemeSupported", "createAuthorizationRequest", "Lio/mosip/openID4VP/authorizationRequest/AuthorizationRequest;", "inji-openid4vp-0.3.0_release"})
@SourceDebugExtension(value={"SMAP\nClientIdSchemeBasedAuthorizationRequestHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientIdSchemeBasedAuthorizationRequestHandler.kt\nio/mosip/openID4VP/authorizationRequest/authorizationRequestHandler/ClientIdSchemeBasedAuthorizationRequestHandler\n+ 2 Utils.kt\nio/mosip/openID4VP/common/UtilsKt\n*L\n1#1,131:1\n66#2,9:132\n*S KotlinDebug\n*F\n+ 1 ClientIdSchemeBasedAuthorizationRequestHandler.kt\nio/mosip/openID4VP/authorizationRequest/authorizationRequestHandler/ClientIdSchemeBasedAuthorizationRequestHandler\n*L\n57#1:132,9\n*E\n"})
public abstract class ClientIdSchemeBasedAuthorizationRequestHandler {
    @NotNull
    private Map<String, Object> authorizationRequestParameters;
    @Nullable
    private final WalletMetadata walletMetadata;
    @NotNull
    private final Function1<String, Unit> setResponseUri;
    private boolean shouldValidateWithWalletMetadata;

    public ClientIdSchemeBasedAuthorizationRequestHandler(@NotNull Map<String, Object> authorizationRequestParameters, @Nullable WalletMetadata walletMetadata, @NotNull Function1<? super String, Unit> setResponseUri) {
        Intrinsics.checkNotNullParameter(authorizationRequestParameters, (String)"authorizationRequestParameters");
        Intrinsics.checkNotNullParameter(setResponseUri, (String)"setResponseUri");
        this.authorizationRequestParameters = authorizationRequestParameters;
        this.walletMetadata = walletMetadata;
        this.setResponseUri = setResponseUri;
    }

    @NotNull
    public final Map<String, Object> getAuthorizationRequestParameters() {
        return this.authorizationRequestParameters;
    }

    public final void setAuthorizationRequestParameters(@NotNull Map<String, Object> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.authorizationRequestParameters = map;
    }

    @Nullable
    public final WalletMetadata getWalletMetadata() {
        return this.walletMetadata;
    }

    protected final boolean getShouldValidateWithWalletMetadata() {
        return this.shouldValidateWithWalletMetadata;
    }

    protected final void setShouldValidateWithWalletMetadata(boolean bl) {
        this.shouldValidateWithWalletMetadata = bl;
    }

    public void validateClientId() {
    }

    /*
     * WARNING - void declaration
     */
    public final void fetchAuthorizationRequest() {
        Map<String, Object> requestUriResponse = null;
        requestUriResponse = MapsKt.emptyMap();
        String string = UtilsKt.getStringValue(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.REQUEST_URI.getValue());
        if (string != null) {
            String requestUri = string;
            boolean bl = false;
            if (!UtilsKt.isValidUrl(requestUri)) {
                Logger logger = Logger.INSTANCE;
                String string2 = ClientIdSchemeBasedAuthorizationRequestHandlerKt.access$getClassName$p();
                String string3 = AuthorizationRequestFieldConstants.REQUEST_URI.getValue() + " data is not valid";
                throw Logger.handleException$default(logger, "InvalidData", string3, null, string2, null, 20, null);
            }
            String string4 = UtilsKt.getStringValue(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.REQUEST_URI_METHOD.getValue());
            if (string4 == null) {
                string4 = "get";
            }
            String requestUriMethod = string4;
            HttpMethod httpMethod = UtilsKt.determineHttpMethod(requestUriMethod);
            Map body = null;
            Map<String, String> headers = null;
            if (httpMethod == HttpMethod.POST) {
                WalletMetadata walletMetadata = this.walletMetadata;
                if (walletMetadata != null) {
                    String string5;
                    WalletMetadata walletMetadata2 = walletMetadata;
                    boolean bl2 = false;
                    this.isClientIdSchemeSupported(walletMetadata2);
                    WalletMetadata processedWalletMetadata = this.process(walletMetadata2);
                    String string6 = "wallet_metadata";
                    String string7 = ClientIdSchemeBasedAuthorizationRequestHandlerKt.access$getClassName$p();
                    String string8 = "wallet_metadata";
                    boolean $i$f$encodeToJsonString = false;
                    try {
                        ObjectMapper objectMapper$iv = ExtensionsKt.jacksonObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
                        String string9 = objectMapper$iv.writeValueAsString((Object)processedWalletMetadata);
                        string5 = string9;
                        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"writeValueAsString(...)");
                    }
                    catch (Exception exception$iv) {
                        void className$iv;
                        void fieldName$iv;
                        throw Logger.handleException$default(Logger.INSTANCE, "JsonEncodingFailed", exception$iv.getMessage(), CollectionsKt.listOf((Object)fieldName$iv), (String)className$iv, null, 16, null);
                    }
                    body = MapsKt.mapOf((Pair)TuplesKt.to((Object)string8, (Object)string5));
                    headers = this.getHeadersForAuthorizationRequestUri();
                    this.shouldValidateWithWalletMetadata = true;
                }
            }
            requestUriResponse = NetworkManagerClient.Companion.sendHTTPRequest(requestUri, httpMethod, body, headers);
        }
        this.validateRequestUriResponse((Map<String, ? extends Object>)requestUriResponse);
    }

    public abstract void validateRequestUriResponse(@NotNull Map<String, ? extends Object> var1);

    @NotNull
    public abstract WalletMetadata process(@NotNull WalletMetadata var1);

    @NotNull
    public abstract Map<String, String> getHeadersForAuthorizationRequestUri();

    public final void setResponseUrl() {
        String string = UtilsKt.getStringValue(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.RESPONSE_MODE.getValue());
        if (string == null) {
            Logger logger = Logger.INSTANCE;
            String string2 = ClientIdSchemeBasedAuthorizationRequestHandlerKt.access$getClassName$p();
            List list = CollectionsKt.listOf((Object)AuthorizationRequestFieldConstants.RESPONSE_MODE.getValue());
            throw Logger.handleException$default(logger, "MissingInput", null, list, string2, null, 18, null);
        }
        String responseMode = string;
        ResponseModeBasedHandlerFactory.INSTANCE.get(responseMode).setResponseUrl(this.authorizationRequestParameters, this.setResponseUri);
    }

    /*
     * Unable to fully structure code
     */
    public void validateAndParseRequestFields() {
        responseType = UtilsKt.getStringValue(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.RESPONSE_TYPE.getValue());
        UtilsKt.validate(AuthorizationRequestFieldConstants.RESPONSE_TYPE.getValue(), responseType, ClientIdSchemeBasedAuthorizationRequestHandlerKt.access$getClassName$p());
        nonce = UtilsKt.getStringValue(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.NONCE.getValue());
        UtilsKt.validate(AuthorizationRequestFieldConstants.NONCE.getValue(), nonce, ClientIdSchemeBasedAuthorizationRequestHandlerKt.access$getClassName$p());
        v0 = state = UtilsKt.getStringValue(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.STATE.getValue());
        if (v0 != null) {
            it = v0;
            $i$a$-let-ClientIdSchemeBasedAuthorizationRequestHandler$validateAndParseRequestFields$1 = false;
            UtilsKt.validate(AuthorizationRequestFieldConstants.STATE.getValue(), state, ClientIdSchemeBasedAuthorizationRequestHandlerKt.access$getClassName$p());
        }
        ClientMetadataUtilKt.parseAndValidateClientMetadata(this.authorizationRequestParameters, this.shouldValidateWithWalletMetadata, this.walletMetadata);
        if (!this.shouldValidateWithWalletMetadata) ** GOTO lbl-1000
        v1 = this.walletMetadata;
        if (v1 != null ? v1.getPresentationDefinitionURISupported() : true) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        presentationDefinitionUriSupported = v2;
        PresentationDefinitionUtilKt.parseAndValidatePresentationDefinition(this.authorizationRequestParameters, presentationDefinitionUriSupported);
    }

    private final void isClientIdSchemeSupported(WalletMetadata walletMetadata) {
        String clientIdScheme = AuthorizationRequestUtilsKt.extractClientIdScheme(this.authorizationRequestParameters);
        if (!walletMetadata.getClientIdSchemesSupported().contains(clientIdScheme)) {
            Logger logger = Logger.INSTANCE;
            String string = ClientIdSchemeBasedAuthorizationRequestHandlerKt.access$getClassName$p();
            throw Logger.handleException$default(logger, "InvalidData", "client_id_scheme is not support by wallet", null, string, null, 20, null);
        }
    }

    @NotNull
    public final AuthorizationRequest createAuthorizationRequest() {
        String string = UtilsKt.getStringValue(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.CLIENT_ID.getValue());
        Intrinsics.checkNotNull((Object)string);
        String string2 = UtilsKt.getStringValue(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.RESPONSE_TYPE.getValue());
        Intrinsics.checkNotNull((Object)string2);
        String string3 = UtilsKt.getStringValue(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.RESPONSE_MODE.getValue());
        Object object = this.authorizationRequestParameters.get(AuthorizationRequestFieldConstants.PRESENTATION_DEFINITION.getValue());
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.mosip.openID4VP.authorizationRequest.presentationDefinition.PresentationDefinition");
        PresentationDefinition presentationDefinition = (PresentationDefinition)object;
        String string4 = UtilsKt.getStringValue(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.RESPONSE_URI.getValue());
        String string5 = UtilsKt.getStringValue(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.REDIRECT_URI.getValue());
        String string6 = UtilsKt.getStringValue(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.NONCE.getValue());
        Intrinsics.checkNotNull((Object)string6);
        Object object2 = this.authorizationRequestParameters.get(AuthorizationRequestFieldConstants.CLIENT_METADATA.getValue());
        return new AuthorizationRequest(string, string2, string3, presentationDefinition, string4, string5, string6, UtilsKt.getStringValue(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.STATE.getValue()), object2 instanceof ClientMetadata ? (ClientMetadata)object2 : null, UtilsKt.getStringValue(this.authorizationRequestParameters, AuthorizationRequestFieldConstants.CLIENT_ID_SCHEME.getValue()));
    }
}

