/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler.types;

import io.mosip.openID4VP.authorizationRequest.AuthorizationRequestFieldConstants;
import io.mosip.openID4VP.authorizationRequest.AuthorizationRequestUtilsKt;
import io.mosip.openID4VP.authorizationRequest.WalletMetadata;
import io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler.ClientIdSchemeBasedAuthorizationRequestHandler;
import io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler.types.DidSchemeAuthorizationRequestHandlerKt;
import io.mosip.openID4VP.common.Logger;
import io.mosip.openID4VP.common.UtilsKt;
import io.mosip.openID4VP.constants.ContentType;
import io.mosip.openID4VP.jwt.jws.JWSHandler;
import io.mosip.openID4VP.jwt.keyResolver.types.DidPublicKeyResolver;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B9\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001c\u0010\r\u001a\u00020\n2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010\u0016\u001a\u00020\n2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0002\u00a8\u0006\u0017"}, d2={"Lio/mosip/openID4VP/authorizationRequest/authorizationRequestHandler/types/DidSchemeAuthorizationRequestHandler;", "Lio/mosip/openID4VP/authorizationRequest/authorizationRequestHandler/ClientIdSchemeBasedAuthorizationRequestHandler;", "authorizationRequestParameters", "", "", "", "walletMetadata", "Lio/mosip/openID4VP/authorizationRequest/WalletMetadata;", "setResponseUri", "Lkotlin/Function1;", "", "<init>", "(Ljava/util/Map;Lio/mosip/openID4VP/authorizationRequest/WalletMetadata;Lkotlin/jvm/functions/Function1;)V", "validateRequestUriResponse", "requestUriResponse", "", "process", "getHeadersForAuthorizationRequestUri", "isValidContentType", "", "headers", "Lokhttp3/Headers;", "validateAuthorizationRequestSigningAlgorithm", "inji-openid4vp-0.3.0_release"})
public final class DidSchemeAuthorizationRequestHandler
extends ClientIdSchemeBasedAuthorizationRequestHandler {
    public DidSchemeAuthorizationRequestHandler(@NotNull Map<String, Object> authorizationRequestParameters, @Nullable WalletMetadata walletMetadata, @NotNull Function1<? super String, Unit> setResponseUri) {
        Intrinsics.checkNotNullParameter(authorizationRequestParameters, (String)"authorizationRequestParameters");
        Intrinsics.checkNotNullParameter(setResponseUri, (String)"setResponseUri");
        super(authorizationRequestParameters, walletMetadata, setResponseUri);
    }

    @Override
    public void validateRequestUriResponse(@NotNull Map<String, ? extends Object> requestUriResponse) {
        String responseBody;
        Intrinsics.checkNotNullParameter(requestUriResponse, (String)"requestUriResponse");
        if (!requestUriResponse.isEmpty()) {
            Object object = requestUriResponse.get("header");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type okhttp3.Headers");
            Headers headers = (Headers)object;
            responseBody = String.valueOf(requestUriResponse.get("body"));
            if (!this.isValidContentType(headers) || !UtilsKt.isJWS(responseBody)) {
                Logger logger = Logger.INSTANCE;
                String string = DidSchemeAuthorizationRequestHandlerKt.access$getClassName$p();
                throw Logger.handleException$default(logger, "InvalidData", "Authorization Request must be signed for given client_id_scheme", null, string, null, 20, null);
            }
        } else {
            Logger logger = Logger.INSTANCE;
            String string = DidSchemeAuthorizationRequestHandlerKt.access$getClassName$p();
            List list = CollectionsKt.listOf((Object)AuthorizationRequestFieldConstants.REQUEST_URI.getValue());
            throw Logger.handleException$default(logger, "MissingInput", null, list, string, null, 18, null);
        }
        String string = UtilsKt.getStringValue(this.getAuthorizationRequestParameters(), AuthorizationRequestFieldConstants.CLIENT_ID.getValue());
        Intrinsics.checkNotNull((Object)string);
        String didUrl = string;
        JWSHandler jwsHandler = new JWSHandler(responseBody, new DidPublicKeyResolver(didUrl));
        Map<String, Object> header = jwsHandler.extractDataJsonFromJws(JWSHandler.JwsPart.HEADER);
        this.validateAuthorizationRequestSigningAlgorithm(header);
        jwsHandler.verify();
        Map<String, Object> authorizationRequestObject = jwsHandler.extractDataJsonFromJws(JWSHandler.JwsPart.PAYLOAD);
        AuthorizationRequestUtilsKt.validateAuthorizationRequestObjectAndParameters(this.getAuthorizationRequestParameters(), authorizationRequestObject);
        this.setAuthorizationRequestParameters(authorizationRequestObject);
    }

    @Override
    @NotNull
    public WalletMetadata process(@NotNull WalletMetadata walletMetadata) {
        Intrinsics.checkNotNullParameter((Object)walletMetadata, (String)"walletMetadata");
        Object object = walletMetadata.getRequestObjectSigningAlgValuesSupported();
        if (object == null || object.isEmpty()) {
            object = Logger.INSTANCE;
            String string = DidSchemeAuthorizationRequestHandlerKt.access$getClassName$p();
            throw Logger.handleException$default((Logger)object, "InvalidData", "request_object_signing_alg_values_supported is not present in wallet metadata", null, string, null, 20, null);
        }
        return walletMetadata;
    }

    @Override
    @NotNull
    public Map<String, String> getHeadersForAuthorizationRequestUri() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"content-type", (Object)ContentType.APPLICATION_FORM_URL_ENCODED.getValue()), TuplesKt.to((Object)"accept", (Object)ContentType.APPLICATION_JWT.getValue())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final boolean isValidContentType(Headers headers) {
        String string = headers.get("content-type");
        return string != null ? StringsKt.contains((CharSequence)string, (CharSequence)ContentType.APPLICATION_JWT.getValue(), (boolean)true) : false;
    }

    private final void validateAuthorizationRequestSigningAlgorithm(Map<String, Object> headers) {
        if (this.getShouldValidateWithWalletMetadata()) {
            Object alg = headers.get("alg");
            WalletMetadata walletMetadata = this.getWalletMetadata();
            if (walletMetadata != null) {
                WalletMetadata it = walletMetadata;
                boolean bl = false;
                List<String> list = it.getRequestObjectSigningAlgValuesSupported();
                Intrinsics.checkNotNull(list);
                if (!CollectionsKt.contains((Iterable)list, (Object)alg)) {
                    Logger logger = Logger.INSTANCE;
                    String string = DidSchemeAuthorizationRequestHandlerKt.access$getClassName$p();
                    throw Logger.handleException$default(logger, "InvalidData", "request_object_signing_alg is not support by wallet", null, string, null, 20, null);
                }
            }
        }
    }
}

