/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler.types;

import io.mosip.openID4VP.authorizationRequest.AuthorizationRequestFieldConstants;
import io.mosip.openID4VP.authorizationRequest.AuthorizationRequestUtilsKt;
import io.mosip.openID4VP.authorizationRequest.Verifier;
import io.mosip.openID4VP.authorizationRequest.WalletMetadata;
import io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler.ClientIdSchemeBasedAuthorizationRequestHandler;
import io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler.types.PreRegisteredSchemeAuthorizationRequestHandlerKt;
import io.mosip.openID4VP.common.Logger;
import io.mosip.openID4VP.common.UtilsKt;
import io.mosip.openID4VP.constants.ContentType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BO\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\u001c\u0010\u0013\u001a\u00020\u000f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0015H\u0016J\b\u0010\u0018\u001a\u00020\u000fH\u0016J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/mosip/openID4VP/authorizationRequest/authorizationRequestHandler/types/PreRegisteredSchemeAuthorizationRequestHandler;", "Lio/mosip/openID4VP/authorizationRequest/authorizationRequestHandler/ClientIdSchemeBasedAuthorizationRequestHandler;", "trustedVerifiers", "", "Lio/mosip/openID4VP/authorizationRequest/Verifier;", "authorizationRequestParameters", "", "", "", "walletMetadata", "Lio/mosip/openID4VP/authorizationRequest/WalletMetadata;", "shouldValidateClient", "", "setResponseUri", "Lkotlin/Function1;", "", "<init>", "(Ljava/util/List;Ljava/util/Map;Lio/mosip/openID4VP/authorizationRequest/WalletMetadata;ZLkotlin/jvm/functions/Function1;)V", "validateClientId", "validateRequestUriResponse", "requestUriResponse", "", "process", "getHeadersForAuthorizationRequestUri", "validateAndParseRequestFields", "isValidContentType", "headers", "Lokhttp3/Headers;", "inji-openid4vp-0.3.0_release"})
@SourceDebugExtension(value={"SMAP\nPreRegisteredSchemeAuthorizationRequestHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreRegisteredSchemeAuthorizationRequestHandler.kt\nio/mosip/openID4VP/authorizationRequest/authorizationRequestHandler/types/PreRegisteredSchemeAuthorizationRequestHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n2632#2,3:99\n2632#2,3:102\n*S KotlinDebug\n*F\n+ 1 PreRegisteredSchemeAuthorizationRequestHandler.kt\nio/mosip/openID4VP/authorizationRequest/authorizationRequestHandler/types/PreRegisteredSchemeAuthorizationRequestHandler\n*L\n29#1:99,3\n86#1:102,3\n*E\n"})
public final class PreRegisteredSchemeAuthorizationRequestHandler
extends ClientIdSchemeBasedAuthorizationRequestHandler {
    @NotNull
    private final List<Verifier> trustedVerifiers;
    private final boolean shouldValidateClient;

    public PreRegisteredSchemeAuthorizationRequestHandler(@NotNull List<Verifier> trustedVerifiers, @NotNull Map<String, Object> authorizationRequestParameters, @Nullable WalletMetadata walletMetadata, boolean shouldValidateClient, @NotNull Function1<? super String, Unit> setResponseUri) {
        Intrinsics.checkNotNullParameter(trustedVerifiers, (String)"trustedVerifiers");
        Intrinsics.checkNotNullParameter(authorizationRequestParameters, (String)"authorizationRequestParameters");
        Intrinsics.checkNotNullParameter(setResponseUri, (String)"setResponseUri");
        super(authorizationRequestParameters, walletMetadata, setResponseUri);
        this.trustedVerifiers = trustedVerifiers;
        this.shouldValidateClient = shouldValidateClient;
    }

    @Override
    public void validateClientId() {
        boolean bl;
        block5: {
            if (!this.shouldValidateClient) {
                return;
            }
            String string = UtilsKt.getStringValue(this.getAuthorizationRequestParameters(), AuthorizationRequestFieldConstants.CLIENT_ID.getValue());
            Intrinsics.checkNotNull((Object)string);
            String clientId = string;
            Iterable $this$none$iv = this.trustedVerifiers;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Verifier it = (Verifier)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getClientId(), (Object)clientId)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            Logger logger = Logger.INSTANCE;
            String string = PreRegisteredSchemeAuthorizationRequestHandlerKt.access$getClassName$p();
            throw Logger.handleException$default(logger, "InvalidVerifier", "Verifier is not trusted by the wallet", null, string, null, 20, null);
        }
    }

    @Override
    public void validateRequestUriResponse(@NotNull Map<String, ? extends Object> requestUriResponse) {
        Map<String, Object> map;
        Intrinsics.checkNotNullParameter(requestUriResponse, (String)"requestUriResponse");
        if (requestUriResponse.isEmpty()) {
            map = this.getAuthorizationRequestParameters();
        } else {
            Object object = requestUriResponse.get("header");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type okhttp3.Headers");
            Headers headers = (Headers)object;
            String responseBody = String.valueOf(requestUriResponse.get("body"));
            if (this.isValidContentType(headers)) {
                Map<String, Object> authorizationRequestObject = UtilsKt.convertJsonToMap(responseBody);
                AuthorizationRequestUtilsKt.validateAuthorizationRequestObjectAndParameters(this.getAuthorizationRequestParameters(), authorizationRequestObject);
                map = authorizationRequestObject;
            } else {
                Logger logger = Logger.INSTANCE;
                String string = PreRegisteredSchemeAuthorizationRequestHandlerKt.access$getClassName$p();
                throw Logger.handleException$default(logger, "InvalidData", "Authorization Request must not be signed for given client_id_scheme", null, string, null, 20, null);
            }
        }
        this.setAuthorizationRequestParameters(map);
    }

    @Override
    @NotNull
    public WalletMetadata process(@NotNull WalletMetadata walletMetadata) {
        Intrinsics.checkNotNullParameter((Object)walletMetadata, (String)"walletMetadata");
        WalletMetadata updatedWalletMetadata = WalletMetadata.copy$default(walletMetadata, false, null, null, null, null, null, 63, null);
        updatedWalletMetadata.setRequestObjectSigningAlgValuesSupported(null);
        return updatedWalletMetadata;
    }

    @Override
    @NotNull
    public Map<String, String> getHeadersForAuthorizationRequestUri() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"content-type", (Object)ContentType.APPLICATION_FORM_URL_ENCODED.getValue()), TuplesKt.to((Object)"accept", (Object)ContentType.APPLICATION_JSON.getValue())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    public void validateAndParseRequestFields() {
        boolean bl;
        block5: {
            super.validateAndParseRequestFields();
            if (!this.shouldValidateClient) {
                return;
            }
            String string = UtilsKt.getStringValue(this.getAuthorizationRequestParameters(), AuthorizationRequestFieldConstants.CLIENT_ID.getValue());
            Intrinsics.checkNotNull((Object)string);
            String clientId = string;
            String string2 = UtilsKt.getStringValue(this.getAuthorizationRequestParameters(), AuthorizationRequestFieldConstants.RESPONSE_URI.getValue());
            Intrinsics.checkNotNull((Object)string2);
            String responseUri = string2;
            Iterable $this$none$iv = this.trustedVerifiers;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Verifier it = (Verifier)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getClientId(), (Object)clientId) && it.getResponseUris().contains(responseUri))) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            Logger logger = Logger.INSTANCE;
            String string = PreRegisteredSchemeAuthorizationRequestHandlerKt.access$getClassName$p();
            throw Logger.handleException$default(logger, "InvalidVerifier", "Verifier is not trusted by the wallet", null, string, null, 20, null);
        }
    }

    private final boolean isValidContentType(Headers headers) {
        String string = headers.get("content-type");
        return string != null ? StringsKt.contains((CharSequence)string, (CharSequence)ContentType.APPLICATION_JSON.getValue(), (boolean)true) : false;
    }
}

