/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler.types;

import io.mosip.openID4VP.authorizationRequest.AuthorizationRequestFieldConstants;
import io.mosip.openID4VP.authorizationRequest.AuthorizationRequestUtilsKt;
import io.mosip.openID4VP.authorizationRequest.WalletMetadata;
import io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler.ClientIdSchemeBasedAuthorizationRequestHandler;
import io.mosip.openID4VP.authorizationRequest.authorizationRequestHandler.types.RedirectUriSchemeAuthorizationRequestHandlerKt;
import io.mosip.openID4VP.common.Logger;
import io.mosip.openID4VP.common.UtilsKt;
import io.mosip.openID4VP.constants.ContentType;
import io.mosip.openID4VP.constants.ResponseMode;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B9\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001c\u0010\r\u001a\u00020\n2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000fH\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016J,\u0010\u0013\u001a\u00020\n2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a8\u0006\u001b"}, d2={"Lio/mosip/openID4VP/authorizationRequest/authorizationRequestHandler/types/RedirectUriSchemeAuthorizationRequestHandler;", "Lio/mosip/openID4VP/authorizationRequest/authorizationRequestHandler/ClientIdSchemeBasedAuthorizationRequestHandler;", "authorizationRequestParameters", "", "", "", "walletMetadata", "Lio/mosip/openID4VP/authorizationRequest/WalletMetadata;", "setResponseUri", "Lkotlin/Function1;", "", "<init>", "(Ljava/util/Map;Lio/mosip/openID4VP/authorizationRequest/WalletMetadata;Lkotlin/jvm/functions/Function1;)V", "validateRequestUriResponse", "requestUriResponse", "", "process", "getHeadersForAuthorizationRequestUri", "validateAndParseRequestFields", "validateUriCombinations", "authRequestParam", "validAttribute", "inValidAttribute", "isValidContentType", "", "headers", "Lokhttp3/Headers;", "inji-openid4vp-0.3.0_release"})
public final class RedirectUriSchemeAuthorizationRequestHandler
extends ClientIdSchemeBasedAuthorizationRequestHandler {
    public RedirectUriSchemeAuthorizationRequestHandler(@NotNull Map<String, Object> authorizationRequestParameters, @Nullable WalletMetadata walletMetadata, @NotNull Function1<? super String, Unit> setResponseUri) {
        Intrinsics.checkNotNullParameter(authorizationRequestParameters, (String)"authorizationRequestParameters");
        Intrinsics.checkNotNullParameter(setResponseUri, (String)"setResponseUri");
        super(authorizationRequestParameters, walletMetadata, setResponseUri);
    }

    @Override
    public void validateRequestUriResponse(@NotNull Map<String, ? extends Object> requestUriResponse) {
        Map<String, Object> map;
        Intrinsics.checkNotNullParameter(requestUriResponse, (String)"requestUriResponse");
        if (requestUriResponse.isEmpty()) {
            map = this.getAuthorizationRequestParameters();
        } else {
            Object object = requestUriResponse.get("header");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type okhttp3.Headers");
            Headers headers = (Headers)object;
            String responseBody = String.valueOf(requestUriResponse.get("body"));
            if (this.isValidContentType(headers)) {
                Map<String, Object> authorizationRequestObject = UtilsKt.convertJsonToMap(responseBody);
                AuthorizationRequestUtilsKt.validateAuthorizationRequestObjectAndParameters(this.getAuthorizationRequestParameters(), authorizationRequestObject);
                map = authorizationRequestObject;
            } else {
                Logger logger = Logger.INSTANCE;
                String string = RedirectUriSchemeAuthorizationRequestHandlerKt.access$getClassName$p();
                throw Logger.handleException$default(logger, "InvalidData", "Authorization Request must not be signed for given client_id_scheme", null, string, null, 20, null);
            }
        }
        this.setAuthorizationRequestParameters(map);
    }

    @Override
    @NotNull
    public WalletMetadata process(@NotNull WalletMetadata walletMetadata) {
        Intrinsics.checkNotNullParameter((Object)walletMetadata, (String)"walletMetadata");
        WalletMetadata updatedWalletMetadata = walletMetadata;
        updatedWalletMetadata.setRequestObjectSigningAlgValuesSupported(null);
        return updatedWalletMetadata;
    }

    @Override
    @NotNull
    public Map<String, String> getHeadersForAuthorizationRequestUri() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"content-type", (Object)ContentType.APPLICATION_FORM_URL_ENCODED.getValue()), TuplesKt.to((Object)"accept", (Object)ContentType.APPLICATION_JSON.getValue())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    public void validateAndParseRequestFields() {
        super.validateAndParseRequestFields();
        String string = UtilsKt.getStringValue(this.getAuthorizationRequestParameters(), AuthorizationRequestFieldConstants.RESPONSE_MODE.getValue());
        if (string == null) {
            Logger logger = Logger.INSTANCE;
            String string2 = RedirectUriSchemeAuthorizationRequestHandlerKt.access$getClassName$p();
            List list = CollectionsKt.listOf((Object)AuthorizationRequestFieldConstants.RESPONSE_MODE.getValue());
            throw Logger.handleException$default(logger, "MissingInput", null, list, string2, null, 18, null);
        }
        String responseMode = string;
        String string3 = responseMode;
        if (!Intrinsics.areEqual((Object)string3, (Object)ResponseMode.DIRECT_POST.getValue()) && !Intrinsics.areEqual((Object)string3, (Object)ResponseMode.DIRECT_POST_JWT.getValue())) {
            Logger logger = Logger.INSTANCE;
            String string4 = RedirectUriSchemeAuthorizationRequestHandlerKt.access$getClassName$p();
            throw Logger.handleException$default(logger, "InvalidData", "Given response_mode is not supported", null, string4, null, 20, null);
        }
        this.validateUriCombinations(this.getAuthorizationRequestParameters(), AuthorizationRequestFieldConstants.RESPONSE_URI.getValue(), AuthorizationRequestFieldConstants.REDIRECT_URI.getValue());
    }

    private final void validateUriCombinations(Map<String, ? extends Object> authRequestParam, String validAttribute, String inValidAttribute) {
        if (authRequestParam.containsKey(inValidAttribute)) {
            Logger logger = Logger.INSTANCE;
            String string = RedirectUriSchemeAuthorizationRequestHandlerKt.access$getClassName$p();
            String string2 = inValidAttribute + " should not be present for given response_mode";
            throw Logger.handleException$default(logger, "InvalidData", string2, null, string, null, 20, null);
        }
        String data = UtilsKt.getStringValue(authRequestParam, validAttribute);
        UtilsKt.validate(validAttribute, data, RedirectUriSchemeAuthorizationRequestHandlerKt.access$getClassName$p());
        if (!Intrinsics.areEqual((Object)authRequestParam.get(validAttribute), (Object)AuthorizationRequestUtilsKt.extractClientIdentifier(authRequestParam))) {
            Logger logger = Logger.INSTANCE;
            String string = RedirectUriSchemeAuthorizationRequestHandlerKt.access$getClassName$p();
            String string3 = validAttribute + " should be equal to client_id for given client_id_scheme";
            throw Logger.handleException$default(logger, "InvalidData", string3, null, string, null, 20, null);
        }
    }

    private final boolean isValidContentType(Headers headers) {
        String string = headers.get("content-type");
        return string != null ? StringsKt.contains((CharSequence)string, (CharSequence)ContentType.APPLICATION_JSON.getValue(), (boolean)true) : false;
    }
}

