/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP.authorizationRequest.presentationDefinition;

import io.mosip.openID4VP.authorizationRequest.AuthorizationRequestFieldConstants;
import io.mosip.openID4VP.authorizationRequest.UtilsKt;
import io.mosip.openID4VP.authorizationRequest.presentationDefinition.InputDescriptor;
import io.mosip.openID4VP.authorizationRequest.presentationDefinition.PresentationDefinition;
import io.mosip.openID4VP.authorizationRequest.presentationDefinition.PresentationDefinitionSerializer;
import io.mosip.openID4VP.common.Logger;
import io.mosip.openID4VP.constants.HttpMethod;
import io.mosip.openID4VP.constants.ResponseMode;
import io.mosip.openID4VP.networkManager.NetworkManagerClient;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"className", "", "parseAndValidatePresentationDefinition", "", "authorizationRequestParameters", "", "", "isPresentationDefinitionUriSupported", "", "validateResponseModeForMsoMdocFormat", "presentationDefinitionObj", "Lio/mosip/openID4VP/authorizationRequest/presentationDefinition/PresentationDefinition;", "responseMode", "inji-openid4vp-0.3.0_release"})
@SourceDebugExtension(value={"SMAP\nPresentationDefinitionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PresentationDefinitionUtil.kt\nio/mosip/openID4VP/authorizationRequest/presentationDefinition/PresentationDefinitionUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n1755#2,3:122\n*S KotlinDebug\n*F\n+ 1 PresentationDefinitionUtil.kt\nio/mosip/openID4VP/authorizationRequest/presentationDefinition/PresentationDefinitionUtilKt\n*L\n110#1:122,3\n*E\n"})
public final class PresentationDefinitionUtilKt {
    @NotNull
    private static final String className;

    public static final void parseAndValidatePresentationDefinition(@NotNull Map<String, Object> authorizationRequestParameters, boolean isPresentationDefinitionUriSupported) {
        PresentationDefinition presentationDefinition;
        Object response;
        Intrinsics.checkNotNullParameter(authorizationRequestParameters, (String)"authorizationRequestParameters");
        boolean hasPresentationDefinition = authorizationRequestParameters.containsKey(AuthorizationRequestFieldConstants.PRESENTATION_DEFINITION.getValue());
        boolean hasPresentationDefinitionUri = authorizationRequestParameters.containsKey(AuthorizationRequestFieldConstants.PRESENTATION_DEFINITION_URI.getValue());
        Object presentationDefinition2 = null;
        if (hasPresentationDefinition && hasPresentationDefinitionUri) {
            throw Logger.handleException$default(Logger.INSTANCE, "InvalidData", "Either presentation_definition or presentation_definition_uri request param can be provided but not both", null, className, null, 20, null);
        }
        if (hasPresentationDefinition) {
            presentationDefinition2 = authorizationRequestParameters.get(AuthorizationRequestFieldConstants.PRESENTATION_DEFINITION.getValue());
            Object object = presentationDefinition2;
            io.mosip.openID4VP.common.UtilsKt.validate(AuthorizationRequestFieldConstants.PRESENTATION_DEFINITION.getValue(), object != null ? object.toString() : null, className);
        } else if (hasPresentationDefinitionUri) {
            if (!isPresentationDefinitionUriSupported) {
                Logger logger = Logger.INSTANCE;
                String string = className;
                throw Logger.handleException$default(logger, "InvalidData", "presentation_definition_uri is not support", null, string, null, 20, null);
            }
            String presentationDefinitionUri = io.mosip.openID4VP.common.UtilsKt.getStringValue(authorizationRequestParameters, AuthorizationRequestFieldConstants.PRESENTATION_DEFINITION_URI.getValue());
            io.mosip.openID4VP.common.UtilsKt.validate(AuthorizationRequestFieldConstants.PRESENTATION_DEFINITION_URI.getValue(), presentationDefinitionUri, className);
            String string = presentationDefinitionUri;
            Intrinsics.checkNotNull((Object)string);
            if (!io.mosip.openID4VP.common.UtilsKt.isValidUrl(string)) {
                Logger logger = Logger.INSTANCE;
                String string2 = className;
                String string3 = AuthorizationRequestFieldConstants.PRESENTATION_DEFINITION_URI.getValue() + " data is not valid";
                throw Logger.handleException$default(logger, "InvalidData", string3, null, string2, null, 20, null);
            }
            response = NetworkManagerClient.Companion.sendHTTPRequest$default(NetworkManagerClient.Companion, presentationDefinitionUri, HttpMethod.GET, null, null, 12, null);
            presentationDefinition2 = String.valueOf(response.get("body"));
        } else {
            throw Logger.handleException$default(Logger.INSTANCE, "InvalidData", "Either presentation_definition or presentation_definition_uri request param must be present", null, className, null, 20, null);
        }
        response = presentationDefinition2;
        if (response instanceof String) {
            presentationDefinition = (PresentationDefinition)UtilsKt.deserializeAndValidate((String)presentationDefinition2, (KSerializer)PresentationDefinitionSerializer.INSTANCE);
        } else if (response instanceof Map) {
            Object object = presentationDefinition2;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
            presentationDefinition = (PresentationDefinition)UtilsKt.deserializeAndValidate((Map)object, (KSerializer)PresentationDefinitionSerializer.INSTANCE);
        } else {
            throw Logger.handleException$default(Logger.INSTANCE, "InvalidData", "presentation_definition must be of type String or Map ", null, className, null, 20, null);
        }
        PresentationDefinition presentationDefinitionObj = presentationDefinition;
        authorizationRequestParameters.put(AuthorizationRequestFieldConstants.PRESENTATION_DEFINITION.getValue(), presentationDefinitionObj);
        String string = io.mosip.openID4VP.common.UtilsKt.getStringValue(authorizationRequestParameters, AuthorizationRequestFieldConstants.RESPONSE_MODE.getValue());
        Intrinsics.checkNotNull((Object)string);
        String responseMode = string;
        PresentationDefinitionUtilKt.validateResponseModeForMsoMdocFormat(presentationDefinitionObj, responseMode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void validateResponseModeForMsoMdocFormat(PresentationDefinition presentationDefinitionObj, String responseMode) {
        Map<String, Map<String, List<String>>> map = presentationDefinitionObj.getFormat();
        if (!(map != null ? map.containsKey("mso_mdoc") : false)) {
            Map<String, Map<String, List<String>>> map2;
            Iterable $this$any$iv = presentationDefinitionObj.getInputDescriptors();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return;
                Object element$iv = iterator.next();
                InputDescriptor it = (InputDescriptor)element$iv;
                boolean bl = false;
                map2 = it.getFormat();
            } while (!(map2 != null ? map2.containsKey("mso_mdoc") : false));
            boolean bl = true;
            if (!bl) return;
        }
        boolean bl = true;
        boolean hasMsoMdocFormat = bl;
        if (!hasMsoMdocFormat) return;
        if (Intrinsics.areEqual((Object)responseMode, (Object)ResponseMode.DIRECT_POST_JWT.getValue())) return;
        Logger logger = Logger.INSTANCE;
        String string = className;
        throw Logger.handleException$default(logger, "InvalidData", "When mso_mdoc format is present in presentation definition, response_mode must be direct_post.jwt", null, string, null, 20, null);
    }

    static {
        String string = Reflection.getOrCreateKotlinClass(PresentationDefinition.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        className = string;
    }
}

