/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP.authorizationResponse.unsignedVPToken.types.ldp;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import io.mosip.openID4VP.authorizationResponse.unsignedVPToken.UnsignedVPTokenBuilder;
import io.mosip.openID4VP.authorizationResponse.unsignedVPToken.types.ldp.UnsignedLdpVPToken;
import io.mosip.openID4VP.authorizationResponse.vpToken.types.ldp.LdpVPToken;
import io.mosip.openID4VP.authorizationResponse.vpToken.types.ldp.Proof;
import io.mosip.openID4VP.common.DateUtil;
import io.mosip.openID4VP.common.Logger;
import io.mosip.openID4VP.common.URDNA2015Canonicalization;
import io.mosip.openID4VP.constants.SignatureAlgorithm;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B=\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0014\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u000eH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/mosip/openID4VP/authorizationResponse/unsignedVPToken/types/ldp/UnsignedLdpVPTokenBuilder;", "Lio/mosip/openID4VP/authorizationResponse/unsignedVPToken/UnsignedVPTokenBuilder;", "verifiableCredential", "", "", "id", "", "holder", "challenge", "domain", "signatureSuite", "<init>", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "build", "", "inji-openid4vp-0.3.0_release"})
@SourceDebugExtension(value={"SMAP\nUnsignedLdpVPTokenBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnsignedLdpVPTokenBuilder.kt\nio/mosip/openID4VP/authorizationResponse/unsignedVPToken/types/ldp/UnsignedLdpVPTokenBuilder\n+ 2 Utils.kt\nio/mosip/openID4VP/common/UtilsKt\n*L\n1#1,61:1\n66#2,9:62\n*S KotlinDebug\n*F\n+ 1 UnsignedLdpVPTokenBuilder.kt\nio/mosip/openID4VP/authorizationResponse/unsignedVPToken/types/ldp/UnsignedLdpVPTokenBuilder\n*L\n47#1:62,9\n*E\n"})
public final class UnsignedLdpVPTokenBuilder
implements UnsignedVPTokenBuilder {
    @NotNull
    private final List<Object> verifiableCredential;
    @NotNull
    private final String id;
    @NotNull
    private final String holder;
    @NotNull
    private final String challenge;
    @NotNull
    private final String domain;
    @NotNull
    private final String signatureSuite;

    public UnsignedLdpVPTokenBuilder(@NotNull List<? extends Object> verifiableCredential, @NotNull String id, @NotNull String holder, @NotNull String challenge, @NotNull String domain, @NotNull String signatureSuite) {
        Intrinsics.checkNotNullParameter(verifiableCredential, (String)"verifiableCredential");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)challenge, (String)"challenge");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)signatureSuite, (String)"signatureSuite");
        this.verifiableCredential = verifiableCredential;
        this.id = id;
        this.holder = holder;
        this.challenge = challenge;
        this.domain = domain;
        this.signatureSuite = signatureSuite;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, Object> build() {
        String string;
        Object[] objectArray = new String[]{"https://www.w3.org/2018/credentials/v1"};
        List context = CollectionsKt.mutableListOf((Object[])objectArray);
        if (Intrinsics.areEqual((Object)this.signatureSuite, (Object)SignatureAlgorithm.Ed25519Signature2020.getValue())) {
            context.add("https://w3id.org/security/suites/ed25519-2020/v1");
        }
        if (Intrinsics.areEqual((Object)this.signatureSuite, (Object)SignatureAlgorithm.JsonWebSignature2020.getValue())) {
            context.add("https://w3id.org/security/suites/jws-2020/v1");
        }
        String string2 = this.signatureSuite;
        String string3 = DateUtil.INSTANCE.formattedCurrentDateTime();
        String string4 = this.holder;
        String string5 = this.domain;
        String string6 = this.challenge;
        LdpVPToken vpTokenSigningPayload = new LdpVPToken(context, CollectionsKt.listOf((Object)"VerifiablePresentation"), this.verifiableCredential, this.id, this.holder, new Proof(string2, string3, string6, string5, null, null, null, string4, 112, null));
        string3 = "vpTokenSigningPayload";
        String string7 = LdpVPToken.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getSimpleName(...)");
        string4 = string7;
        boolean $i$f$encodeToJsonString = false;
        try {
            ObjectMapper objectMapper$iv = ExtensionsKt.jacksonObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
            String string8 = objectMapper$iv.writeValueAsString((Object)vpTokenSigningPayload);
            string = string8;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"writeValueAsString(...)");
        }
        catch (Exception exception$iv) {
            void className$iv;
            void fieldName$iv;
            throw Logger.handleException$default(Logger.INSTANCE, "JsonEncodingFailed", exception$iv.getMessage(), CollectionsKt.listOf((Object)fieldName$iv), (String)className$iv, null, 16, null);
        }
        String vpTokenSigningPayloadString = string;
        String dataToSign = URDNA2015Canonicalization.INSTANCE.canonicalize(vpTokenSigningPayloadString);
        UnsignedLdpVPToken unsignedLdpVPToken = new UnsignedLdpVPToken(dataToSign);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"vpTokenSigningPayload", (Object)vpTokenSigningPayload), TuplesKt.to((Object)"unsignedVPToken", (Object)unsignedLdpVPToken)};
        return MapsKt.mapOf((Pair[])pairArray);
    }
}

