/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP.authorizationResponse.vpToken.types.mdoc;

import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnicodeString;
import io.mosip.openID4VP.authorizationResponse.vpToken.VPTokenBuilder;
import io.mosip.openID4VP.authorizationResponse.vpToken.types.mdoc.MdocVPToken;
import io.mosip.openID4VP.authorizationResponse.vpToken.types.mdoc.MdocVPTokenBuilderKt;
import io.mosip.openID4VP.authorizationResponse.vpTokenSigningResult.types.mdoc.DeviceAuthentication;
import io.mosip.openID4VP.authorizationResponse.vpTokenSigningResult.types.mdoc.MdocVPTokenSigningResult;
import io.mosip.openID4VP.common.CborUtilsKt;
import io.mosip.openID4VP.common.Decoder;
import io.mosip.openID4VP.common.Encoder;
import io.mosip.openID4VP.common.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/mosip/openID4VP/authorizationResponse/vpToken/types/mdoc/MdocVPTokenBuilder;", "Lio/mosip/openID4VP/authorizationResponse/vpToken/VPTokenBuilder;", "mdocVPTokenSigningResult", "Lio/mosip/openID4VP/authorizationResponse/vpTokenSigningResult/types/mdoc/MdocVPTokenSigningResult;", "mdocCredentials", "", "", "<init>", "(Lio/mosip/openID4VP/authorizationResponse/vpTokenSigningResult/types/mdoc/MdocVPTokenSigningResult;Ljava/util/List;)V", "build", "Lio/mosip/openID4VP/authorizationResponse/vpToken/types/mdoc/MdocVPToken;", "createDeviceSignature", "Lco/nstant/in/cbor/model/DataItem;", "signingAlgorithm", "signature", "throwMissingInput", "", "message", "inji-openid4vp-0.3.0_release"})
@SourceDebugExtension(value={"SMAP\nMdocVPTokenBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MdocVPTokenBuilder.kt\nio/mosip/openID4VP/authorizationResponse/vpToken/types/mdoc/MdocVPTokenBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,83:1\n1557#2:84\n1628#2,3:85\n37#3,2:88\n*S KotlinDebug\n*F\n+ 1 MdocVPTokenBuilder.kt\nio/mosip/openID4VP/authorizationResponse/vpToken/types/mdoc/MdocVPTokenBuilder\n*L\n27#1:84\n27#1:85,3\n52#1:88,2\n*E\n"})
public final class MdocVPTokenBuilder
implements VPTokenBuilder {
    @NotNull
    private final MdocVPTokenSigningResult mdocVPTokenSigningResult;
    @NotNull
    private final List<String> mdocCredentials;

    public MdocVPTokenBuilder(@NotNull MdocVPTokenSigningResult mdocVPTokenSigningResult, @NotNull List<String> mdocCredentials) {
        Intrinsics.checkNotNullParameter((Object)mdocVPTokenSigningResult, (String)"mdocVPTokenSigningResult");
        Intrinsics.checkNotNullParameter(mdocCredentials, (String)"mdocCredentials");
        this.mdocVPTokenSigningResult = mdocVPTokenSigningResult;
        this.mdocCredentials = mdocCredentials;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MdocVPToken build() {
        void $this$mapTo$iv$iv;
        this.mdocVPTokenSigningResult.validate();
        Map[] $this$map$iv = (Map[])this.mdocCredentials;
        boolean $i$f$map = false;
        Map[] mapArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            DeviceAuthentication deviceAuthentication;
            void credential;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Map document = CborUtilsKt.getDecodedMdocCredential((String)credential);
            String credentialDocType = document.get((DataItem)new UnicodeString("docType")).toString();
            if (this.mdocVPTokenSigningResult.getDocTypeToDeviceAuthentication().get(credentialDocType) == null) {
                this.throwMissingInput("Device authentication signature not found for mdoc credential docType " + credentialDocType);
                throw new KotlinNothingValueException();
            }
            String signature = deviceAuthentication.getSignature();
            String mdocAuthenticationAlgorithm = deviceAuthentication.getAlgorithm();
            DataItem deviceSignature = this.createDeviceSignature(mdocAuthenticationAlgorithm, signature);
            DataItem deviceNamespacesBytes = CborUtilsKt.tagEncodedCbor(CborUtilsKt.cborMapOf(new Pair[0]));
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"deviceSignature", (Object)deviceSignature)};
            DataItem deviceAuth = CborUtilsKt.cborMapOf(pairArray);
            Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"deviceAuth", (Object)deviceAuth), TuplesKt.to((Object)"nameSpaces", (Object)deviceNamespacesBytes)};
            DataItem deviceSigned = CborUtilsKt.cborMapOf(pairArray2);
            document.put((DataItem)new UnicodeString("deviceSigned"), deviceSigned);
            collection.add(document);
        }
        List documents = (List)destination$iv$iv;
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)"version", (Object)"1.0");
        Collection $this$toTypedArray$iv = documents;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        mapArray = thisCollection$iv.toArray(new Map[0]);
        pairArray[1] = TuplesKt.to((Object)"documents", (Object)CborUtilsKt.cborArrayOf(Arrays.copyOf(mapArray, mapArray.length)));
        pairArray[2] = TuplesKt.to((Object)"status", (Object)0);
        DataItem response = CborUtilsKt.cborMapOf(pairArray);
        return new MdocVPToken(Encoder.INSTANCE.encodeToBase64Url(CborUtilsKt.encodeCbor(response)));
    }

    private final DataItem createDeviceSignature(String signingAlgorithm, String signature) {
        byte[] base64DecodedSignature = Decoder.INSTANCE.decodeBase64Data(signature);
        byte[] cborEncodedSignature = CborUtilsKt.encodeCbor((DataItem)new ByteString(base64DecodedSignature));
        long protectedSigningAlgorithm = CborUtilsKt.mapSigningAlgorithmToProtectedAlg(signingAlgorithm);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)1, (Object)protectedSigningAlgorithm)};
        byte[] protectedHeader = CborUtilsKt.encodeCbor(CborUtilsKt.cborMapOf(pairArray));
        DataItem unprotectedHeader = CborUtilsKt.cborMapOf(new Pair[0]);
        Object[] objectArray = new Object[]{protectedHeader, unprotectedHeader, null, cborEncodedSignature};
        return CborUtilsKt.cborArrayOf(objectArray);
    }

    private final Void throwMissingInput(String message) {
        String string = MdocVPTokenBuilderKt.access$getClassName$p();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"access$getClassName$p(...)");
        throw Logger.handleException$default(Logger.INSTANCE, "MissingInput", message, null, string, null, 20, null);
    }
}

