/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP.common;

import co.nstant.in.cbor.CborBuilder;
import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborEncoder;
import co.nstant.in.cbor.builder.ArrayBuilder;
import co.nstant.in.cbor.builder.MapBuilder;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.DoublePrecisionFloat;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.NegativeInteger;
import co.nstant.in.cbor.model.Number;
import co.nstant.in.cbor.model.UnicodeString;
import co.nstant.in.cbor.model.UnsignedInteger;
import io.mosip.openID4VP.common.Decoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0004\u001a#\u0010\u0006\u001a\u00020\u00012\u0016\u0010\u0007\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\t0\b\"\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\n\u001a?\u0010\u000b\u001a\u00020\u000122\u0010\f\u001a\u001a\u0012\u0016\b\u0001\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\r0\b\"\u0012\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0006\u0012\u0004\u0018\u00010\t0\r\u00a2\u0006\u0002\u0010\u000e\u001a\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u00012\b\u0010\u0010\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0002\u001a#\u0010\u0013\u001a\u00020\u00142\u0016\u0010\u0007\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\t0\b\"\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0015\u001a\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a\u001a\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001a\u00a8\u0006\u001e"}, d2={"tagEncodedCbor", "Lco/nstant/in/cbor/model/DataItem;", "input", "encodeCbor", "", "decodeCbor", "cborArrayOf", "items", "", "", "([Ljava/lang/Object;)Lco/nstant/in/cbor/model/DataItem;", "cborMapOf", "pairs", "Lkotlin/Pair;", "([Lkotlin/Pair;)Lco/nstant/in/cbor/model/DataItem;", "toDataItem", "value", "isKey", "", "createHashedDataItem", "Lco/nstant/in/cbor/model/ByteString;", "([Ljava/lang/Object;)Lco/nstant/in/cbor/model/ByteString;", "generateHash", "getDecodedMdocCredential", "Lco/nstant/in/cbor/model/Map;", "mdocCredential", "", "mapSigningAlgorithmToProtectedAlg", "", "algorithm", "inji-openid4vp-0.3.0_release"})
@SourceDebugExtension(value={"SMAP\nCborUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CborUtils.kt\nio/mosip/openID4VP/common/CborUtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,119:1\n13346#2,2:120\n13346#2,2:122\n*S KotlinDebug\n*F\n+ 1 CborUtils.kt\nio/mosip/openID4VP/common/CborUtilsKt\n*L\n52#1:120,2\n69#1:122,2\n*E\n"})
public final class CborUtilsKt {
    @NotNull
    public static final DataItem tagEncodedCbor(@NotNull DataItem input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        long tagValue = 24L;
        DataItem taggedEncodedCborData = (DataItem)new CborBuilder().add(CborUtilsKt.encodeCbor(input)).build().get(0);
        taggedEncodedCborData.setTag(tagValue);
        Intrinsics.checkNotNull((Object)taggedEncodedCborData);
        return taggedEncodedCborData;
    }

    @NotNull
    public static final byte[] encodeCbor(@NotNull DataItem input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        new CborEncoder((OutputStream)outputStream).encode(input);
        byte[] byteArray = outputStream.toByteArray();
        outputStream.flush();
        Intrinsics.checkNotNull((Object)byteArray);
        return byteArray;
    }

    @NotNull
    public static final DataItem decodeCbor(@NotNull byte[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(input);
        List decodedData = new CborDecoder((InputStream)byteArrayInputStream).decode();
        byteArrayInputStream.close();
        Object e = decodedData.get(0);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        return (DataItem)e;
    }

    @NotNull
    public static final DataItem cborArrayOf(Object ... items) {
        Intrinsics.checkNotNullParameter((Object)items, (String)"items");
        ArrayBuilder builder = new CborBuilder().addArray();
        Object[] $this$forEach$iv = items;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            ArrayBuilder arrayBuilder;
            Object element$iv;
            Object item = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            Object object = item;
            if (object instanceof String) {
                arrayBuilder = builder.add((String)item);
                continue;
            }
            if (object instanceof byte[]) {
                arrayBuilder = builder.add((byte[])item);
                continue;
            }
            if (object instanceof Integer) {
                arrayBuilder = builder.add((long)((java.lang.Number)item).intValue());
                continue;
            }
            if (object instanceof Long) {
                arrayBuilder = builder.add(((java.lang.Number)item).longValue());
                continue;
            }
            if (object instanceof Double) {
                arrayBuilder = builder.add(((java.lang.Number)item).doubleValue());
                continue;
            }
            if (object instanceof DataItem) {
                arrayBuilder = builder.add((DataItem)item);
                continue;
            }
            if (object == null) {
                arrayBuilder = builder.add(null);
                continue;
            }
            throw new IllegalArgumentException("Unsupported type: " + Reflection.getOrCreateKotlinClass(item.getClass()));
        }
        Object e = ((CborBuilder)builder.end()).build().get(0);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        return (DataItem)e;
    }

    @NotNull
    public static final DataItem cborMapOf(Pair<? extends Object, ? extends Object> ... pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        MapBuilder builder = new CborBuilder().addMap();
        Pair<? extends Object, ? extends Object>[] $this$forEach$iv = pairs;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Pair<? extends Object, ? extends Object> element$iv;
            Pair<? extends Object, ? extends Object> pair = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            Object key = pair.component1();
            Object value = pair.component2();
            DataItem keyItem = CborUtilsKt.toDataItem(key, true);
            DataItem valueItem = CborUtilsKt.toDataItem$default(value, false, 2, null);
            builder.put(keyItem, valueItem);
        }
        Object e = ((CborBuilder)builder.end()).build().get(0);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        return (DataItem)e;
    }

    private static final DataItem toDataItem(Object value, boolean isKey) {
        DataItem dataItem;
        Object object = value;
        if (object instanceof String) {
            dataItem = (DataItem)new UnicodeString((String)value);
        } else if (object instanceof byte[]) {
            dataItem = (DataItem)new ByteString((byte[])value);
        } else if (object instanceof Integer) {
            dataItem = (DataItem)(((java.lang.Number)value).intValue() >= 0 ? (Number)new UnsignedInteger((long)((java.lang.Number)value).intValue()) : (Number)new NegativeInteger((long)((java.lang.Number)value).intValue()));
        } else if (object instanceof Long) {
            dataItem = (DataItem)(((java.lang.Number)value).longValue() >= 0L ? (Number)new UnsignedInteger(((java.lang.Number)value).longValue()) : (Number)new NegativeInteger(((java.lang.Number)value).longValue()));
        } else if (object instanceof Double) {
            dataItem = (DataItem)new DoublePrecisionFloat(((java.lang.Number)value).doubleValue());
        } else if (object instanceof DataItem) {
            dataItem = (DataItem)value;
        } else if (object == null) {
            if (isKey) {
                throw new IllegalArgumentException("Key cannot be null");
            }
            dataItem = null;
        } else {
            throw new IllegalArgumentException("Unsupported " + (isKey ? "key" : "value") + " type: " + value.getClass());
        }
        return dataItem;
    }

    static /* synthetic */ DataItem toDataItem$default(Object object, boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return CborUtilsKt.toDataItem(object, bl);
    }

    @NotNull
    public static final ByteString createHashedDataItem(Object ... items) {
        Intrinsics.checkNotNullParameter((Object)items, (String)"items");
        DataItem dataItem = CborUtilsKt.cborArrayOf(Arrays.copyOf(items, items.length));
        return new ByteString(CborUtilsKt.generateHash(dataItem));
    }

    @NotNull
    public static final byte[] generateHash(@NotNull DataItem input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] encodedCbor = CborUtilsKt.encodeCbor(input);
        byte[] hashBytes = digest.digest(encodedCbor);
        Intrinsics.checkNotNull((Object)hashBytes);
        return hashBytes;
    }

    @NotNull
    public static final Map getDecodedMdocCredential(@NotNull String mdocCredential) {
        Intrinsics.checkNotNullParameter((Object)mdocCredential, (String)"mdocCredential");
        byte[] base64DecodedMdocCredential = Decoder.INSTANCE.decodeBase64Data(mdocCredential);
        DataItem dataItem = CborUtilsKt.decodeCbor(base64DecodedMdocCredential);
        Intrinsics.checkNotNull((Object)dataItem, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.Map");
        return (Map)dataItem;
    }

    public static final long mapSigningAlgorithmToProtectedAlg(@NotNull String algorithm) {
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        return switch (algorithm) {
            case "ES256" -> -7L;
            case "ES384" -> -35L;
            case "ES512" -> -36L;
            case "EdDSA" -> -8L;
            case "PS256" -> -37L;
            case "PS384" -> -38L;
            case "PS512" -> -39L;
            default -> throw new IllegalArgumentException("Unsupported signing algorithm: " + algorithm);
        };
    }
}

