/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP.common;

import com.apicatalog.jsonld.loader.DocumentLoader;
import foundation.identity.jsonld.ConfigurableDocumentLoader;
import foundation.identity.jsonld.JsonLDObject;
import info.weboftrust.ldsignatures.LdProof;
import info.weboftrust.ldsignatures.canonicalizer.URDNA2015Canonicalizer;
import io.mosip.openID4VP.common.Encoder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\b\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lio/mosip/openID4VP/common/URDNA2015Canonicalization;", "", "<init>", "()V", "canonicalize", "", "jsonString", "getConfigurableDocumentLoader", "Lfoundation/identity/jsonld/ConfigurableDocumentLoader;", "inji-openid4vp-0.3.0_release"})
public final class URDNA2015Canonicalization {
    @NotNull
    public static final URDNA2015Canonicalization INSTANCE = new URDNA2015Canonicalization();

    private URDNA2015Canonicalization() {
    }

    @NotNull
    public final String canonicalize(@NotNull String jsonString) {
        Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
        ConfigurableDocumentLoader confDocumentLoader = this.getConfigurableDocumentLoader();
        JsonLDObject jsonLDObject = JsonLDObject.fromJson((String)jsonString);
        Intrinsics.checkNotNullExpressionValue((Object)jsonLDObject, (String)"fromJson(...)");
        JsonLDObject vcJsonLdObject = jsonLDObject;
        vcJsonLdObject.setDocumentLoader((DocumentLoader)confDocumentLoader);
        LdProof ldProof = LdProof.getFromJsonLDObject((JsonLDObject)vcJsonLdObject);
        Intrinsics.checkNotNullExpressionValue((Object)ldProof, (String)"getFromJsonLDObject(...)");
        LdProof ldProof2 = ldProof;
        URDNA2015Canonicalizer canonicalizer = new URDNA2015Canonicalizer();
        byte[] canonicalHashBytes = canonicalizer.canonicalize(ldProof2, vcJsonLdObject);
        Intrinsics.checkNotNull((Object)canonicalHashBytes);
        return Encoder.INSTANCE.encodeToBase64Url(canonicalHashBytes);
    }

    private final ConfigurableDocumentLoader getConfigurableDocumentLoader() {
        ConfigurableDocumentLoader confDocumentLoader = new ConfigurableDocumentLoader();
        confDocumentLoader.setEnableHttps(true);
        confDocumentLoader.setEnableHttp(true);
        confDocumentLoader.setEnableFile(false);
        return confDocumentLoader;
    }
}

