/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import io.mosip.openID4VP.common.Logger;
import io.mosip.openID4VP.constants.HttpMethod;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0012\n\u0000\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0001\u001a\u000e\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0001\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001\u001a$\u0010\u000e\u001a\u0004\u0018\u00010\u00012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u0010\u0011\u001a\u00020\u0001\u001a\u000e\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014\u001a \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00012\b\u0010\u0017\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0018\u001a\u00020\u0001\u001a.\u0010\u0019\u001a\u00020\u0001\"\u0006\b\u0000\u0010\u001a\u0018\u00012\u0006\u0010\u001b\u001a\u0002H\u001a2\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001H\u0086\b\u00a2\u0006\u0002\u0010\u001d\u001a\n\u0010\u001e\u001a\u00020\u0001*\u00020\u001f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"URL_PATTERN", "", "isValidUrl", "", "url", "convertJsonToMap", "", "", "jsonString", "isJWS", "input", "determineHttpMethod", "Lio/mosip/openID4VP/constants/HttpMethod;", "method", "getStringValue", "params", "", "key", "generateNonce", "minEntropy", "", "validate", "", "value", "className", "encodeToJsonString", "T", "data", "fieldName", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "toHex", "", "inji-openid4vp-0.3.0_release"})
public final class UtilsKt {
    @NotNull
    private static final String URL_PATTERN = "^https://(?:[\\w-]+\\.)+[\\w-]+(?:/[\\w\\-.~!$&'()*+,;=:@%]+)*/?(?:\\?[^#\\s]*)?(?:#.*)?$";

    public static final boolean isValidUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        CharSequence charSequence = url;
        return new Regex(URL_PATTERN).matches(charSequence);
    }

    @NotNull
    public static final Map<String, Object> convertJsonToMap(@NotNull String jsonString) {
        Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
        ObjectMapper mapper = ExtensionsKt.jacksonObjectMapper();
        Object object = mapper.readValue(jsonString, (TypeReference)new TypeReference<Map<String, Object>>(){});
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
        return (Map)object;
    }

    public static final boolean isJWS(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String[] stringArray = new String[]{"."};
        return StringsKt.split$default((CharSequence)input, (String[])stringArray, (boolean)false, (int)0, (int)6, null).size() == 3;
    }

    @NotNull
    public static final HttpMethod determineHttpMethod(@NotNull String method) {
        HttpMethod httpMethod;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        String string = method.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String string2 = string;
        if (Intrinsics.areEqual((Object)string2, (Object)"get")) {
            httpMethod = HttpMethod.GET;
        } else if (Intrinsics.areEqual((Object)string2, (Object)"post")) {
            httpMethod = HttpMethod.POST;
        } else {
            throw new IllegalArgumentException("Unsupported HTTP method: " + method);
        }
        return httpMethod;
    }

    @Nullable
    public static final String getStringValue(@NotNull Map<String, ? extends Object> params, @NotNull String key) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = params.get(key);
        return object != null ? object.toString() : null;
    }

    @NotNull
    public static final String generateNonce(int minEntropy) {
        SecureRandom secureRandom = new SecureRandom();
        char[] cArray = new char[minEntropy];
        for (int i = 0; i < minEntropy; ++i) {
            int n = i;
            int randomChar = secureRandom.nextInt(62);
            cArray[n] = (0 <= randomChar ? randomChar < 26 : false) ? (char)(65 + randomChar) : ((26 <= randomChar ? randomChar < 52 : false) ? (char)(97 + (randomChar - 26)) : (char)(48 + (randomChar - 52)));
        }
        char[] nonce = cArray;
        return new String(nonce);
    }

    public static final void validate(@NotNull String key, @Nullable String value, @NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        if (value == null || Intrinsics.areEqual((Object)value, (Object)"null") || ((CharSequence)value).length() == 0) {
            throw Logger.handleException$default(Logger.INSTANCE, value == null ? "MissingInput" : "InvalidInput", null, CollectionsKt.listOf((Object)key), className, "String", 2, null);
        }
    }

    public static final /* synthetic */ <T> String encodeToJsonString(T data, String fieldName, String className) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        boolean $i$f$encodeToJsonString = false;
        try {
            ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
            String string = objectMapper.writeValueAsString(data);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
            return string;
        }
        catch (Exception exception) {
            throw Logger.handleException$default(Logger.INSTANCE, "JsonEncodingFailed", exception.getMessage(), CollectionsKt.listOf((Object)fieldName), className, null, 16, null);
        }
    }

    @NotNull
    public static final String toHex(@NotNull byte[] $this$toHex) {
        Intrinsics.checkNotNullParameter((Object)$this$toHex, (String)"<this>");
        return ArraysKt.joinToString$default((byte[])$this$toHex, (CharSequence)"", null, null, (int)0, null, UtilsKt::toHex$lambda$0, (int)30, null);
    }

    private static final CharSequence toHex$lambda$0(byte it) {
        String string = "%02x";
        Object[] objectArray = new Object[]{it};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }
}

