/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP.jwt.jwe;

import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWTClaimsSet;
import io.mosip.openID4VP.authorizationRequest.clientMetadata.Jwk;
import io.mosip.openID4VP.common.Logger;
import io.mosip.openID4VP.jwt.jwe.JWEHandlerKt;
import io.mosip.openID4VP.jwt.jwe.encryption.EncryptionProvider;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\u000b\u001a\u00020\u00032\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/mosip/openID4VP/jwt/jwe/JWEHandler;", "", "keyEncryptionAlg", "", "contentEncryptionAlg", "publicKey", "Lio/mosip/openID4VP/authorizationRequest/clientMetadata/Jwk;", "walletNonce", "verifierNonce", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lio/mosip/openID4VP/authorizationRequest/clientMetadata/Jwk;Ljava/lang/String;Ljava/lang/String;)V", "generateEncryptedResponse", "payload", "", "inji-openid4vp-0.3.0_release"})
@SourceDebugExtension(value={"SMAP\nJWEHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JWEHandler.kt\nio/mosip/openID4VP/jwt/jwe/JWEHandler\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,49:1\n216#2,2:50\n*S KotlinDebug\n*F\n+ 1 JWEHandler.kt\nio/mosip/openID4VP/jwt/jwe/JWEHandler\n*L\n34#1:50,2\n*E\n"})
public final class JWEHandler {
    @NotNull
    private final String keyEncryptionAlg;
    @NotNull
    private final String contentEncryptionAlg;
    @NotNull
    private final Jwk publicKey;
    @NotNull
    private final String walletNonce;
    @NotNull
    private final String verifierNonce;

    public JWEHandler(@NotNull String keyEncryptionAlg, @NotNull String contentEncryptionAlg, @NotNull Jwk publicKey, @NotNull String walletNonce, @NotNull String verifierNonce) {
        Intrinsics.checkNotNullParameter((Object)keyEncryptionAlg, (String)"keyEncryptionAlg");
        Intrinsics.checkNotNullParameter((Object)contentEncryptionAlg, (String)"contentEncryptionAlg");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)walletNonce, (String)"walletNonce");
        Intrinsics.checkNotNullParameter((Object)verifierNonce, (String)"verifierNonce");
        this.keyEncryptionAlg = keyEncryptionAlg;
        this.contentEncryptionAlg = contentEncryptionAlg;
        this.publicKey = publicKey;
        this.walletNonce = walletNonce;
        this.verifierNonce = verifierNonce;
    }

    @NotNull
    public final String generateEncryptedResponse(@NotNull Map<String, ? extends Object> payload) {
        JWTClaimsSet.Builder builder;
        Intrinsics.checkNotNullParameter(payload, (String)"payload");
        JWEEncrypter encrypter = EncryptionProvider.INSTANCE.getEncrypter(this.publicKey);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"alg", (Object)this.keyEncryptionAlg), TuplesKt.to((Object)"enc", (Object)this.contentEncryptionAlg), TuplesKt.to((Object)"kid", (Object)this.publicKey.getKid()), TuplesKt.to((Object)"apu", (Object)this.walletNonce), TuplesKt.to((Object)"apv", (Object)this.verifierNonce)};
        Map headerMap = MapsKt.mapOf((Pair[])pairArray);
        JWEHeader header = JWEHeader.parse((Map)headerMap);
        JWTClaimsSet.Builder $this$generateEncryptedResponse_u24lambda_u241 = builder = new JWTClaimsSet.Builder();
        boolean bl = false;
        Map<String, ? extends Object> $this$forEach$iv = payload;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends Object>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends Object> element$iv;
            Map.Entry<String, ? extends Object> entry = element$iv = iterator.next();
            boolean bl2 = false;
            String key = entry.getKey();
            Object value = entry.getValue();
            $this$generateEncryptedResponse_u24lambda_u241.claim(key, value);
        }
        JWTClaimsSet claimsSet = builder.build();
        try {
            EncryptedJWT jwt = new EncryptedJWT(header, claimsSet);
            jwt.encrypt(encrypter);
            String string = jwt.serialize();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serialize(...)");
            return string;
        }
        catch (Exception exception) {
            throw Logger.handleException$default(Logger.INSTANCE, "JweEncryptionFailure", exception.getMessage(), null, JWEHandlerKt.access$getClassName$p(), null, 20, null);
        }
    }
}

