/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP.jwt.jwe.encryption;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.crypto.X25519Encrypter;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.OctetKeyPair;
import com.nimbusds.jose.util.Base64URL;
import io.mosip.openID4VP.authorizationRequest.clientMetadata.Jwk;
import io.mosip.openID4VP.common.Logger;
import io.mosip.openID4VP.jwt.jwe.encryption.EncryptionProviderKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"Lio/mosip/openID4VP/jwt/jwe/encryption/EncryptionProvider;", "", "<init>", "()V", "getEncrypter", "Lcom/nimbusds/jose/JWEEncrypter;", "jwk", "Lio/mosip/openID4VP/authorizationRequest/clientMetadata/Jwk;", "getPublicOctetKey", "Lcom/nimbusds/jose/jwk/OctetKeyPair;", "inji-openid4vp-0.3.0_release"})
public final class EncryptionProvider {
    @NotNull
    public static final EncryptionProvider INSTANCE = new EncryptionProvider();

    private EncryptionProvider() {
    }

    @NotNull
    public final JWEEncrypter getEncrypter(@NotNull Jwk jwk) {
        Intrinsics.checkNotNullParameter((Object)jwk, (String)"jwk");
        if (!Intrinsics.areEqual((Object)jwk.getKty(), (Object)KeyType.OKP.getValue())) {
            throw Logger.handleException$default(Logger.INSTANCE, "UnsupportedKeyExchangeAlgorithm", null, null, EncryptionProviderKt.access$getClassName$p(), null, 22, null);
        }
        return (JWEEncrypter)new X25519Encrypter(this.getPublicOctetKey(jwk));
    }

    private final OctetKeyPair getPublicOctetKey(Jwk jwk) {
        OctetKeyPair octetKeyPair = new OctetKeyPair.Builder(new Curve(jwk.getCrv()), Base64URL.from((String)jwk.getX())).keyID(jwk.getKid()).algorithm(Algorithm.parse((String)jwk.getAlg())).keyUse(new KeyUse(jwk.getUse())).build().toPublicJWK();
        Intrinsics.checkNotNullExpressionValue((Object)octetKeyPair, (String)"toPublicJWK(...)");
        return octetKeyPair;
    }
}

