/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP.jwt.jws;

import io.mosip.openID4VP.common.Decoder;
import io.mosip.openID4VP.common.Logger;
import io.mosip.openID4VP.common.UtilsKt;
import io.mosip.openID4VP.jwt.jws.JWSHandlerKt;
import io.mosip.openID4VP.jwt.keyResolver.PublicKeyResolver;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.util.encoders.Base64;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/mosip/openID4VP/jwt/jws/JWSHandler;", "", "jws", "", "publicKeyResolver", "Lio/mosip/openID4VP/jwt/keyResolver/PublicKeyResolver;", "<init>", "(Ljava/lang/String;Lio/mosip/openID4VP/jwt/keyResolver/PublicKeyResolver;)V", "verify", "", "extractDataJsonFromJws", "", "part", "Lio/mosip/openID4VP/jwt/jws/JWSHandler$JwsPart;", "JwsPart", "inji-openid4vp-0.3.0_release"})
public final class JWSHandler {
    @NotNull
    private final String jws;
    @NotNull
    private final PublicKeyResolver publicKeyResolver;

    public JWSHandler(@NotNull String jws, @NotNull PublicKeyResolver publicKeyResolver) {
        Intrinsics.checkNotNullParameter((Object)jws, (String)"jws");
        Intrinsics.checkNotNullParameter((Object)publicKeyResolver, (String)"publicKeyResolver");
        this.jws = jws;
        this.publicKeyResolver = publicKeyResolver;
    }

    public final void verify() {
        Object object;
        boolean verificationResult = false;
        try {
            object = new String[]{"."};
            List parts = StringsKt.split$default((CharSequence)this.jws, (String[])object, (boolean)false, (int)0, (int)6, null);
            String header = (String)parts.get(JwsPart.HEADER.getNumber());
            String payload = (String)parts.get(JwsPart.PAYLOAD.getNumber());
            byte[] signature = Decoder.INSTANCE.decodeBase64Data((String)parts.get(JwsPart.SIGNATURE.getNumber()));
            String publicKey = this.publicKeyResolver.resolveKey(this.extractDataJsonFromJws(JwsPart.HEADER));
            byte[] publicKeyBytes = Base64.decode((String)publicKey);
            Ed25519PublicKeyParameters publicKeyParams = new Ed25519PublicKeyParameters(publicKeyBytes, 0);
            Ed25519Signer signer = new Ed25519Signer();
            signer.init(false, (CipherParameters)publicKeyParams);
            String string = header + "." + payload;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] messageBytes = byArray;
            signer.update(messageBytes, 0, messageBytes.length);
            verificationResult = signer.verifySignature(signature);
        }
        catch (Exception ex) {
            Logger logger = Logger.INSTANCE;
            String string = JWSHandlerKt.access$getClassName$p();
            String string2 = "An unexpected exception occurred during verification: " + ex.getMessage();
            throw Logger.handleException$default(logger, "VerificationFailure", string2, null, string, null, 20, null);
        }
        if (!verificationResult) {
            Logger logger = Logger.INSTANCE;
            object = JWSHandlerKt.access$getClassName$p();
            throw Logger.handleException$default(logger, "InvalidSignature", "JWS signature verification failed", null, (String)object, null, 20, null);
        }
    }

    @NotNull
    public final Map<String, Object> extractDataJsonFromJws(@NotNull JwsPart part) {
        Intrinsics.checkNotNullParameter((Object)((Object)part), (String)"part");
        String[] stringArray = new String[]{"."};
        List components = StringsKt.split$default((CharSequence)this.jws, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String payload = (String)components.get(part.getNumber());
        byte[] decodedString = Decoder.INSTANCE.decodeBase64Data(payload);
        return UtilsKt.convertJsonToMap(new String(decodedString, Charsets.UTF_8));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lio/mosip/openID4VP/jwt/jws/JWSHandler$JwsPart;", "", "number", "", "<init>", "(Ljava/lang/String;II)V", "getNumber", "()I", "HEADER", "PAYLOAD", "SIGNATURE", "inji-openid4vp-0.3.0_release"})
    public static final class JwsPart
    extends Enum<JwsPart> {
        private final int number;
        public static final /* enum */ JwsPart HEADER = new JwsPart(0);
        public static final /* enum */ JwsPart PAYLOAD = new JwsPart(1);
        public static final /* enum */ JwsPart SIGNATURE = new JwsPart(2);
        private static final /* synthetic */ JwsPart[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private JwsPart(int number) {
            this.number = number;
        }

        public final int getNumber() {
            return this.number;
        }

        public static JwsPart[] values() {
            return (JwsPart[])$VALUES.clone();
        }

        public static JwsPart valueOf(String value) {
            return Enum.valueOf(JwsPart.class, value);
        }

        @NotNull
        public static EnumEntries<JwsPart> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = jwsPartArray = new JwsPart[]{JwsPart.HEADER, JwsPart.PAYLOAD, JwsPart.SIGNATURE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

