/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP.jwt.keyResolver.types;

import io.mosip.openID4VP.common.Logger;
import io.mosip.openID4VP.jwt.keyResolver.PublicKeyResolver;
import io.mosip.openID4VP.jwt.keyResolver.types.DidPublicKeyResolverKt;
import io.mosip.vercred.vcverifier.DidWebResolver;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00032\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\bH\u0016J&\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/mosip/openID4VP/jwt/keyResolver/types/DidPublicKeyResolver;", "Lio/mosip/openID4VP/jwt/keyResolver/PublicKeyResolver;", "didUrl", "", "<init>", "(Ljava/lang/String;)V", "resolveKey", "header", "", "", "extractPublicKeyMultibase", "kid", "didDocument", "inji-openid4vp-0.3.0_release"})
public final class DidPublicKeyResolver
implements PublicKeyResolver {
    @NotNull
    private final String didUrl;

    public DidPublicKeyResolver(@NotNull String didUrl) {
        Intrinsics.checkNotNullParameter((Object)didUrl, (String)"didUrl");
        this.didUrl = didUrl;
    }

    @Override
    @NotNull
    public String resolveKey(@NotNull Map<String, ? extends Object> header) {
        Map map;
        Intrinsics.checkNotNullParameter(header, (String)"header");
        try {
            map = new DidWebResolver(this.didUrl).resolve();
        }
        catch (Exception e) {
            Logger logger = Logger.INSTANCE;
            String string = DidPublicKeyResolverKt.access$getClassName$p();
            String string2 = e.getMessage();
            throw Logger.handleException$default(logger, "PublicKeyResolutionFailed", string2, null, string, null, 20, null);
        }
        Map didResponse = map;
        Object object = header.get("kid");
        if (object == null || (object = object.toString()) == null) {
            Logger logger = Logger.INSTANCE;
            String string = DidPublicKeyResolverKt.access$getClassName$p();
            throw Logger.handleException$default(logger, "KidExtractionFailed", "KID extraction from DID document failed", null, string, null, 20, null);
        }
        Object kid = object;
        String string = this.extractPublicKeyMultibase((String)kid, didResponse);
        if (string == null) {
            Logger logger = Logger.INSTANCE;
            String string3 = DidPublicKeyResolverKt.access$getClassName$p();
            throw Logger.handleException$default(logger, "PublicKeyExtractionFailed", "Public key extraction failed", null, string3, null, 20, null);
        }
        return string;
    }

    private final String extractPublicKeyMultibase(String kid, Map<String, ? extends Object> didDocument) {
        List verificationMethod;
        Iterator iterator = didDocument.get("verificationMethod");
        List list = verificationMethod = iterator instanceof List ? (List)((Object)iterator) : null;
        if (verificationMethod != null) {
            for (Map method : verificationMethod) {
                String publicKeyMultibase;
                Object v = method.get("id");
                String id = v instanceof String ? (String)v : null;
                Object object = method.get("publicKey");
                String string = publicKeyMultibase = object instanceof String ? (String)object : null;
                if (!Intrinsics.areEqual((Object)id, (Object)kid) || (object = (CharSequence)publicKeyMultibase) == null || object.length() == 0) continue;
                return publicKeyMultibase;
            }
        }
        return null;
    }
}

