/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.openID4VP.responseModeHandler.types;

import io.mosip.openID4VP.authorizationRequest.AuthorizationRequest;
import io.mosip.openID4VP.authorizationRequest.WalletMetadata;
import io.mosip.openID4VP.authorizationRequest.clientMetadata.ClientMetadata;
import io.mosip.openID4VP.authorizationRequest.clientMetadata.Jwk;
import io.mosip.openID4VP.authorizationRequest.clientMetadata.Jwks;
import io.mosip.openID4VP.authorizationResponse.AuthorizationResponse;
import io.mosip.openID4VP.authorizationResponse.AuthorizationResponseKt;
import io.mosip.openID4VP.common.Logger;
import io.mosip.openID4VP.constants.ContentType;
import io.mosip.openID4VP.constants.HttpMethod;
import io.mosip.openID4VP.jwt.jwe.JWEHandler;
import io.mosip.openID4VP.networkManager.NetworkManagerClient;
import io.mosip.openID4VP.responseModeHandler.ResponseModeBasedHandler;
import io.mosip.openID4VP.responseModeHandler.types.DirectPostJwtResponseModeHandlerKt;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J(\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000eH\u0016\u00a8\u0006\u001c"}, d2={"Lio/mosip/openID4VP/responseModeHandler/types/DirectPostJwtResponseModeHandler;", "Lio/mosip/openID4VP/responseModeHandler/ResponseModeBasedHandler;", "<init>", "()V", "validate", "", "clientMetadata", "Lio/mosip/openID4VP/authorizationRequest/clientMetadata/ClientMetadata;", "walletMetadata", "Lio/mosip/openID4VP/authorizationRequest/WalletMetadata;", "shouldValidateWithWalletMetadata", "", "validateWithWalletMetadata", "clientAlg", "", "clientEnc", "throwMissingInputException", "", "fieldName", "throwInvalidDataException", "message", "sendAuthorizationResponse", "authorizationRequest", "Lio/mosip/openID4VP/authorizationRequest/AuthorizationRequest;", "url", "authorizationResponse", "Lio/mosip/openID4VP/authorizationResponse/AuthorizationResponse;", "walletNonce", "inji-openid4vp-0.3.0_release"})
@SourceDebugExtension(value={"SMAP\nDirectPostJwtResponseModeHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectPostJwtResponseModeHandler.kt\nio/mosip/openID4VP/responseModeHandler/types/DirectPostJwtResponseModeHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n2632#2,3:122\n1#3:125\n*S KotlinDebug\n*F\n+ 1 DirectPostJwtResponseModeHandler.kt\nio/mosip/openID4VP/responseModeHandler/types/DirectPostJwtResponseModeHandler\n*L\n44#1:122,3\n*E\n"})
public final class DirectPostJwtResponseModeHandler
extends ResponseModeBasedHandler {
    @Override
    public void validate(@Nullable ClientMetadata clientMetadata, @Nullable WalletMetadata walletMetadata, boolean shouldValidateWithWalletMetadata) {
        boolean bl;
        block9: {
            if (clientMetadata == null) {
                boolean bl2 = false;
                this.throwInvalidDataException("client_metadata must be present for given response mode");
                throw new KotlinNothingValueException();
            }
            String string = clientMetadata.getAuthorizationEncryptedResponseAlg();
            if (string == null) {
                this.throwMissingInputException("authorization_encrypted_response_alg");
                throw new KotlinNothingValueException();
            }
            String alg = string;
            String string2 = clientMetadata.getAuthorizationEncryptedResponseEnc();
            if (string2 == null) {
                this.throwMissingInputException("authorization_encrypted_response_enc");
                throw new KotlinNothingValueException();
            }
            String enc = string2;
            Jwks jwks = clientMetadata.getJwks();
            if (jwks == null) {
                this.throwMissingInputException("jwks");
                throw new KotlinNothingValueException();
            }
            Jwks jwks2 = jwks;
            if (shouldValidateWithWalletMetadata) {
                this.validateWithWalletMetadata(alg, enc, walletMetadata);
            }
            Iterable $this$none$iv = jwks2.getKeys();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Jwk it = (Jwk)element$iv;
                    boolean bl3 = false;
                    if (!(Intrinsics.areEqual((Object)it.getAlg(), (Object)alg) && Intrinsics.areEqual((Object)it.getUse(), (Object)"enc"))) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
        }
        if (bl) {
            this.throwInvalidDataException("No jwk matching the specified algorithm found for encryption");
            throw new KotlinNothingValueException();
        }
    }

    private final void validateWithWalletMetadata(String clientAlg, String clientEnc, WalletMetadata walletMetadata) {
        if (walletMetadata == null) {
            boolean bl = false;
            this.throwInvalidDataException("wallet_metadata must be present");
            throw new KotlinNothingValueException();
        }
        List<String> list = walletMetadata.getAuthorizationEncryptionAlgValuesSupported();
        if (list == null) {
            this.throwInvalidDataException("authorization_encryption_alg_values_supported must be present in wallet_metadata");
            throw new KotlinNothingValueException();
        }
        List<String> supportedAlgs = list;
        if (!supportedAlgs.contains(clientAlg)) {
            this.throwInvalidDataException("authorization_encrypted_response_alg is not supported");
            throw new KotlinNothingValueException();
        }
        List<String> list2 = walletMetadata.getAuthorizationEncryptionEncValuesSupported();
        if (list2 == null) {
            this.throwInvalidDataException("authorization_encryption_enc_values_supported must be present in wallet_metadata");
            throw new KotlinNothingValueException();
        }
        List<String> supportedEncs = list2;
        if (!supportedEncs.contains(clientEnc)) {
            this.throwInvalidDataException("authorization_encrypted_response_enc is not supported");
            throw new KotlinNothingValueException();
        }
    }

    private final Void throwMissingInputException(String fieldName) {
        Logger logger = Logger.INSTANCE;
        String string = DirectPostJwtResponseModeHandlerKt.access$getClassName$p();
        Object[] objectArray = new String[]{"client_metadata", fieldName};
        List list = CollectionsKt.listOf((Object[])objectArray);
        throw Logger.handleException$default(logger, "MissingInput", null, list, string, null, 18, null);
    }

    private final Void throwInvalidDataException(String message) {
        Logger logger = Logger.INSTANCE;
        String string = DirectPostJwtResponseModeHandlerKt.access$getClassName$p();
        throw Logger.handleException$default(logger, "InvalidData", message, null, string, null, 20, null);
    }

    @Override
    @NotNull
    public String sendAuthorizationResponse(@NotNull AuthorizationRequest authorizationRequest, @NotNull String url, @NotNull AuthorizationResponse authorizationResponse, @NotNull String walletNonce) {
        Jwk jwk;
        Intrinsics.checkNotNullParameter((Object)authorizationRequest, (String)"authorizationRequest");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)authorizationResponse, (String)"authorizationResponse");
        Intrinsics.checkNotNullParameter((Object)walletNonce, (String)"walletNonce");
        Map<String, String> bodyParams = AuthorizationResponseKt.toJsonEncodedMap(authorizationResponse);
        ClientMetadata clientMetadata = authorizationRequest.getClientMetadata();
        Intrinsics.checkNotNull((Object)clientMetadata);
        ClientMetadata clientMetadata2 = clientMetadata;
        Object object = clientMetadata2.getJwks();
        if (object != null && (object = ((Jwks)object).getKeys()) != null) {
            Object v2;
            block3: {
                Iterable iterable = (Iterable)object;
                for (Object t : iterable) {
                    Jwk it = (Jwk)t;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getAlg(), (Object)clientMetadata2.getAuthorizationEncryptedResponseAlg()) && Intrinsics.areEqual((Object)it.getUse(), (Object)"enc"))) continue;
                    v2 = t;
                    break block3;
                }
                v2 = null;
            }
            jwk = v2;
        } else {
            jwk = null;
        }
        Intrinsics.checkNotNull(jwk);
        Jwk jwk2 = jwk;
        String string = clientMetadata2.getAuthorizationEncryptedResponseAlg();
        Intrinsics.checkNotNull((Object)string);
        String string2 = clientMetadata2.getAuthorizationEncryptedResponseEnc();
        Intrinsics.checkNotNull((Object)string2);
        JWEHandler jweHandler = new JWEHandler(string, string2, jwk2, walletNonce, authorizationRequest.getNonce());
        String encryptedBody = jweHandler.generateEncryptedResponse(bodyParams);
        Map encryptedBodyParams = MapsKt.mapOf((Pair)TuplesKt.to((Object)"response", (Object)encryptedBody));
        Map<String, Object> response = NetworkManagerClient.Companion.sendHTTPRequest(url, HttpMethod.POST, encryptedBodyParams, MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)ContentType.APPLICATION_FORM_URL_ENCODED.getValue())));
        return String.valueOf(response.get("body"));
    }
}

