/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.vercred.vcverifier;

import io.mosip.vercred.vcverifier.constants.CredentialFormat;
import io.mosip.vercred.vcverifier.credentialverifier.CredentialVerifierFactory;
import io.mosip.vercred.vcverifier.credentialverifier.VerifiableCredential;
import io.mosip.vercred.vcverifier.data.ValidationStatus;
import io.mosip.vercred.vcverifier.data.VerificationResult;
import java.util.logging.Logger;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\tH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/mosip/vercred/vcverifier/CredentialsVerifier;", "", "()V", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "verify", "Lio/mosip/vercred/vcverifier/data/VerificationResult;", "credential", "", "credentialFormat", "Lio/mosip/vercred/vcverifier/constants/CredentialFormat;", "verifyCredentials", "", "credentials", "vcverifier-aar-1.1.0-beta.1_release"})
public final class CredentialsVerifier {
    private final Logger logger = Logger.getLogger(CredentialsVerifier.class.getName());

    @Deprecated(message="This method has been deprecated because it is not extensible for future use cases of supporting different VC format's verification")
    public final boolean verifyCredentials(@Nullable String credentials) {
        if (credentials == null) {
            this.logger.severe("Error - Input credential is null");
            throw new RuntimeException("Input credential is null");
        }
        VerifiableCredential credentialVerifier = new CredentialVerifierFactory().get(CredentialFormat.LDP_VC);
        return credentialVerifier.verify(credentials);
    }

    @NotNull
    public final VerificationResult verify(@NotNull String credential, @NotNull CredentialFormat credentialFormat) {
        VerificationResult verificationResult;
        Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
        Intrinsics.checkNotNullParameter((Object)((Object)credentialFormat), (String)"credentialFormat");
        VerifiableCredential credentialVerifier = new CredentialVerifierFactory().get(credentialFormat);
        ValidationStatus validationStatus = credentialVerifier.validate(credential);
        if (((CharSequence)validationStatus.getValidationMessage()).length() > 0 && !validationStatus.getValidationErrorCode().contentEquals("ERR_VC_EXPIRED")) {
            return new VerificationResult(false, validationStatus.getValidationMessage(), validationStatus.getValidationErrorCode());
        }
        try {
            boolean verifySignatureStatus = credentialVerifier.verify(credential);
            if (!verifySignatureStatus) {
                return new VerificationResult(false, "Verification Failed", "ERR_SIGNATURE_VERIFICATION_FAILED");
            }
            verificationResult = new VerificationResult(true, validationStatus.getValidationMessage(), validationStatus.getValidationErrorCode());
        }
        catch (Exception e) {
            verificationResult = new VerificationResult(false, "Exception during Verification: " + e.getMessage(), validationStatus.getValidationErrorCode());
        }
        return verificationResult;
    }
}

