/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.vercred.vcverifier.utils;

import io.mosip.vercred.vcverifier.constants.CredentialValidatorConstants;
import io.mosip.vercred.vcverifier.exception.ValidationException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0004J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0004J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/mosip/vercred/vcverifier/utils/DateUtils;", "", "()V", "UTC", "", "dateFormats", "", "getDateFormats", "()Ljava/util/List;", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "isFutureDateWithTolerance", "", "inputDateString", "toleranceInMilliSeconds", "", "isVCExpired", "inputDate", "isValidDate", "dateValue", "parseDate", "Ljava/util/Date;", "date", "validateV1DateFields", "", "vcJsonObject", "Lorg/json/JSONObject;", "validateV2DateFields", "vcverifier-aar-1.1.0-beta.1_release"})
@SourceDebugExtension(value={"SMAP\nDateUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateUtils.kt\nio/mosip/vercred/vcverifier/utils/DateUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1855#2,2:114\n1549#2:116\n1620#2,3:117\n1549#2:120\n1620#2,3:121\n*S KotlinDebug\n*F\n+ 1 DateUtils.kt\nio/mosip/vercred/vcverifier/utils/DateUtils\n*L\n42#1:114,2\n58#1:116\n58#1:117,3\n80#1:120\n80#1:121,3\n*E\n"})
public final class DateUtils {
    @NotNull
    public static final DateUtils INSTANCE = new DateUtils();
    private static final Logger logger = Logger.getLogger(DateUtils.class.getName());
    @NotNull
    private static final List<String> dateFormats;
    @NotNull
    private static final String UTC = "UTC";

    private DateUtils() {
    }

    @NotNull
    public final List<String> getDateFormats() {
        return dateFormats;
    }

    public final boolean isValidDate(@NotNull String dateValue) {
        Intrinsics.checkNotNullParameter((Object)dateValue, (String)"dateValue");
        return CredentialValidatorConstants.INSTANCE.getDATE_REGEX().matches((CharSequence)dateValue);
    }

    @Nullable
    public final Date parseDate(@NotNull String date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Iterable $this$forEach$iv = dateFormats;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            try {
                SimpleDateFormat simpleDateFormat;
                SimpleDateFormat $this$parseDate_u24lambda_u241_u24lambda_u240 = simpleDateFormat = new SimpleDateFormat(it, Locale.getDefault());
                boolean bl2 = false;
                $this$parseDate_u24lambda_u241_u24lambda_u240.setTimeZone(TimeZone.getTimeZone(UTC));
                SimpleDateFormat format = simpleDateFormat;
                return format.parse(date);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final void validateV1DateFields(@NotNull JSONObject vcJsonObject) {
        String issuanceDate;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)vcJsonObject, (String)"vcJsonObject");
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"issuanceDate", (Object)"Validation Error: issuanceDate is not valid."), TuplesKt.to((Object)"expirationDate", (Object)"Validation Error: expirationDate is not valid.")};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String dateKey = (String)pair.component1();
            String errorMessage = (String)pair.component2();
            if (vcJsonObject.has(dateKey) && !INSTANCE.isValidDate(vcJsonObject.get(dateKey).toString())) {
                String string = dateKey.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                throw new ValidationException(errorMessage, "ERR_INVALID_" + string);
            }
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        String string = vcJsonObject.optString("issuanceDate");
        if (string == null) {
            string = "";
        }
        if (DateUtils.isFutureDateWithTolerance$default(this, issuanceDate = string, 0L, 2, null)) {
            throw new ValidationException("Validation Error: The current date time is before the issuanceDate", "ERR_ISSUANCE_DATE_IS_FUTURE_DATE");
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void validateV2DateFields(@NotNull JSONObject vcJsonObject) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)vcJsonObject, (String)"vcJsonObject");
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"validFrom", (Object)"Validation Error: validFrom is not valid."), TuplesKt.to((Object)"validUntil", (Object)"Validation Error: validUntil is not valid.")};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String dateKey = (String)pair.component1();
            String errorMessage = (String)pair.component2();
            if (vcJsonObject.has(dateKey) && !INSTANCE.isValidDate(vcJsonObject.get(dateKey).toString())) {
                String string = dateKey.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                throw new ValidationException(errorMessage, "ERR_INVALID_" + string);
            }
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        if (vcJsonObject.has("validFrom")) {
            String string = vcJsonObject.optString("validFrom");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"optString(...)");
            if (DateUtils.isFutureDateWithTolerance$default(this, string, 0L, 2, null)) {
                throw new ValidationException("Validation Error: The current date time is before the issuanceDate", "ERR_VALID_FROM_IS_FUTURE_DATE");
            }
        }
    }

    public final boolean isVCExpired(@NotNull String inputDate) {
        Intrinsics.checkNotNullParameter((Object)inputDate, (String)"inputDate");
        return ((CharSequence)inputDate).length() > 0 && !DateUtils.isFutureDateWithTolerance$default(this, inputDate, 0L, 2, null);
    }

    public final boolean isFutureDateWithTolerance(@NotNull String inputDateString, long toleranceInMilliSeconds) {
        long upperBound;
        Intrinsics.checkNotNullParameter((Object)inputDateString, (String)"inputDateString");
        Date inputDate = this.parseDate(inputDateString);
        if (inputDate == null) {
            logger.severe("Given date is not available in supported date formats");
            return false;
        }
        long currentTime = System.currentTimeMillis();
        long inputDateTime = inputDate.getTime();
        return inputDateTime > (upperBound = currentTime + toleranceInMilliSeconds);
    }

    public static /* synthetic */ boolean isFutureDateWithTolerance$default(DateUtils dateUtils, String string, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 3000L;
        }
        return dateUtils.isFutureDateWithTolerance(string, l);
    }

    static {
        Object[] objectArray = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd'T'HH:mm:ss'Z'"};
        dateFormats = CollectionsKt.listOf((Object[])objectArray);
    }
}

