/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.vercred.vcverifier.credentialverifier.verifier;

import com.apicatalog.jsonld.loader.DocumentLoader;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import foundation.identity.jsonld.ConfigurableDocumentLoader;
import foundation.identity.jsonld.JsonLDObject;
import info.weboftrust.ldsignatures.LdProof;
import info.weboftrust.ldsignatures.canonicalizer.URDNA2015Canonicalizer;
import info.weboftrust.ldsignatures.util.JWSUtil;
import io.ipfs.multibase.Base58;
import io.mosip.vercred.vcverifier.exception.PublicKeyNotFoundException;
import io.mosip.vercred.vcverifier.exception.SignatureVerificationException;
import io.mosip.vercred.vcverifier.exception.UnknownException;
import io.mosip.vercred.vcverifier.signature.SignatureVerifier;
import io.mosip.vercred.vcverifier.signature.impl.ED25519SignatureVerifierImpl;
import io.mosip.vercred.vcverifier.signature.impl.PS256SignatureVerifierImpl;
import io.mosip.vercred.vcverifier.signature.impl.RS256SignatureVerifierImpl;
import java.io.Closeable;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/mosip/vercred/vcverifier/credentialverifier/verifier/LdpVerifier;", "", "()V", "PUBLIC_KEY_ALGORITHM", "", "", "RESOLVER_API", "SIGNATURE_VERIFIER", "Lio/mosip/vercred/vcverifier/signature/SignatureVerifier;", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "provider", "Lorg/bouncycastle/jce/provider/BouncyCastleProvider;", "getConfigurableDocumentLoader", "Lfoundation/identity/jsonld/ConfigurableDocumentLoader;", "getPublicKeyFromDidVerificationMethod", "Ljava/security/PublicKey;", "verificationMethod", "Ljava/net/URI;", "signatureSuite", "getPublicKeyFromHttpVerificationMethod", "getPublicKeyMultiBase", "responseObjectNode", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "isEd25519PublicKey", "", "rawPublicKeyWithHeader", "", "verify", "credential", "vcverifier-aar-1.1.0_release"})
public final class LdpVerifier {
    private final Logger logger = Logger.getLogger(LdpVerifier.class.getName());
    @NotNull
    private BouncyCastleProvider provider = new BouncyCastleProvider();
    @NotNull
    private final Map<String, SignatureVerifier> SIGNATURE_VERIFIER;
    @NotNull
    private final Map<String, String> PUBLIC_KEY_ALGORITHM;
    @NotNull
    private final String RESOLVER_API;

    public LdpVerifier() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"PS256", (Object)new PS256SignatureVerifierImpl()), TuplesKt.to((Object)"RS256", (Object)new RS256SignatureVerifierImpl()), TuplesKt.to((Object)"EdDSA", (Object)new ED25519SignatureVerifierImpl())};
        this.SIGNATURE_VERIFIER = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"RsaSignature2018", (Object)"RSA"), TuplesKt.to((Object)"Ed25519Signature2018", (Object)"Ed25519"), TuplesKt.to((Object)"Ed25519Signature2020", (Object)"Ed25519")};
        this.PUBLIC_KEY_ALGORITHM = MapsKt.mapOf((Pair[])pairArray);
        this.RESOLVER_API = "https://resolver.identity.foundation/1.0/identifiers/";
        Security.addProvider((Provider)this.provider);
    }

    public final boolean verify(@NotNull String credential) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
        this.logger.info("Received Credentials Verification - Start");
        ConfigurableDocumentLoader confDocumentLoader = this.getConfigurableDocumentLoader();
        JsonLDObject jsonLDObject = JsonLDObject.fromJson((String)credential);
        Intrinsics.checkNotNullExpressionValue((Object)jsonLDObject, (String)"fromJson(...)");
        JsonLDObject vcJsonLdObject = jsonLDObject;
        vcJsonLdObject.setDocumentLoader((DocumentLoader)confDocumentLoader);
        try {
            CharSequence signJWS;
            LdProof ldProof = LdProof.getFromJsonLDObject((JsonLDObject)vcJsonLdObject);
            Intrinsics.checkNotNullExpressionValue((Object)ldProof, (String)"getFromJsonLDObject(...)");
            LdProof ldProof2 = ldProof;
            URDNA2015Canonicalizer canonicalizer = new URDNA2015Canonicalizer();
            byte[] byArray = canonicalizer.canonicalize(ldProof2, vcJsonLdObject);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"canonicalize(...)");
            byte[] canonicalHashBytes = byArray;
            CharSequence charSequence = ldProof2.getJws();
            if (!(charSequence == null || charSequence.length() == 0)) {
                String string = ldProof2.getJws();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getJws(...)");
                signJWS = string;
                JWSObject jWSObject = JWSObject.parse((String)signJWS);
                Intrinsics.checkNotNullExpressionValue((Object)jWSObject, (String)"parse(...)");
                JWSObject jwsObject = jWSObject;
                byte[] byArray2 = jwsObject.getSignature().decode();
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"decode(...)");
                byte[] signature = byArray2;
                byte[] byArray3 = JWSUtil.getJwsSigningInput((JWSHeader)jwsObject.getHeader(), (byte[])canonicalHashBytes);
                Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getJwsSigningInput(...)");
                byte[] actualData = byArray3;
                URI uRI = ldProof2.getVerificationMethod();
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"getVerificationMethod(...)");
                String string2 = ldProof2.getType();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getType(...)");
                PublicKey publicKeyObj = this.getPublicKeyFromHttpVerificationMethod(uRI, string2);
                SignatureVerifier signatureVerifier = this.SIGNATURE_VERIFIER.get(jwsObject.getHeader().getAlgorithm().getName());
                Intrinsics.checkNotNull((Object)signatureVerifier);
                SignatureVerifier signatureVerifier2 = signatureVerifier;
                PublicKey publicKey = publicKeyObj;
                Intrinsics.checkNotNull((Object)publicKey);
                return signatureVerifier2.verify(publicKey, actualData, signature, this.provider);
            }
            signJWS = ldProof2.getProofValue();
            if (!(signJWS == null || signJWS.length() == 0)) {
                String string = ldProof2.getProofValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProofValue(...)");
                String proofValue = string;
                String string3 = proofValue.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                byte[] signature = Base58.decode((String)string3);
                URI uRI = ldProof2.getVerificationMethod();
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"getVerificationMethod(...)");
                String string4 = ldProof2.getType();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getType(...)");
                PublicKey publicKeyObj = this.getPublicKeyFromDidVerificationMethod(uRI, string4);
                SignatureVerifier signatureVerifier = new ED25519SignatureVerifierImpl();
                PublicKey publicKey = publicKeyObj;
                Intrinsics.checkNotNull((Object)publicKey);
                return signatureVerifier.verify(publicKey, canonicalHashBytes, signature, this.provider);
            }
            bl = false;
        }
        catch (Exception e) {
            Exception exception = e;
            if (exception instanceof PublicKeyNotFoundException ? true : exception instanceof SignatureVerificationException) {
                throw e;
            }
            throw new UnknownException("Error while doing verification of verifiable credential");
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final PublicKey getPublicKeyFromHttpVerificationMethod(URI verificationMethod, String signatureSuite) throws CertificateException, KeyManagementException {
        try {
            OkHttpClient okHttpClient = new OkHttpClient.Builder().build().newBuilder().build();
            Request.Builder builder = new Request.Builder();
            URL uRL = verificationMethod.toURL();
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
            Request request = builder.url(uRL).get().build();
            Response response = okHttpClient.newCall(request).execute();
            ResponseBody responseBody = response.body();
            if (responseBody == null) return null;
            ResponseBody responseBody2 = responseBody;
            boolean bl = false;
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode jsonNode = objectMapper.readTree(responseBody2.string());
            if (!jsonNode.isObject()) throw new PublicKeyNotFoundException("Public key object is null");
            Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
            ObjectNode responseObjectNode = (ObjectNode)jsonNode;
            String publicKeyPem = responseObjectNode.get("publicKeyPem").asText();
            StringReader strReader = new StringReader(publicKeyPem);
            PemReader pemReader = new PemReader((Reader)strReader);
            PemObject pemObject = pemReader.readPemObject();
            byte[] pubKeyBytes = pemObject.getContent();
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(pubKeyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(this.PUBLIC_KEY_ALGORITHM.get(signatureSuite), (Provider)this.provider);
            PublicKey publicKey = keyFactory.generatePublic(pubKeySpec);
            return publicKey;
        }
        catch (Exception e) {
            this.logger.severe("Error Generating public key object" + e);
            throw new PublicKeyNotFoundException("Public key object is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PublicKey getPublicKeyFromDidVerificationMethod(URI verificationMethod, String signatureSuite) {
        String resolverUrl = this.RESOLVER_API + verificationMethod;
        try {
            Request.Builder builder = new Request.Builder();
            URL uRL = new URI(resolverUrl).toURL();
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
            Request request = builder.url(uRL).get().build();
            Response response = new OkHttpClient.Builder().build().newCall(request).execute();
            ResponseBody responseBody = response.body();
            if (responseBody != null) {
                Closeable closeable = (Closeable)responseBody;
                Throwable throwable = null;
                try {
                    ResponseBody responseBody2 = (ResponseBody)closeable;
                    boolean bl = false;
                    JsonNode jsonNode = new ObjectMapper().readTree(responseBody2.string());
                    if (jsonNode.isObject()) {
                        Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
                        String publicKeyMultibase = this.getPublicKeyMultiBase((ObjectNode)jsonNode);
                        String string = publicKeyMultibase.substring(1);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                        byte[] rawPublicKeyWithHeader = Base58.decode((String)string);
                        Intrinsics.checkNotNull((Object)rawPublicKeyWithHeader);
                        if (this.isEd25519PublicKey(rawPublicKeyWithHeader)) {
                            byte[] byArray = rawPublicKeyWithHeader;
                            int n = 2;
                            int n2 = rawPublicKeyWithHeader.length;
                            byte[] rawPublicKey = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
                            byte[] byArray2 = Hex.decode((String)"302a300506032b6570032100");
                            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"decode(...)");
                            byte[] publicKey = ArraysKt.plus((byte[])byArray2, (byte[])rawPublicKey);
                            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(publicKey);
                            KeyFactory keyFactory = KeyFactory.getInstance(this.PUBLIC_KEY_ALGORITHM.get(signatureSuite), (Provider)this.provider);
                            PublicKey publicKey2 = keyFactory.generatePublic(pubKeySpec);
                            return publicKey2;
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            throw new PublicKeyNotFoundException("Public key object is null");
        }
        catch (Exception e) {
            this.logger.severe("Error generating public key object " + e);
            throw new PublicKeyNotFoundException("Public key object is null");
        }
    }

    private final String getPublicKeyMultiBase(ObjectNode responseObjectNode) {
        String string = responseObjectNode.get("didDocument").get("verificationMethod").get(0).get("publicKeyMultibase").asText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asText(...)");
        return string;
    }

    private final boolean isEd25519PublicKey(byte[] rawPublicKeyWithHeader) {
        return rawPublicKeyWithHeader.length > 2 && rawPublicKeyWithHeader[0] == -19 && rawPublicKeyWithHeader[1] == 1;
    }

    private final ConfigurableDocumentLoader getConfigurableDocumentLoader() {
        ConfigurableDocumentLoader confDocumentLoader = new ConfigurableDocumentLoader();
        confDocumentLoader.setEnableHttps(true);
        confDocumentLoader.setEnableHttp(true);
        confDocumentLoader.setEnableFile(false);
        return confDocumentLoader;
    }
}

