/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.vercred.vcverifier.publicKey;

import io.ipfs.multibase.Base58;
import io.mosip.vercred.vcverifier.exception.PublicKeyNotFoundException;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002\u001a\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002\u001a\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"PUBLIC_KEY_ALGORITHM", "", "", "provider", "Lorg/bouncycastle/jce/provider/BouncyCastleProvider;", "getPublicKeyObjectFromPemPublicKey", "Ljava/security/PublicKey;", "publicKeyPem", "keyType", "getPublicKeyObjectFromPublicKeyMultibase", "isPemPublicKey", "", "str", "isPublicKeyMultibase", "publicKeyMultibase", "vcverifier-aar-1.2.0_release"})
public final class UtilsKt {
    @NotNull
    private static BouncyCastleProvider provider = new BouncyCastleProvider();
    @NotNull
    private static final Map<String, String> PUBLIC_KEY_ALGORITHM;

    public static final boolean isPublicKeyMultibase(@NotNull String publicKeyMultibase) {
        Intrinsics.checkNotNullParameter((Object)publicKeyMultibase, (String)"publicKeyMultibase");
        String string = publicKeyMultibase.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        byte[] rawPublicKeyWithHeader = Base58.decode((String)string);
        return rawPublicKeyWithHeader.length > 2 && rawPublicKeyWithHeader[0] == -19 && rawPublicKeyWithHeader[1] == 1;
    }

    public static final boolean isPemPublicKey(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return StringsKt.contains$default((CharSequence)str, (CharSequence)"BEGIN PUBLIC KEY", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final PublicKey getPublicKeyObjectFromPemPublicKey(@NotNull String publicKeyPem, @NotNull String keyType) {
        Intrinsics.checkNotNullParameter((Object)publicKeyPem, (String)"publicKeyPem");
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        try {
            StringReader strReader = new StringReader(publicKeyPem);
            PemReader pemReader = new PemReader((Reader)strReader);
            PemObject pemObject = pemReader.readPemObject();
            byte[] pubKeyBytes = pemObject.getContent();
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(pubKeyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(PUBLIC_KEY_ALGORITHM.get(keyType), (Provider)provider);
            PublicKey publicKey = keyFactory.generatePublic(pubKeySpec);
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"generatePublic(...)");
            return publicKey;
        }
        catch (Exception e) {
            throw new PublicKeyNotFoundException("Public key object is null");
        }
    }

    @NotNull
    public static final PublicKey getPublicKeyObjectFromPublicKeyMultibase(@NotNull String publicKeyPem, @NotNull String keyType) {
        Intrinsics.checkNotNullParameter((Object)publicKeyPem, (String)"publicKeyPem");
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        try {
            String string = publicKeyPem.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            byte[] rawPublicKeyWithHeader = Base58.decode((String)string);
            Intrinsics.checkNotNull((Object)rawPublicKeyWithHeader);
            byte[] byArray = rawPublicKeyWithHeader;
            int n = 2;
            int n2 = rawPublicKeyWithHeader.length;
            byte[] rawPublicKey = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
            byte[] byArray2 = Hex.decode((String)"302a300506032b6570032100");
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"decode(...)");
            byte[] publicKey = ArraysKt.plus((byte[])byArray2, (byte[])rawPublicKey);
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(publicKey);
            KeyFactory keyFactory = KeyFactory.getInstance(PUBLIC_KEY_ALGORITHM.get(keyType), (Provider)provider);
            PublicKey publicKey2 = keyFactory.generatePublic(pubKeySpec);
            Intrinsics.checkNotNullExpressionValue((Object)publicKey2, (String)"generatePublic(...)");
            return publicKey2;
        }
        catch (Exception e) {
            throw new PublicKeyNotFoundException("Public key object is null");
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"RsaVerificationKey2018", (Object)"RSA"), TuplesKt.to((Object)"Ed25519VerificationKey2018", (Object)"Ed25519"), TuplesKt.to((Object)"Ed25519VerificationKey2020", (Object)"Ed25519")};
        PUBLIC_KEY_ALGORITHM = MapsKt.mapOf((Pair[])pairArray);
    }
}

