/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.vercred.vcverifier.publicKey.impl;

import io.mosip.vercred.vcverifier.DidWebResolver;
import io.mosip.vercred.vcverifier.exception.PublicKeyNotFoundException;
import io.mosip.vercred.vcverifier.exception.PublicKeyTypeNotSupportedException;
import io.mosip.vercred.vcverifier.publicKey.PublicKeyGetter;
import io.mosip.vercred.vcverifier.publicKey.UtilsKt;
import java.net.URI;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/mosip/vercred/vcverifier/publicKey/impl/DidWebPublicKeyGetter;", "Lio/mosip/vercred/vcverifier/publicKey/PublicKeyGetter;", "()V", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "get", "Ljava/security/PublicKey;", "verificationMethod", "Ljava/net/URI;", "getKeyValue", "", "responseObjectNode", "", "", "key", "vcverifier-aar-1.2.0_release"})
public final class DidWebPublicKeyGetter
implements PublicKeyGetter {
    private final Logger logger = Logger.getLogger(DidWebPublicKeyGetter.class.getName());

    @Override
    @NotNull
    public PublicKey get(@NotNull URI verificationMethod) {
        Intrinsics.checkNotNullParameter((Object)verificationMethod, (String)"verificationMethod");
        try {
            PublicKey publicKey;
            Map<String, Object> didDocument;
            String string = verificationMethod.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            Map<String, Object> it = didDocument = new DidWebResolver(string).resolve();
            boolean bl = false;
            String publicKeyStr = this.getKeyValue(it, "publicKeyMultibase");
            String keyType = this.getKeyValue(it, "type");
            if (UtilsKt.isPemPublicKey(publicKeyStr)) {
                publicKey = UtilsKt.getPublicKeyObjectFromPemPublicKey(publicKeyStr, keyType);
            } else if (UtilsKt.isPublicKeyMultibase(publicKeyStr)) {
                publicKey = UtilsKt.getPublicKeyObjectFromPublicKeyMultibase(publicKeyStr, keyType);
            } else {
                throw new PublicKeyTypeNotSupportedException("Public Key type is not supported");
            }
            return publicKey;
        }
        catch (Exception e) {
            this.logger.severe("Error fetching public key string " + e);
            throw new PublicKeyNotFoundException(e.getMessage());
        }
    }

    private final String getKeyValue(Map<String, ? extends Object> responseObjectNode, String key) {
        Object object = responseObjectNode.get("verificationMethod");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.ArrayList<kotlin.collections.Map<kotlin.String, kotlin.Any>>{ kotlin.collections.TypeAliasesKt.ArrayList<kotlin.collections.Map<kotlin.String, kotlin.Any>> }");
        ArrayList verificationMethodList = (ArrayList)object;
        return String.valueOf(((Map)verificationMethodList.get(0)).get(key));
    }
}

