/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.vercred.vcverifier.utils;

import com.nimbusds.jose.JWSObject;
import foundation.identity.jsonld.JsonLDObject;
import info.weboftrust.ldsignatures.LdProof;
import io.mosip.vercred.vcverifier.constants.CredentialValidatorConstants;
import io.mosip.vercred.vcverifier.exception.ValidationException;
import io.mosip.vercred.vcverifier.utils.Util;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bH\u0002J\u001c\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eJ\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ$\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u000eJ\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ4\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00012\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u00182\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u000e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\tJ\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\fH\u0002J&\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010 \u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0002J\u000e\u0010!\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\""}, d2={"Lio/mosip/vercred/vcverifier/utils/ValidationHelper;", "", "()V", "checkForLanguageObject", "", "nameOrDescriptionArray", "Lorg/json/JSONArray;", "fieldPair", "Lkotlin/Pair;", "", "checkMandatoryFields", "vcJsonObject", "Lorg/json/JSONObject;", "fields", "", "validateCredentialSubject", "validateFieldsByIdAndType", "fieldName", "idMandatoryFields", "validateId", "validateIssuer", "validateJsonObjectOrArray", "value", "validator", "Lkotlin/Function1;", "errorMessage", "validateNameAndDescription", "validateProof", "vcJsonString", "validateSingleCredentialObject", "credentialSubjectObject", "validateSingleObject", "fieldValueObject", "validateType", "vcverifier-aar-1.2.0_release"})
@SourceDebugExtension(value={"SMAP\nValidationHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValidationHelper.kt\nio/mosip/vercred/vcverifier/utils/ValidationHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n1855#2,2:201\n1#3:203\n*S KotlinDebug\n*F\n+ 1 ValidationHelper.kt\nio/mosip/vercred/vcverifier/utils/ValidationHelper\n*L\n115#1:201,2\n*E\n"})
public final class ValidationHelper {
    public final void checkMandatoryFields(@NotNull JSONObject vcJsonObject, @NotNull List<String> fields) {
        Intrinsics.checkNotNullParameter((Object)vcJsonObject, (String)"vcJsonObject");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        block0: for (String field : fields) {
            String[] stringArray = new String[]{"."};
            List keys = StringsKt.split$default((CharSequence)field, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            JSONObject currentJson = vcJsonObject;
            for (String key : keys) {
                if (currentJson != null && currentJson.has(key)) {
                    if (!(currentJson.get(key) instanceof JSONObject)) continue block0;
                    currentJson = currentJson.getJSONObject(key);
                    continue;
                }
                String string = StringsKt.replace$default((String)field, (String)".", (String)"_", (boolean)false, (int)4, null).toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                String specificErrorCode = "ERR_MISSING_" + string;
                throw new ValidationException("Validation Error: Missing required field: " + field, specificErrorCode);
            }
        }
    }

    public final void validateProof(@NotNull String vcJsonString) {
        Intrinsics.checkNotNullParameter((Object)vcJsonString, (String)"vcJsonString");
        JSONObject vcJsonObject = new JSONObject(vcJsonString);
        JsonLDObject jsonLDObject = JsonLDObject.fromJson((String)vcJsonString);
        Intrinsics.checkNotNullExpressionValue((Object)jsonLDObject, (String)"fromJson(...)");
        JsonLDObject vcJsonLdObject = jsonLDObject;
        LdProof ldProof = LdProof.getFromJsonLDObject((JsonLDObject)vcJsonLdObject);
        Intrinsics.checkNotNullExpressionValue((Object)ldProof, (String)"getFromJsonLDObject(...)");
        LdProof ldProof2 = ldProof;
        if (vcJsonObject.getJSONObject("proof").has("jws")) {
            String string = ldProof2.getJws();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getJws(...)");
            String jwsToken = string;
            String string2 = JWSObject.parse((String)jwsToken).getHeader().getAlgorithm().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            String algorithmName = string2;
            if (((CharSequence)jwsToken).length() == 0 || !CredentialValidatorConstants.INSTANCE.getALGORITHMS_SUPPORTED().contains(algorithmName)) {
                String string3 = "Algorithm".toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                throw new ValidationException("Validation Error: Algorithm used in the proof is not matching with supported algorithms", "ERR_INVALID_" + string3);
            }
        }
        String string = ldProof2.getType();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getType(...)");
        String ldProofType = string;
        if (!CredentialValidatorConstants.INSTANCE.getPROOF_TYPES_SUPPORTED().contains(ldProofType)) {
            String string4 = "proof".toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            String string5 = "type".toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            throw new ValidationException("Validation Error: Proof Type is not matching with supported types", "ERR_INVALID_" + string4 + "_" + string5);
        }
    }

    public final void validateId(@NotNull JSONObject vcJsonObject) {
        Intrinsics.checkNotNullParameter((Object)vcJsonObject, (String)"vcJsonObject");
        if (vcJsonObject.has("id")) {
            Util util = new Util();
            String string = vcJsonObject.getString("id");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            if (!util.isValidUri(string)) {
                throw new ValidationException("Validation Error: Invalid URI: id", "ERR_INVALID_id");
            }
        }
    }

    public final void validateType(@NotNull JSONObject vcJsonObject) {
        Intrinsics.checkNotNullParameter((Object)vcJsonObject, (String)"vcJsonObject");
        if (vcJsonObject.has("type")) {
            JSONArray jSONArray = vcJsonObject.optJSONArray("type");
            if (jSONArray != null) {
                JSONArray types = jSONArray;
                boolean bl = false;
                if (!new Util().jsonArrayToList(types).contains("VerifiableCredential")) {
                    String string = "type".toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                    throw new ValidationException("Validation Error: type must include `VerifiableCredential`.", "ERR_INVALID_" + string);
                }
            }
        }
    }

    public final void validateIssuer(@NotNull JSONObject vcJsonObject) {
        Intrinsics.checkNotNullParameter((Object)vcJsonObject, (String)"vcJsonObject");
        if (vcJsonObject.has("issuer")) {
            Util util = new Util();
            Object object = vcJsonObject.get("issuer");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            String issuerId = util.getId(object);
            if (issuerId == null || !new Util().isValidUri(issuerId)) {
                String string = "issuer".toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                throw new ValidationException("Validation Error: Invalid URI: issuer", "ERR_INVALID_" + string);
            }
        }
    }

    public final void validateNameAndDescription(@NotNull JSONObject vcJsonObject) {
        Intrinsics.checkNotNullParameter((Object)vcJsonObject, (String)"vcJsonObject");
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"name", (Object)"Validation Error: name should be string or array of Language Object"), TuplesKt.to((Object)"description", (Object)"Validation Error: description should be string or array of Language Object")};
        List nameDescriptionList = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$forEach$iv = nameDescriptionList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair fieldPair = (Pair)element$iv;
            boolean bl = false;
            if (!vcJsonObject.has((String)fieldPair.getFirst())) continue;
            Object fieldValue = vcJsonObject.get((String)fieldPair.getFirst());
            if (fieldValue instanceof String) {
                return;
            }
            if (fieldValue instanceof JSONArray) {
                this.checkForLanguageObject((JSONArray)fieldValue, (Pair<String, String>)fieldPair);
                continue;
            }
            String string = (String)fieldPair.getSecond();
            String string2 = ((String)fieldPair.getFirst()).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            throw new ValidationException(string, "ERR_INVALID_" + string2);
        }
    }

    private final void checkForLanguageObject(JSONArray nameOrDescriptionArray, Pair<String, String> fieldPair) {
        int n = nameOrDescriptionArray.length();
        for (int i = 0; i < n; ++i) {
            JSONObject nameObject = nameOrDescriptionArray.getJSONObject(i);
            if (nameObject.has("language")) continue;
            String string = (String)fieldPair.getSecond();
            String string2 = ((String)fieldPair.getFirst()).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            throw new ValidationException(string, "ERR_INVALID_" + string2);
        }
    }

    public final void validateCredentialSubject(@NotNull JSONObject vcJsonObject) {
        Intrinsics.checkNotNullParameter((Object)vcJsonObject, (String)"vcJsonObject");
        Object credentialSubject = vcJsonObject.get("credentialSubject");
        Intrinsics.checkNotNull((Object)credentialSubject);
        this.validateJsonObjectOrArray("credentialSubject", credentialSubject, (Function1<? super JSONObject, String>)((Function1)new Function1<JSONObject, String>((Object)this){

            @NotNull
            public final String invoke(@NotNull JSONObject p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ValidationHelper.access$validateSingleCredentialObject((ValidationHelper)this.receiver, p0);
            }
        }), "credentialSubject must be a non-null object or array of objects.");
    }

    public final void validateFieldsByIdAndType(@NotNull JSONObject vcJsonObject, @NotNull String fieldName, @NotNull List<String> idMandatoryFields) {
        Intrinsics.checkNotNullParameter((Object)vcJsonObject, (String)"vcJsonObject");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter(idMandatoryFields, (String)"idMandatoryFields");
        Object fieldValue = vcJsonObject.get(fieldName);
        Intrinsics.checkNotNull((Object)fieldValue);
        this.validateJsonObjectOrArray(fieldName, fieldValue, (Function1<? super JSONObject, String>)((Function1)new Function1<JSONObject, String>(this, fieldName, idMandatoryFields){
            final /* synthetic */ ValidationHelper this$0;
            final /* synthetic */ String $fieldName;
            final /* synthetic */ List<String> $idMandatoryFields;
            {
                this.this$0 = $receiver;
                this.$fieldName = $fieldName;
                this.$idMandatoryFields = $idMandatoryFields;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull JSONObject obj) {
                Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
                return ValidationHelper.access$validateSingleObject(this.this$0, this.$fieldName, obj, this.$idMandatoryFields);
            }
        }), "Validation Error: Invalid Field: " + fieldName);
    }

    private final void validateJsonObjectOrArray(String fieldName, Object value, Function1<? super JSONObject, String> validator, String errorMessage) {
        Object object = value;
        if (object instanceof JSONArray) {
            int n = ((JSONArray)value).length();
            for (int i = 0; i < n; ++i) {
                JSONObject jsonObject = ((JSONArray)value).getJSONObject(i);
                Intrinsics.checkNotNull((Object)jsonObject);
                String result = (String)validator.invoke((Object)jsonObject);
                if (!(((CharSequence)result).length() > 0)) continue;
                String string = fieldName.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                throw new ValidationException(errorMessage, "ERR_INVALID_" + string);
            }
        } else if (object instanceof JSONObject) {
            validator.invoke(value);
        } else {
            String string = fieldName.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            throw new ValidationException(errorMessage, "ERR_INVALID_" + string);
        }
    }

    private final String validateSingleCredentialObject(JSONObject credentialSubjectObject) {
        if (credentialSubjectObject.has("id")) {
            Util util = new Util();
            String string = credentialSubjectObject.optString("id");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"optString(...)");
            if (!util.isValidUri(string)) {
                String string2 = "id".toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                throw new ValidationException("Validation Error: Invalid URI: credentialSubject.id", "ERR_INVALID_credentialSubject" + string2);
            }
        }
        return "";
    }

    private final String validateSingleObject(String fieldName, JSONObject fieldValueObject, List<String> idMandatoryFields) {
        String string;
        if (!fieldValueObject.has("type")) {
            String string2 = "Validation Error: Missing required field: " + fieldName + ".type";
            String string3 = fieldName.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            String string4 = "type".toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            throw new ValidationException(string2, "ERR_MISSING_" + string3 + "_" + string4);
        }
        boolean isIDMandatoryField = idMandatoryFields.contains(fieldName);
        if (isIDMandatoryField && !fieldValueObject.has("id")) {
            String string5 = "Validation Error: Missing required field: " + fieldName + ".id";
            String string6 = fieldName.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            String string7 = "id".toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            throw new ValidationException(string5, "ERR_MISSING_" + string6 + "_" + string7);
        }
        String it = string = fieldValueObject.optString("id");
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        String string8 = ((CharSequence)it).length() > 0 ? string : null;
        if (string8 != null) {
            String id = string8;
            boolean bl2 = false;
            if (!new Util().isValidUri(id)) {
                String string9 = "Validation Error: Invalid URI: " + fieldName + ".id";
                String string10 = fieldName.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                String string11 = "id".toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                throw new ValidationException(string9, "ERR_INVALID_" + string10 + "_" + string11);
            }
        }
        return "";
    }

    public static final /* synthetic */ String access$validateSingleCredentialObject(ValidationHelper $this, JSONObject credentialSubjectObject) {
        return $this.validateSingleCredentialObject(credentialSubjectObject);
    }

    public static final /* synthetic */ String access$validateSingleObject(ValidationHelper $this, String fieldName, JSONObject fieldValueObject, List idMandatoryFields) {
        return $this.validateSingleObject(fieldName, fieldValueObject, idMandatoryFields);
    }
}

