/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.vercred.vcverifier.credentialverifier.types.msomdoc;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborEncoder;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.MajorType;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnicodeString;
import io.mosip.vercred.vcverifier.credentialverifier.types.msomdoc.MsoMdocCredentialData;
import io.mosip.vercred.vcverifier.credentialverifier.types.msomdoc.MsoMdocVerifiableCredentialKt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0003\u001a\u00020\u0004*\u00060\u0005j\u0002`\u00062\u0006\u0010\u0007\u001a\u00020\u0004\u001a\u0010\u0010\b\u001a\u00020\u0005*\b\u0018\u00010\tj\u0002`\n\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000*\u000e\u0010\u000b\"\u0004\u0018\u00010\t2\u0004\u0018\u00010\t*\n\u0010\f\"\u00020\u00052\u00020\u0005\u00a8\u0006\r"}, d2={"logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "extractFieldValue", "", "Lco/nstant/in/cbor/model/Map;", "Lio/mosip/vercred/vcverifier/credentialverifier/types/msomdoc/IssuerSignedNamespaces;", "fieldToBeExtracted", "extractMso", "Lco/nstant/in/cbor/model/Array;", "Lio/mosip/vercred/vcverifier/credentialverifier/types/msomdoc/IssuerAuth;", "IssuerAuth", "IssuerSignedNamespaces", "vcverifier-aar-1.3.0-rc2_release"})
@SourceDebugExtension(value={"SMAP\nMsoMdocCredentialData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsoMdocCredentialData.kt\nio/mosip/vercred/vcverifier/credentialverifier/types/msomdoc/MsoMdocCredentialDataKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n1855#2:71\n1855#2,2:72\n1856#2:74\n*S KotlinDebug\n*F\n+ 1 MsoMdocCredentialData.kt\nio/mosip/vercred/vcverifier/credentialverifier/types/msomdoc/MsoMdocCredentialDataKt\n*L\n23#1:71\n28#1:72,2\n23#1:74\n*E\n"})
public final class MsoMdocCredentialDataKt {
    private static final Logger logger = Logger.getLogger(MsoMdocCredentialData.class.getName());

    @NotNull
    public static final String extractFieldValue(@NotNull Map $this$extractFieldValue, @NotNull String fieldToBeExtracted) {
        Intrinsics.checkNotNullParameter((Object)$this$extractFieldValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fieldToBeExtracted, (String)"fieldToBeExtracted");
        Map issuerSignedNamespacedData = $this$extractFieldValue;
        Collection collection = issuerSignedNamespacedData.getKeys();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getKeys(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List namespaceData;
            DataItem namespace = (DataItem)element$iv;
            boolean bl = false;
            Map $this$extractFieldValue_u24lambda_u242_u24lambda_u241 = $this$extractFieldValue;
            boolean bl2 = false;
            DataItem dataItem = issuerSignedNamespacedData.get(namespace);
            Intrinsics.checkNotNull((Object)dataItem, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.Array");
            Intrinsics.checkNotNullExpressionValue((Object)((Array)dataItem).getDataItems(), (String)"getDataItems(...)");
            Iterable $this$forEach$iv2 = namespaceData;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String elementIdentifier;
                DataItem issuerSignedItem = (DataItem)element$iv2;
                boolean bl3 = false;
                ByteArrayOutputStream encodedIssuerSignedItem = new ByteArrayOutputStream();
                new CborEncoder((OutputStream)encodedIssuerSignedItem).encode(issuerSignedItem);
                Intrinsics.checkNotNull((Object)issuerSignedItem, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.ByteString");
                Object e = new CborDecoder((InputStream)new ByteArrayInputStream(((ByteString)issuerSignedItem).getBytes())).decode().get(0);
                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.Map");
                Map decodedIssuerSignedItem = (Map)e;
                DataItem dataItem2 = MsoMdocVerifiableCredentialKt.get((DataItem)decodedIssuerSignedItem, "elementIdentifier");
                Intrinsics.checkNotNull((Object)dataItem2, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.UnicodeString");
                Intrinsics.checkNotNullExpressionValue((Object)((UnicodeString)dataItem2).getString(), (String)"getString(...)");
                if (!Intrinsics.areEqual((Object)elementIdentifier, (Object)fieldToBeExtracted)) continue;
                DataItem dataItem3 = MsoMdocVerifiableCredentialKt.get((DataItem)decodedIssuerSignedItem, "elementValue");
                Intrinsics.checkNotNull((Object)dataItem3, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.UnicodeString");
                String string = ((UnicodeString)dataItem3).getString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                return string;
            }
        }
        return "";
    }

    @NotNull
    public static final Map extractMso(@Nullable Array $this$extractMso) {
        if ($this$extractMso == null) {
            logger.severe("IssuerAuth in credential is not available");
            throw new RuntimeException("Invalid Issuer Auth");
        }
        DataItem dataItem = MsoMdocVerifiableCredentialKt.get((DataItem)$this$extractMso, 2);
        Intrinsics.checkNotNull((Object)dataItem, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.ByteString");
        DataItem decodedPayload = (DataItem)CborDecoder.decode((byte[])((ByteString)dataItem).getBytes()).get(0);
        Map mso = null;
        DataItem dataItem2 = decodedPayload;
        Object object = dataItem2 != null ? dataItem2.getMajorType() : null;
        if (object == null) {
            object = MajorType.INVALID;
        }
        if (object == MajorType.MAP) {
            Intrinsics.checkNotNull((Object)decodedPayload, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.Map");
            mso = (Map)decodedPayload;
        } else {
            DataItem dataItem3 = decodedPayload;
            Object object2 = dataItem3 != null ? dataItem3.getMajorType() : null;
            if (object2 == null) {
                object2 = MajorType.ARRAY;
            }
            if (object2 == MajorType.BYTE_STRING) {
                Intrinsics.checkNotNull((Object)decodedPayload, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.ByteString");
                DataItem decodedPayloadLevel2 = (DataItem)CborDecoder.decode((byte[])((ByteString)decodedPayload).getBytes()).get(0);
                Intrinsics.checkNotNull((Object)decodedPayloadLevel2, (String)"null cannot be cast to non-null type co.nstant.in.cbor.model.Map");
                mso = (Map)decodedPayloadLevel2;
            } else {
                throw new RuntimeException("Invalid Issuer Auth");
            }
        }
        return mso;
    }
}

