/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.vercred.vcverifier.publicKey.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.mosip.vercred.vcverifier.DidWebResolver;
import io.mosip.vercred.vcverifier.exception.PublicKeyNotFoundException;
import io.mosip.vercred.vcverifier.exception.PublicKeyTypeNotSupportedException;
import io.mosip.vercred.vcverifier.publicKey.PublicKeyGetter;
import io.mosip.vercred.vcverifier.publicKey.UtilsKt;
import java.net.URI;
import java.security.PublicKey;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J/\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/mosip/vercred/vcverifier/publicKey/impl/DidWebPublicKeyGetter;", "Lio/mosip/vercred/vcverifier/publicKey/PublicKeyGetter;", "()V", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "get", "Ljava/security/PublicKey;", "verificationMethodUri", "Ljava/net/URI;", "getKeyValue", "", "responseObjectNode", "", "", "keys", "", "(Ljava/util/Map;[Ljava/lang/String;)Ljava/lang/String;", "vcverifier-aar-1.3.0-rc2_release"})
@SourceDebugExtension(value={"SMAP\nDidWebPublicKeyGetter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DidWebPublicKeyGetter.kt\nio/mosip/vercred/vcverifier/publicKey/impl/DidWebPublicKeyGetter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1#2:81\n*E\n"})
public final class DidWebPublicKeyGetter
implements PublicKeyGetter {
    private final Logger logger = Logger.getLogger(DidWebPublicKeyGetter.class.getName());

    @Override
    @NotNull
    public PublicKey get(@NotNull URI verificationMethodUri) {
        Intrinsics.checkNotNullParameter((Object)verificationMethodUri, (String)"verificationMethodUri");
        try {
            PublicKey publicKey;
            Object v2;
            String[] stringArray;
            block14: {
                String string = verificationMethodUri.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                Map<String, Object> didDocument = new DidWebResolver(string).resolve();
                Object object = didDocument.get("verificationMethod");
                List list = object instanceof List ? (List)object : null;
                if (list == null) {
                    throw new PublicKeyNotFoundException("Verification method not found in DID document");
                }
                List verificationMethods = list;
                stringArray = (String[])verificationMethods;
                for (Object t : stringArray) {
                    Map it = (Map)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.get("id"), (Object)verificationMethodUri.toString())) continue;
                    v2 = t;
                    break block14;
                }
                v2 = null;
            }
            Map map = v2;
            if (map == null) {
                throw new PublicKeyNotFoundException("No verification methods available in DID document");
            }
            Map verificationMethod = map;
            String[] stringArray2 = new String[]{"publicKeyPem", "publicKeyMultibase", "publicKeyJwk", "publicKeyHex"};
            String publicKeyStr = this.getKeyValue(verificationMethod, stringArray2);
            stringArray = new String[]{"type"};
            String keyType = this.getKeyValue(verificationMethod, stringArray);
            if (verificationMethod.containsKey("publicKeyJwk")) {
                publicKey = UtilsKt.getPublicKeyFromJWK(publicKeyStr, keyType);
            } else if (verificationMethod.containsKey("publicKeyHex")) {
                publicKey = UtilsKt.getPublicKeyFromHex(publicKeyStr, keyType);
            } else if (verificationMethod.containsKey("publicKeyPem")) {
                publicKey = UtilsKt.getPublicKeyObjectFromPemPublicKey(publicKeyStr, keyType);
            } else if (verificationMethod.containsKey("publicKeyMultibase")) {
                publicKey = UtilsKt.getPublicKeyObjectFromPublicKeyMultibase(publicKeyStr, keyType);
            } else {
                throw new PublicKeyTypeNotSupportedException("Public Key type is not supported");
            }
            return publicKey;
        }
        catch (Exception e) {
            this.logger.severe("Error fetching public key: " + e.getMessage());
            String string = e.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            throw new PublicKeyNotFoundException(string);
        }
    }

    private final String getKeyValue(Map<String, ? extends Object> responseObjectNode, String[] keys) {
        for (String key : keys) {
            String string;
            Object object = responseObjectNode.get(key);
            if (object == null) continue;
            Object value = object;
            boolean bl = false;
            if (value instanceof String) {
                string = (String)value;
            } else {
                String string2 = new ObjectMapper().writeValueAsString(value);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"writeValueAsString(...)");
            }
            return string;
        }
        throw new PublicKeyNotFoundException("None of the provided keys were found in verification method");
    }
}

